<?php
/**
 * 
 */

namespace AppBundle\Service;

use FOS\RestBundle\Controller\FOSRestController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;

/**
 * @Route("/sipmas-question")
 */
class SipmasQuestionController extends FOSRestController
{

    /**
     * Fungsi untuk mengambil seluruh data dari object SipmasQuestion
     *
     * SortBy, SortType, Offset, Limit
     * 
     * @Route("/get-all")
     * @Method("POST")
     *
     * @param SortBy, SortType, Offset, Limit
     * @return JSON Status, Message, Data
     */
    public function getAllAction(Request $request = null, Response $response = null)
    {

        $params = (object) $request->request->all();
        $result = \AppModel\SipmasQuestion::getAll($params);
        
        return $this->json($result->Load(true));
    }

    /**
     * Fungsi untuk mengambil SipmasQuestion tertentu berdasarkan Id
     *
     * Id
     * 
     * @Route("/get-by-id")
     * @Method("POST")
     *
     * @param Id
     * @return JSON Status, Message, Data
     */
    public function getByIdAction(Request $request = null, Response $response = null)
    {

        $params = (object) $request->request->all();
        $result = \AppModel\SipmasQuestion::getById($params);
        
        return $this->json($result->Load(true));
    }

    /**
     * Fungsi untuk membuat SipmasQuestion baru
     *
     * Order, Element, KeyActivity, Output, Indicator, Options
     * 
     * @Route("/create")
     * @Method("POST")
     *
     * @param Order, Element, KeyActivity, Output, Indicator, Options
     * @return JSON Status, Message, Data
     */
    public function createAction(Request $request = null, Response $response = null)
    {

        $params = (object) $request->request->all();
        $result = \AppModel\SipmasQuestion::create($params);
        
        return $this->json($result->Load(true));
    }

    /**
     * Fungsi untuk mengubah data dari SipmasQuestion yang sudah ada
     *
     * Id, Order, Element, KeyActivity, Output, Indicator, Options
     * 
     * @Route("/update")
     * @Method("POST")
     *
     * @param Id, Order, Element, KeyActivity, Output, Indicator, Options
     * @return JSON Status, Message, Data
     */
    public function updateAction(Request $request = null, Response $response = null)
    {

        $params = (object) $request->request->all();
        $result = \AppModel\SipmasQuestion::update($params);
        
        return $this->json($result->Load(true));
    }

    /**
     * Fungsi untuk menghapus SipmasQuestion
     *
     * Id
     * 
     * @Route("/delete")
     * @Method("POST")
     *
     * @param  Id
     * @return JSON Status, Message, Data
     */
    public function deleteAction(Request $request = null, Response $response = null)
    {

        $params = (object) $request->request->all();
        $result = \AppModel\SipmasQuestion::delete($params);
        
        return $this->json($result->Load(true));
    }

    /**
     * Fungsi untuk mengimport SipmasQuestion from excel
     *
     * Path, Key 
     * 
     * @Route("/import")
     * @Method("POST")
     *
     * @param  Id
     * @return JSON Status, Message, Data
     */
    public function importAction(Request $request = null, Response $response = null)
    {
        $params = (object) $request->request->all();

        if($params->Token != 'sinergipakarya'){
            return $this->json(["Status" => 1, "Message" => "Not autorize"]);
        }

        if(!$params->Path){
            return $this->json(["Status" => 1, "Message" => "Path empty"]);
        }

        $data = \AppHelper\Excel::readExcelFile($params->Path);

        foreach ($data as $key => $value) {
            $help = 3;
            if($key > $help){
                $params = (object) [
                        "Path" => "/sipmas/questions/" . $value['C'],
                        "Key" => ($key - $help),
                        "Order" => ($key - $help),
                        "Pillar" => $value['C'],
                        "Element" => $value['E'],
                        "KeyActivity" => $value['G'],
                        "Output" => $value['I'],
                        "Indicator" => $value['L'],
                        "Options" => [
                            ["5", $value['M']],
                            ["4", $value['N']],
                            ["3", $value['O']],
                            ["2", $value['P']],
                            ["1", $value['Q']]
                        ]
                    ];
        
                $result = \AppModel\SipmasQuestion::create($params);
            }
        }

        return $this->json(["Status" => 1]);
    }    

}
