<?php

namespace AuthenticationBundle\Annotation; 

/**
* @Annotation
*/
class Login {

	protected $role = '';
	protected $required = true;
	protected $not_allowed_url = '';
	protected $redirect_url = '';

	public function __construct(array $params = [])
	{
		foreach ($params as $key => $value) {
			if (property_exists($this, $key)) {
				$this->{$key} = $value;
			}
		}
	}
	
	public function getRole()
	{
		return $this->role;
	}

	public function isRequired()
	{
		return $this->required;
	}

	public function getRedirectUrl()
	{
		return $this->redirect_url;
	}

	public function getNotAllowedUrl()
	{
		return $this->not_allowed_url;
	}

}