<?php

namespace AuthenticationBundle\EventSubscriber;

use Symfony\Component\HttpKernel\Event\FilterResponseEvent;
use Symfony\Component\HttpKernel\Event\FilterControllerEvent;
use Doctrine\Common\Util\ClassUtils;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Symfony\Component\HttpKernel\KernelEvents;
use Symfony\Component\HttpFoundation\RedirectResponse;
use Symfony\Component\HttpKernel\Exception\AccessDeniedHttpException;
use Lcobucci\JWT\Parser;
use Lcobucci\JWT\ValidationData;

/**
* 
*/
class AuthenticationSubscriber implements EventSubscriberInterface
{
	
    protected $_redirect_url;
	protected $_not_allowed_url;
	protected $_reader;
    protected $_change_password_url;
    protected $_method_annotation;
    protected $_class_annotation;

	function __construct($reader, $redirect_url, $not_allowed_url, $change_password_url)
	{
        $this->_reader = $reader;
        $this->_redirect_url = $redirect_url;
		$this->_not_allowed_url = $not_allowed_url;
        $this->_change_password_url = $change_password_url;
	}

	public static function getSubscribedEvents()
    {
        return array(
            KernelEvents::CONTROLLER => 'onKernelController',
	        KernelEvents::RESPONSE => 'onKernelResponse',
        );
    }

	public function onKernelController(FilterControllerEvent $event)
	{

		$controller = $event->getController();
        if (!is_array($controller)) {
            return;
        }

        list($controller_object, $method_name) = $controller;

        $this->handleAuthToken($event, $controller_object, $method_name);

	}

	public function onKernelResponse(FilterResponseEvent $event)
	{

    }
    
    public function handleAuthToken(FilterControllerEvent $event, $controller_object, $method_name)
    {
        $session = $event->getRequest()->getSession();
        $auth_token = $session->get('auth_token');

        $annotation = 'AuthenticationBundle\Annotation\Login';
        
        // Get class annotation
        // Using ClassUtils::getClass in case the controller is an proxy
        $this->_class_annotation = $this->_reader->getClassAnnotation(
            new \ReflectionClass(ClassUtils::getClass($controller_object)), $annotation
        );

        // Get method annotation
        $controller_reflection_object = new \ReflectionObject($controller_object);
        $reflectionMethod = $controller_reflection_object->getMethod($method_name);
        $this->_method_annotation = $this->_reader->getMethodAnnotation($reflectionMethod,$annotation);
        
        if ($this->_method_annotation || $this->_class_annotation) {
                
            if(empty($auth_token)) {
                $this->setRedirectResponseAuthFailed($event);
            } else {
                // Validate JWT Auth Token
                $token = (new Parser())->parse((string) $auth_token);
                $data = new ValidationData();
                $data->setIssuer($event->getRequest()->getSchemeAndHttpHost());
                $data->setAudience($event->getRequest()->getSchemeAndHttpHost());
                $is_validate = $token->validate($data);

                if ($this->_method_annotation && $this->_method_annotation->isRequired()) {
                    if (!$is_validate) { 
                        $this->setRedirectResponseAuthFailed($event);
                    } else {
                        if($is_validate == false) $this->setRedirectResponseAuthFailed($event);
                    }
                    $this->checkPermission($event, $token, $this->_class_annotation, $this->_method_annotation);
                } elseif (!$mthis->_ethod_annotation && $this->_class_annotation && $this->_class_annotation->isRequired()) {
                    if (!$is_validate) {
                        $this->setRedirectResponseAuthFailed($event);
                    } else {
                        if($is_validate == false) $this->setRedirectResponseAuthFailed($event);
                    }
                    $this->checkPermission($event, $token, $this->_class_annotation, $this->_method_annotation);
                }

            }
        }
    }

    private function checkPermission(&$event, $token, $class_annotation, $method_annotation)
    {

        $role = [];
        
        if ($method_annotation && $method_annotation->getRole()) {
            $role = explode(",", preg_replace('/\s+/', '', $method_annotation->getRole()));
        } elseif (!$method_annotation && $class_annotation && count($class_annotation->getRole())) {
            $role = explode(",", preg_replace('/\s+/', '', $class_annotation->getRole()));
        }

        if (in_array($token->getClaim('Role'), $role)) $this->success($event, $token);
        else $this->setRedirectResponseNotAllowed($event);
    }

    private function success(&$event, $token)
    {
        $event->getRequest()->request->set('auth_user_id', $token->getClaim('UserId'));
        $event->getRequest()->request->set('auth_name', $token->getClaim('Name'));
        $event->getRequest()->request->set('auth_email', $token->getClaim('Email'));
        $event->getRequest()->request->set('auth_role', $token->getClaim('Role'));
        $event->getRequest()->request->set('auth_scope', $token->getClaim('Scope'));
    }

    private function setRedirectResponseNotAllowed(&$event)
    {
        if($this->_method_annotation->getNotAllowedUrl()){
            $this->_not_allowed_url = $this->_method_annotation->getNotAllowedUrl();
        }

        $this->setRedirectResponse($event, $this->_not_allowed_url);
    }

    private function setRedirectResponseAuthFailed(&$event)
    {
        if($this->_method_annotation->getRedirectUrl()){
            $this->_redirect_url = $this->_method_annotation->getRedirectUrl();
        }

        $this->setRedirectResponse($event, $this->_redirect_url);
        
        /*
        $last_pass_date = $user_login->PasswordLastModifiedDate;
        $password_age = \AppHelper\General::daysBetween($last_pass_date->date);
        $max_age = \CustomHelper\General::getGlobalVariable('GLOBAL_MAX_PASSWORD_AGE');
        
        $change_password_url = $this->_change_password_url;

        // Check password age no more than max password age
        if($password_age) {
            if($password_age > $max_age) {
                $event->setController(function() use ($change_password_url) {
                    return new RedirectResponse($change_password_url);
                });
            }
        }
        */
    }

    private function setRedirectResponse(&$event, $url)
    {
        $event->setController(function() use ($url) {
            return new RedirectResponse($url);
        });

    }

}