<?php
/**
 * 
 */

namespace AuthenticationModel; 

use \Pimcore\Model\DataObject;
use \AppHelper\Manager;
use Lcobucci\JWT\Builder;
use Lcobucci\JWT\Signer\Hmac\Sha256;
use Lcobucci\JWT\Parser;

class User
{
	
	/**
	 * Fungsi untuk mengambil seluruh data dari object User
	 * 
	 * @param  stdClass $params SortBy, SortType, Offset, Limit
	 * @return stdClass	Status, Message, Data
	 */
	public static function getAll($params = null) {
		
		$return = new Manager();
		
		try {

			$objects = new DataObject\User\Listing();
			
			if ($params->Condition) {
				$objects->setCondition($params->Condition, $params->ConditionArray);
			}

			$count = count($objects);
			$return->Count = $count;

			if ($params->SortBy) {
				$objects->setOrderKey($params->SortBy);
			}
			if ($params->SortType) {
				$objects->setOrder($params->SortType);		
			}		
			if ($params->Limit) {
				$objects->setLimit($params->Limit);		
			}		
			if ($params->Offset) {
				$objects->setOffset($params->Offset);		
			}

			if (!$count && !count($objects)) {
				$return->Message = 'Data tidak ditemukan';
			} else {
				$return->Status = 1;
				$return->Data = $objects->load();
			}

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}
		
		return $return;	
	}
	
	/**
	 * Fungsi untuk mengambil User tertentu berdasarkan Id
	 * 
	 * @param  stdClass $params Id
	 * @return stdClass	Status, Message, Data
	 */
	public static function getById($params = null) {
		
		$return = new Manager();

		if (!$params->Id) {
			$return->Message = 'ID kosong';
			return $return;
		}

		try {

			$object = DataObject\User::getById($params->Id);
			if (!$object) {
				$return->Message = 'Data tidak ditemukan';
			} else {
				$return->Status = 1;
				$return->Data = $object;
			}

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}

		return $return;	
	}
	
	/**
	 * Fungsi untuk membuat User baru
	 * 
	 * @param  stdClass $params Email, Password, Role, LoginAttempts, PasswordLastModified, LastPasswordUsed, TempCode, StatusAccount, NextForgotPasswordEmail, NextActivationEmail, Organization, OrganizationUnit, Name, Dob, Gender, Phone, Province, City, Education, Departement, Nip, ProfilePicture
	 * @return stdClass	Status, Message, Data
	 */
	public static function create($params = null) {

		$return = new Manager();
		
		if (!$params->Email) {
			$return->Message = 'Email kosong';
			return $return;
		}
		
		
		try {

			// check path of object
			$path = $params->Path ? $params->Path : '/user';
			$exist_path  = \AppHelper\General::checkObjectPath($path, 1);
			if(!$exist_path){
				$return->Message = 'Path object not exist';
				return $return;
			}				
			$object_path = DataObject\AbstractObject::getByPath($path);
			
			// check key name of object 
			$object_key = $params->Key ? $params->Key : microtime(true) .'_'. rand();
		
			// Inisialisasi object
			$object = DataObject\User::create();

			// Set core
			$object->setKey(\Pimcore\File::getValidFilename($object_key));
			$object->setParentId($object_path->o_id);
			$object->setIndex(0); 
	        $object->setPublished($params->Published ? $params->Published : 1);

	        // Set data
			$object->setEmail($params->Email);
			$object->setPassword($params->Password);

			if ($params->Role) {
				$role = DataObject\AbstractObject::getById($params->Role);
				if ($role) {
					$object->setRole($role);
				}
			}

			$object->setLoginAttempts($params->LoginAttempts);
			if ($params->PasswordLastModified) {
				$password_last_modified = new \DateTime($params->PasswordLastModified);
				$object->setPasswordLastModified($password_last_modified);
			}
			$object->setLastPasswordUsed($params->LastPasswordUsed);
			$object->setTempCode($params->TempCode);
			$object->setStatusAccount($params->StatusAccount);
			if ($params->NextForgotPasswordEmail) {
				$next_forgot_password_email = new \DateTime($params->NextForgotPasswordEmail);
				$object->setNextForgotPasswordEmail($next_forgot_password_email);
			}
			if ($params->NextActivationEmail) {
				$next_activation_email = new \DateTime($params->NextActivationEmail);
				$object->setNextActivationEmail($next_activation_email);
			}

			if ($params->Organization) {
				$organization = DataObject\AbstractObject::getById($params->Organization);
				if ($organization) {
					$object->setOrganization($organization);
				}
			}


			if ($params->OrganizationUnit) {
				$organization_unit = DataObject\AbstractObject::getById($params->OrganizationUnit);
				if ($organization_unit) {
					$object->setOrganizationUnit($organization_unit);
				}
			}

			$object->setName($params->Name);
			if ($params->Dob) {
				$dob = new \DateTime($params->Dob);
				$object->setDob($dob);
			}
			$object->setGender($params->Gender);
			$object->setPhone($params->Phone);
			$object->setProvince($params->Province);
			$object->setCity($params->City);
			$object->setEducation($params->Education);
			$object->setInstitute($params->Institute);
			$object->setInstituteSection($params->InstituteSection);
			$object->setDepartement($params->Departement);
			$object->setNip($params->Nip);

			if ($params->ProfilePicture) {
				$profile_picture_image;
				$profile_picture_image_params = new stdClass;
				if (isset($params->ProfilePicture['tmp_name'])) {
					$profile_picture_image = $params->ProfilePicture;
				} else {
					$profile_picture_image = [];
					$profile_picture_image['Data'] = $params->ProfilePicture;
					$profile_picture_image['Name'] = microtime(true) .'.jpg';
					$profile_picture_image_params->Type = 'base64';
				}
				$profile_picture_image_params->Path = '/user';
				$profile_picture_image_params->Image = $profile_picture_image;
				$asset = \AppHelper\Asset::uploadFileToAsset($profile_picture_image_params);
				if ($asset) {
					$object->setProfilePicture($asset);
				}
			}


	        if ($object->save()) {
	        	$return->Status = 1;
	        	$return->Data = $object;
	        } else {
	        	$return->Message = 'Data gagal disimpan';
	        }

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}

		return $return;	
	}
	
	/**
	 * Fungsi untuk mengubah data dari User yang sudah ada
	 * 
	 * @param  stdClass $params Id, Email, Password, Role, LoginAttempts, PasswordLastModified, LastPasswordUsed, TempCode, StatusAccount, NextForgotPasswordEmail, NextActivationEmail, Organization, OrganizationUnit, Name, Dob, Gender, Phone, Province, City, Education, Departement, Nip, ProfilePicture
	 * @return stdClass	Status, Message, Data
	 */
	public static function update($params = null) {
		
		$return = new Manager();

		if (!$params->Id) {
			$return->Message = 'ID kosong';
		}
		
		try {

			$object = DataObject\User::getById($params->Id);
			if (!$object) {
				$return->Message = 'Data tidak ditemukan';
			}

	        // Set data
			if ($params->Email) {
				$object->setEmail($params->Email);
			}
			if ($params->Password) {
				$object->setPassword($params->Password);
			}
			if ($params->Role) {
				$role = DataObject\AbstractObject::getById($params->Role);
				if ($role) {
					$object->setRole($role);
				}
			}
			if ($params->LoginAttempts) {
				$object->setLoginAttempts($params->LoginAttempts);
			}
			if ($params->PasswordLastModified) {
				$password_last_modified = new \DateTime($params->PasswordLastModified);
				$object->setPasswordLastModified($password_last_modified);
			}
			if ($params->LastPasswordUsed) {
				$object->setLastPasswordUsed($params->LastPasswordUsed);
			}
			if ($params->TempCode) {
				$object->setTempCode($params->TempCode);
			}
			if ($params->StatusAccount) {
				$object->setStatusAccount($params->StatusAccount);
			}
			if ($params->NextForgotPasswordEmail) {
				$next_forgot_password_email = new \DateTime($params->NextForgotPasswordEmail);
				$object->setNextForgotPasswordEmail($next_forgot_password_email);
			}
			if ($params->NextActivationEmail) {
				$next_activation_email = new \DateTime($params->NextActivationEmail);
				$object->setNextActivationEmail($next_activation_email);
			}
			if ($params->Organization) {
				$organization = DataObject\AbstractObject::getById($params->Organization);
				if ($organization) {
					$object->setOrganization($organization);
				}
			}
			if ($params->OrganizationUnit) {
				$organization_unit = DataObject\AbstractObject::getById($params->OrganizationUnit);
				if ($organization_unit) {
					$object->setOrganizationUnit($organization_unit);
				}
			}
			if ($params->Name) {
				$object->setName($params->Name);
			}
			if ($params->Dob) {
				$dob = new \DateTime($params->Dob);
				$object->setDob($dob);
			}
			if ($params->Gender) {
				$object->setGender($params->Gender);
			}
			if ($params->Phone) {
				$object->setPhone($params->Phone);
			}
			if ($params->Province) {
				$object->setProvince($params->Province);
			}
			if ($params->City) {
				$object->setCity($params->City);
			}
			if ($params->Institute) {
				$object->setInstitute($params->Institute);
			}
			if ($params->InstituteSection) {
				$object->setInstituteSection($params->InstituteSection);
			}
			if ($params->Education) {
				$object->setEducation($params->Education);
			}
			if ($params->Departement) {
				$object->setDepartement($params->Departement);
			}
			if ($params->Nip) {
				$object->setNip($params->Nip);
			}

			if ($params->ProfilePicture) {
				$profile_picture_image;
				$profile_picture_image_params = new \stdClass;
				if (isset($params->ProfilePicture['tmp_name'])) {
					$profile_picture_image = $params->ProfilePicture;
				} else {
					$profile_picture_image = [];
					$profile_picture_image['Data'] = $params->ProfilePicture;
					$profile_picture_image['Name'] = microtime(true) .'.jpg';
					$profile_picture_image_params->Type = 'base64';
				}
				$profile_picture_image_params->Path = '/user';
				$profile_picture_image_params->Image = $profile_picture_image;
				$asset = \AppHelper\Asset::uploadFileToAsset($profile_picture_image_params);
				if ($asset) {
					if ($object->ProfilePicture) {
						$object->ProfilePicture->delete();
					}
					$object->setProfilePicture($asset);
				}
			}

	        if ($object->save()) {
	        	$return->Status = 1;
	        	$return->Data = $object;
	        } else {
	        	$return->Message = 'Data gagal diubah';
	        }

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}

		return $return;
	}
	
	/**
	 * Fungsi untuk menghapus User
	 * 
	 * @param  stdClass $params Id
	 * @return stdClass	Status, Message, Data
	 */
	public static function delete($params = null) {
		
		$return = new Manager();

		if (!$params->Id) {
			$return->Message = 'ID kosong';
		}

		try {

			$object = DataObject\User::getById($params->Id);
			if (!$object) {
				$return->Message = 'Data tidak ditemukan';
			} else {
				$object->delete();
				$return->Status = 1;
			}

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}

		return $return;
	}

	/* self modification--------------------------------------------------------------------------------------- */

	public static function authentication($params = null) {

		$return = new Manager();
		$max_fail_login = \CustomHelper\General::getGlobalVariable('GLOBAL_MAX_FAIL_LOGIN');

		if(!$params->Email) {
			$return->Message = 'Username/Email kosong';
		}

		if(!$params->Password) {
			$return->Message = 'Password kosong';
		}
		
		try {
			
			$object = DataObject\User::getByEmail($params->Email, 1);
			if($object) {				
				if(!$object->StatusAccount){
					$return->Message = 'Akun Anda belum diaktifasi, silakan masukkan kode aktifasi yang sudah dikirim via Email <br/><br/><br/> <input type="text" class="input-verification-code"> <br/><br/> <a href="javascript:void(0)" class="p-0 m-0" onclick="sendEmailVerification()">Kirim ulang kode aktivasi</a> <br><br> <span class="message-verification-code"></span> <br>';					
					return $return;
				}

				if($params->Role){				
					if($object->Role->Name != $params->Role){
						$return->Message = 'Maaf akun Anda tidak memiliki akses, silakan kembali melakukan pendaftaran akun <br /><br /><br /> <a href="javascript:void(0)" class="p-0 m-0" onclick="showRegistrationForm()">Daftar sekarang</a> <br><br>';
						return $return;
					}				
				}
				
				if($object->Password == md5($params->Password)) {
					$object->setLoginAttempts(0);
					$object->save();

					$return->Status = 1;
					$return->Data = $object;
					$return->Role = $object->Role->Name;
					$return->Scope = 'global';
				} else {
					$object->LoginAttempts += 1;
					$object->setLoginAttempts($object->LoginAttempts);
					$object->save();

					if($object->LoginAttempts >= $max_fail_login) {
						// For now it just set loginattempts to 0 again, because its not implemented yet
						$object->setLoginAttempts(0);
						$object->save();
					}
					
					$return->Message = 'Email dan password yang Anda masukkan salah';						
				}
			} else {
				$return->Message = 'Email Anda belum terdaftar di sistem, silahkan melakukan pendaftar terlebih dahulu <br /><br /><br /> <a href="javascript:void(0)" class="p-0 m-0" onclick="showRegistrationForm()">Daftar sekarang</a> <br><br>';
			}			
			
		} catch (Exception $e) {
			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';
		}

		return $return;
	}

	/**
	 * Fungsi untuk mengambil User tertentu berdasarkan Id
	 * 
	 * @param  stdClass $params Id
	 * @return stdClass	Status, Message, Data
	 */
	public static function getByEmail($params = null) {
		
		$return = new Manager();

		if (!$params->Email) {
			$return->Message = 'Email kosong';
			return $return;
		}

		try {

			$object = DataObject\User::getByEmail($params->Email, 1);
			if (!$object) {
				$return->Message = 'Data tidak ditemukan';
			} else {
				$return->Status = 1;
				$return->Data = $object;
			}

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}

		return $return;
	}	

	/**
	 * Fungsi untuk mengambil User tertentu berdasarkan Id
	 * 
	 * @param  stdClass $params Id
	 * @return stdClass	Status, Message, Data
	 */
	public static function getByTempCode($params = null) {
		
		$return = new Manager();

		if (!$params->TempCode) {
			$return->Message = 'Temp code kosong';
			return $return;
		}

		try {

			$object = DataObject\User::getByTempCode($params->TempCode, 1);
			if (!$object) {
				$return->Message = 'Data tidak ditemukan';
			} else {
				$return->Status = 1;
				$return->Data = $object;
			}

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}

		return $return;
	}

	/**
	 * Fungsi mengirim email verifikasi
	 * 
	 * @param  stdClass $params Id
	 * @return stdClass	Status, Message, Data
	 */
	public static function sendEmailVerification($params = null) {
		
		$return = new Manager();

		if (!$params->Id) {
			$return->Message = 'Request kosong';
		}

		if (!$params->Request) {
			$return->Message = 'Request kosong';
		}

		try {

			$object = DataObject\User::getById($params->Id);
			if (!$object) {
				$return->Message = 'Data tidak ditemukan';
			} else {

                $now = new \DateTime();
                $next_available = $object->NextVerificationEmail;

                if($next_available){
                    $diff = ($next_available->getTimeStamp() - $now->getTimeStamp());
                    $minute = ceil( ($diff) / 60) - 1;
                    $second = ceil( ($diff) % 60);

                    if($minute < 10) $minute = '0' . $minute;
                    if($second < 10) $second = '0' . $second;

                    if($diff > 0){               
                        $return->Message = 'Pengiriman email kode verifikasi dibatasi. <br>Anda dapat melakukan permintaan lagi dalam waktu ' . $minute . ':' . $second . ' ke depan';                    
                        return $return;
                    }
                }

                $generate_code = \AppHelper\General::getRandomNumber(6);
	            $object->setVerificationCode($generate_code);

	            $next = \CustomHelper\General::getGlobalVariable('GLOBAL_VERIFICATION_CODE_NEXT');
	            $date_next = new \DateTime();
	            $date_next->add(new \DateInterval($next));

	            $object->setNextVerificationEmail($date_next);
	            $object->save();

	            $params_email = new \stdClass;
	            $params_email->Activity = "Send Verification Code";
	            $params_email->To = $object->Email;
	            $params_email->Params = array('Name' => $object->Name,
	                                    'VerificationCode' => $generate_code
	                                    );
	            $params_email->Template = '/template-email/user/send-verification-code';
	            $objectMail = \AppModel\EmailBucket::add($params_email);				

				$return->Status = 1;
			}

		} catch (Exception $e) {
			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';
		}

		return $return;
	}				

	/**
	 * Fungsi untuk menghitung statistik user
	 * 
	 * @param  stdClass $params Role
	 * @return stdClass	Status, Message, Data
	 */
	public static function getStatistic($params = null) {		
        
		$return = new Manager();

        if($params->Role){    	
	        $params->Key = $params->Role;
	        $role = \AuthenticationModel\UserRole::getByPath($params)->Data;

	        $params = new \stdClass;
	        $params->Condition = "Role__id = ?";
	        $params->ConditionArray = [$role->o_id];
        }

        $all = \AuthenticationModel\User::getAll($params);
        $all = $all->Status ? count($all->Data) : 1;

        $params->Condition .= ($params->Condition ? ' AND ' : '') . "StatusAccount = 1";
        $active = \AuthenticationModel\User::getAll($params);
        $active = $active->Status ? count($active->Data) : 1;

        $ratio = ($active / $all) * 100;
        if(is_float($ratio)) $ratio = number_format((float)$ratio, 1, '.', '');

        $return->Status = 1;
        $return->Data = (object) [
                "All" => $all,
                "Active" => $active,
                "Ratio" => $ratio
            ];
		
		return $return;        
	}

	public static function checkCompleteProfile($params = null)
	{
		$return = new Manager();

		if (!$params->Id) {
			$return->Message = 'ID kosong';
			return $return;
		}

		try {
			$obj = self::getById($params)->Data;

			if(!$obj->Name 
				|| !$obj->Gender
				|| !$obj->Dob
				|| !$obj->Province
				|| !$obj->City
			){
				$return->Message = 'Profile still not complete';
				return $return;
			}
			
			$return->Status = 1;
		} catch (Exception $e) {
			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';
		}

		$return->Data = $data;
		return $return;
	}

}
