<?php
/**
 * 
 */

namespace AuthenticationModel; 

use \Pimcore\Model\DataObject;
use \AppHelper\Manager;


class UserModule
{
	
	/**
	 * Fungsi untuk mengambil seluruh data dari object UserModule
	 * 
	 * @param  stdClass $params SortBy, SortType, Offset, Limit
	 * @return stdClass	Status, Message, Data
	 */
	public static function getAll($params = null) {
		
		$return = new Manager();
		
		try {

			$objects = new DataObject\UserModule\Listing();
			
			$condition = "";
			$params_condition = [];
			
			if ($condition) {
				$objects->setCondition($condition, $params_condition);
			}

			$count = count($objects);
			$return->Count = $count;

			if ($params->SortBy) {
				$objects->setOrderKey($params->SortBy);
			}
			if ($params->SortType) {
				$objects->setOrder($params->SortType);		
			}		
			if ($params->Limit) {
				$objects->setLimit($params->Limit);		
			}		
			if ($params->Offset) {
				$objects->setOffset($params->Offset);		
			}

			if (!$count && !count($objects)) {
				$return->Message = 'Data tidak ditemukan';
			} else {
				$return->Status = 1;
				$return->Data = $objects->load();
			}

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}
		
		return $return;
	
	}
	
	/**
	 * Fungsi untuk mengambil UserModule tertentu berdasarkan Id
	 * 
	 * @param  stdClass $params Id
	 * @return stdClass	Status, Message, Data
	 */
	public static function getById($params = null) {
		
		$return = new Manager();

		if (!$params->Id) {
			$return->Message = 'ID kosong';
			return $return;
		}

		try {

			$object = DataObject\UserModule::getById($params->Id);
			if (!$object) {
				$return->Message = 'Data tidak ditemukan';
			} else {
				$return->Status = 1;
				$return->Data = $object;
			}

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}

		return $return;
	
	}
	
	/**
	 * Fungsi untuk membuat UserModule baru
	 * 
	 * @param  stdClass $params Name, Description, Link
	 * @return stdClass	Status, Message, Data
	 */
	public static function create($params = null) {

		$return = new Manager();

		
		if (!$params->Name) {
			$return->Message = 'Name kosong';
			return $return;
		}
		
		
		try {

			// Inisialisasi object
			$object = DataObject\UserModule::create();
			$get_path = DataObject\AbstractObject::getByPath('/user-module');
			$name_key = microtime(true) .'_'. rand();

			// Set core
			$object->setKey(\Pimcore\File::getValidFilename($name_key));
			$object->setParentId($get_path->o_id);
			$object->setIndex(0); 
	        $object->setPublished(1);

	        // Set data
			$object->setName($params->Name);
			$object->setDescription($params->Description);

			$link = new DataObject\Data\Link();
			$link->setText($params->Link['Text']);
			$link->setPath($params->Link['Path']);
			$link->setTitle($params->Link['Title']);
			$object->setLink($link);

	        if ($object->save()) {
	        	$return->Status = 1;
	        	$return->Data = $object;
	        } else {
	        	$return->Message = 'Data gagal disimpan';
	        }

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}

		return $return;
	
	}
	
	/**
	 * Fungsi untuk mengubah data dari UserModule yang sudah ada
	 * 
	 * @param  stdClass $params Id, Name, Description, Link
	 * @return stdClass	Status, Message, Data
	 */
	public static function update($params = null) {
		
		$return = new Manager();

		if (!$params->Id) {
			$return->Message = 'ID kosong';
		}
		
		try {

			$object = DataObject\UserModule::getById($params->Id);
			if (!$object) {
				$return->Message = 'Data tidak ditemukan';
			}

	        // Set data
			if ($params->Name) {
				$object->setName($params->Name);
			}
			if ($params->Description) {
				$object->setDescription($params->Description);
			}
			if ($params->Link) {
				$link = new DataObject\Data\Link();
				$link->setText($params->Link['Text']);
				$link->setPath($params->Link['Path']);
				$link->setTitle($params->Link['Title']);
				$object->setLink($link);
			}

	        if ($object->save()) {
	        	$return->Status = 1;
	        	$return->Data = $object;
	        } else {
	        	$return->Message = 'Data gagal diubah';
	        }

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}

		return $return;

	}
	
	/**
	 * Fungsi untuk menghapus UserModule
	 * 
	 * @param  stdClass $params Id
	 * @return stdClass	Status, Message, Data
	 */
	public static function delete($params = null) {
		
		$return = new Manager();

		if (!$params->Id) {
			$return->Message = 'ID kosong';
		}

		try {

			$object = DataObject\UserModule::getById($params->Id);
			if (!$object) {
				$return->Message = 'Data tidak ditemukan';
			} else {
				$object->delete();
				$return->Status = 1;
			}

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}

		return $return;

	}

}