<?php
/**
 * 
 */

namespace AuthenticationModel; 

use \Pimcore\Model\DataObject;
use \AppHelper\Manager;


class UserRole
{
	
	/**
	 * Fungsi untuk mengambil seluruh data dari object UserRole
	 * 
	 * @param  stdClass $params SortBy, SortType, Offset, Limit
	 * @return stdClass	Status, Message, Data
	 */
	public static function getAll($params = null) {
		
		$return = new Manager();
		
		try {

			$objects = new DataObject\UserRole\Listing();
			
			$condition = "";
			$params_condition = [];
			
			if ($condition) {
				$objects->setCondition($condition, $params_condition);
			}

			$count = count($objects);
			$return->Count = $count;

			if ($params->SortBy) {
				$objects->setOrderKey($params->SortBy);
			}
			if ($params->SortType) {
				$objects->setOrder($params->SortType);		
			}		
			if ($params->Limit) {
				$objects->setLimit($params->Limit);		
			}		
			if ($params->Offset) {
				$objects->setOffset($params->Offset);		
			}

			if (!$count && !count($objects)) {
				$return->Message = 'Data tidak ditemukan';
			} else {
				$return->Status = 1;
				$return->Data = $objects->load();
			}

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}
		
		return $return;
	
	}
	
	/**
	 * Fungsi untuk mengambil UserRole tertentu berdasarkan Id
	 * 
	 * @param  stdClass $params Id
	 * @return stdClass	Status, Message, Data
	 */
	public static function getById($params = null) {
		
		$return = new Manager();

		if (!$params->Id) {
			$return->Message = 'ID kosong';
			return $return;
		}

		try {

			$object = DataObject\UserRole::getById($params->Id);
			if (!$object) {
				$return->Message = 'Data tidak ditemukan';
			} else {
				$return->Status = 1;
				$return->Data = $object;
			}

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}

		return $return;
	
	}
	
	/**
	 * Fungsi untuk membuat UserRole baru
	 * 
	 * @param  stdClass $params Name, UserModule, Scope
	 * @return stdClass	Status, Message, Data
	 */
	public static function create($params = null) {

		$return = new Manager();

		
		if (!$params->Name) {
			$return->Message = 'Name kosong';
			return $return;
		}
		
		
		try {

			// Inisialisasi object
			$object = DataObject\UserRole::create();
			$get_path = DataObject\AbstractObject::getByPath('/user-role');
			$name_key = microtime(true) .'_'. rand();

			// Set core
			$object->setKey(\Pimcore\File::getValidFilename($name_key));
			$object->setParentId($get_path->o_id);
			$object->setIndex(0); 
	        $object->setPublished(1);

	        // Set data
			$object->setName($params->Name);

			$user_module_items = [];
			for ($i = 0; $i < count($params->UserModule); $i++) {
				$item = DataObject\AbstractObject::getById($params->UserModule[$i]);
				array_push($user_module_items, $item);
			}
			$object->setUserModule($user_module_items);

			$object->setScope($params->Scope);

	        if ($object->save()) {
	        	$return->Status = 1;
	        	$return->Data = $object;
	        } else {
	        	$return->Message = 'Data gagal disimpan';
	        }

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}

		return $return;
	
	}
	
	/**
	 * Fungsi untuk mengubah data dari UserRole yang sudah ada
	 * 
	 * @param  stdClass $params Id, Name, UserModule, Scope
	 * @return stdClass	Status, Message, Data
	 */
	public static function update($params = null) {
		
		$return = new Manager();

		if (!$params->Id) {
			$return->Message = 'ID kosong';
		}
		
		try {

			$object = DataObject\UserRole::getById($params->Id);
			if (!$object) {
				$return->Message = 'Data tidak ditemukan';
			}

	        // Set data
			if ($params->Name) {
				$object->setName($params->Name);
			}
			$user_module_items = [];
			for ($i = 0; $i < count($params->UserModule); $i++) {
				$item = DataObject\AbstractObject::getById($params->UserModule[$i]);
				array_push($user_module_items, $item);
			}
			$object->setUserModule($user_module_items);
			if ($params->Scope) {
				$object->setScope($params->Scope);
			}

	        if ($object->save()) {
	        	$return->Status = 1;
	        	$return->Data = $object;
	        } else {
	        	$return->Message = 'Data gagal diubah';
	        }

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}

		return $return;

	}
	
	/**
	 * Fungsi untuk menghapus UserRole
	 * 
	 * @param  stdClass $params Id
	 * @return stdClass	Status, Message, Data
	 */
	public static function delete($params = null) {
		
		$return = new Manager();

		if (!$params->Id) {
			$return->Message = 'ID kosong';
		}

		try {

			$object = DataObject\UserRole::getById($params->Id);
			if (!$object) {
				$return->Message = 'Data tidak ditemukan';
			} else {
				$object->delete();
				$return->Status = 1;
			}

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}

		return $return;

	}

	/**
	 * Fungsi untuk mengambil UserRole tertentu berdasarkan KeyPath
	 * 
	 * @param  stdClass $params Id
	 * @return stdClass	Status, Message, Data
	 */
	public static function getByPath($params = null) {
		
		$return = new Manager();

		if (!$params->Key) {
			$return->Message = 'Key kosong';
			return $return;
		}

		try {

			$path = '/user/role/' . $params->Key;
			$object = DataObject\AbstractObject::getByPath($path);
			if (!$object) {
				$return->Message = 'Data tidak ditemukan';
			} else {
				$return->Status = 1;
				$return->Data = $object;
			}

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}

		return $return;
	
	}	

}