<?php

namespace AuthenticationBundle\Service;

use FOS\RestBundle\Controller\FOSRestController;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use OauthBundle\Annotation\ApiKey;
use \AppHelper\Manager;
use Lcobucci\JWT\Builder;
use Lcobucci\JWT\Signer\Hmac\Sha256;
use Lcobucci\JWT\Parser;

/**
 * @Route("/authentication")
 * @ApiKey (required = true, scope = "global")
 */
class AuthenticationController extends FOSRestController
{
    /**
     * @Route("/user")
     * @Method("POST")
     * @param Username, Password
     */
    public function userAction(Request $request = null)
    {
        $return = new Manager();
        $params = (object) $request->request->all();

        $result = \AuthenticationModel\User::authentication($params);

        if($result->Status == 1)
        {
            $expired_time_token = \CustomHelper\General::getGlobalVariable('GLOBAL_TOKEN_EXPIRED_TIME');
            $expired_time_token = (int) $expired_time_token ? $expired_time_token : "36000";

            $signer = new Sha256();
            $token = (new Builder())->setIssuer($request->getSchemeAndHttpHost())
                                    ->setAudience($request->getSchemeAndHttpHost())
                                    ->setId($result->Data->o_id, true)
                                    ->setIssuedAt(time())
                                    ->setExpiration(time() + $expired_time_token)
                                    ->set('UserId', $result->Data->o_id)
                                    ->set('Name', $result->Data->Name)
                                    ->set('Email', $result->Data->Email)
                                    ->set('Role', $result->Role)
                                    ->set('Scope', $result->Scope)
                                    ->getToken();
            $return->Status = 1;
            $return->Data = $result;
            $return->Token = $token->getPayload().".";
            $return->Redirect = $result->Data->Role->RedirectUrl;
        } else {
            $return = $result;
        }

        return $this->json($return->Load(true));
    }

    /**
     * @Route("/destroy")
     * @Method("POST")
     */
    public function destroyAction(Request $request = null)
    {
        // Just set empty the token
        $return = new Manager();
        
        $return->Status = 1;
        $return->Token = "";

        return $this->json($return->Load(true));
    }

    /**
     * @Route("/registration")
     * @Method("POST")
     */
    public function registrationAction(Request $request = null)
    {
        $return = new Manager();
        $params = (object) $request->request->all();

        if(!$params->Email) {
            $return->Message = 'Email tidak boleh kosong';
            return $this->json($return->Load(true));
        }

        if(!$params->Name) {
            $return->Message = 'Nama tidak boleh kosong';
            return $this->json($return->Load(true));
        }

        if(!$params->Password) {
            $return->Message = 'Password tidak boleh kosong';
            return $this->json($return->Load(true));
        }

        try {
            
            $object = \AuthenticationModel\User::getByEmail($params)->Data;
            if($object) {               
                if(!$object->StatusAccount){
                    $return->Message = 'Email Anda telah terdaftar di sistem, tetapi saat ini status akun belum diaktifasi. <br>Silakan masukkan kode aktifasi yang sudah dikirim via Email <br/><br/><br/> <input type="text" class="input-verification-code"> <br/><br/> <a href="javascript:void(0)" class="p-0 m-0" onclick="sendEmailVerification()">Kirim ulang kode verifikasi</a> <br><br> <span class="message-verification-code"></span> <br>';

                } else {
                    $return->Message = 'Email Anda telah terdaftar di sistem <br>Silakan lakukan <a href="javascript:void(0)" class="p-0 m-0" onclick="showLoginForm()">login</a> <br><br>';
                }

            } else {                
                $now = new \DateTime();

                $y = $now->format('Y');
                $m = $now->format('F');
                $d = $now->format('d');     
                $params->Path = '/user/data/participant/' . $y . '/' . $m . '/' . $d;
                
                $h = $now->format('H');
                $i = $now->format('i');     
                $params->Key = $h . '_' . $i . '_' . $params->Email;

                $role = \AuthenticationModel\UserRole::getByPath((object) ["Key" => 'participant']);
                $params->Role = $role->Data->o_id;

                $user = \AuthenticationModel\User::create($params);

                if($user->Status){
                    $params_email = new \stdClass;
                    $params_email->Request = $request;
                    $params_email->Id = $user->Data->o_id;
                    $send_email = \AuthenticationModel\User::sendEmailVerification($params_email);

                    if($send_email->Status){
                        $return->Status = 1;
                        $return->Message = 'Pendaftaran berhasil, <br>Silakan masukkan kode aktifasi yang sudah dikirim via Email <br/><br/><br/> <input type="text" class="input-verification-code"> <br/><br/> <a href="javascript:void(0)" class="p-0 m-0" onclick="sendEmailVerification()">Kirim ulang kode verifikasi</a> <br><br> <span class="message-verification-code"></span> <br>';
                    } else {
                        $result->Message = $send_email->Message;                           
                    }
                } else {
                    $return->Message = $user->Message;   
                }
            }           
            
        } catch (Exception $e) {
            $return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';
        }

        return $this->json($return->Load(true));
    }    

    /**
     * @Route("/forgot-password")
     * @Method("POST")
     */
    public function forgotPasswordAction(Request $request = null)
    {
        // Just set empty the token
        $return = new Manager();
        $params = (object) $request->request->all();

        if(!$params->Email) {
            $return->Message = 'Email tidak boleh kosong';
            return $this->json($return->Load(true));
        }

        try {
            
            $object = \AuthenticationModel\User::getByEmail($params)->Data;
            if($object) {               
                if(!$object->StatusAccount){
                    $return->Message = 'Email Anda telah terdaftar di sistem, tetapi saat ini status akun belum diaktifasi. <br>Silakan masukkan kode aktifasi yang sudah dikirim via Email <br/><br/><br/> <input type="text" class="input-verification-code"> <br/><br/> <a href="javascript:void(0)" class="p-0 m-0" onclick="sendEmailVerification()">Kirim ulang kode verifikasi</a> <br><br> <span class="message-verification-code"></span> <br>';                    
                    return $this->json($return->Load(true));
                }
        
                $params_email = new \stdClass;
                $params_email->Request = $request;
                $params_email->Id = $object->o_id;
                $send_email = \AuthenticationModel\User::sendEmailVerification($params_email);

                if($send_email->Status){                
                    $return->Status = 1;                  
                    $return->Message = 'Permintaan atur ulang password Anda berhasil. <br>Silakan masukkan kode verifikasi yang sudah dikirim via Email <br/><br/><br/> <input type="text" class="input-verification-code"> <br/><br/> <a href="javascript:void(0)" class="p-0 m-0" onclick="sendEmailVerification()">Kirim ulang kode verifikasi</a> <br><br> <span class="message-verification-code"></span> <br>';
                } else {
                    $return->Message = 'Permintaan atur ulang password Anda sudah diproses sebelumnya. <br>Silakan masukkan kode verifikasi yang sudah dikirim via Email <br/><br/><br/> <input type="text" class="input-verification-code"> <br/><br/> <a href="javascript:void(0)" class="p-0 m-0" onclick="sendEmailVerification()">Kirim ulang kode verifikasi</a> <br><br> <span class="message-verification-code"></span> <br>';                    
                }                
            } else {
                $return->Message = 'Email Anda belum terdaftar di sistem, silahkan melakukan pendaftar terlebih dahulu <br /><br /><br /> <a href="javascript:void(0)" class="p-0 m-0" onclick="showRegistrationForm()">Daftar sekarang</a> <br><br>';
            }           
            
        } catch (Exception $e) {
            $return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';
        }

        return $this->json($return->Load(true));
    }

    /**
     * @Route("/change-password")
     * @Method("POST")
     */
    public function changePasswordAction(Request $request = null)
    {
        // Just set empty the token
        $return = new Manager();
        $params = (object) $request->request->all();

        if(!$params->Id) {
            $return->Message = 'user login kosong';
            return $this->json($return->Load(true));
        }

        if(!$params->OldPassword) {
            $return->Message = 'Password saat ini tidak boleh kosong';
            return $this->json($return->Load(true));
        }

        if(!$params->NewPassword) {
            $return->Message = 'Password baru tidak boleh kosong';
            return $this->json($return->Load(true));
        }

        if(!$params->ConfirmNewPassword) {
            $return->Message = 'Konfirmasi password baru tidak boleh kosong';
            return $this->json($return->Load(true));
        }

        try {
            
            $user = \AuthenticationModel\User::getById($params);


            if ($user->Data->Password != md5($params->OldPassword)) {
                return $this->json(['Status' => 0, 'Message' => 'Password saat ini yang Anda masukan salah']);
            }

            $user->Data->Password = $params->NewPassword;
            $user->Data->save();

            $return->Status = 1;
            
        } catch (Exception $e) {
            $return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';
        }

        return $this->json($return->Load(true));
    }          

    /**
     * @Method("POST")
     * @Route("/update-profile")
     */
    public function updateProfileAction(Request $request)
    { 
        $params = (object) $request->request->all();
        $result = \AuthenticationModel\User::update($params);
        $result->Data = null;
    
        return $this->json($result->Load(true));
    }

    /**
     * @Route("/send-verification-email")
     * @Method("POST")
     */
    public function sendVerificationEmailAction(Request $request = null)
    {
        $return = new Manager();
        $params = (object) $request->request->all();

        if(!$params->Email) {
            $return->Message = 'Email tidak boleh kosong';
            return $this->json($return->Load(true));
        }

        try {            
            $user = \AuthenticationModel\User::getByEmail($params)->Data;
            if($user){
                $params_email = new \stdClass;
                $params_email->Request = $request;
                $params_email->Id = $user->o_id;
                $send_email = \AuthenticationModel\User::sendEmailVerification($params_email);

                if($send_email->Status){
                    $return->Status = 1;                  
                } else {
                    $return->Message = $send_email->Message;                           
                }
            } else {
                $return->Message = 'Akun tidak ditemukan';   
            }
        } catch (Exception $e) {
            $return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';
        }

        return $this->json($return->Load(true));
    }  

    /**
     * @Method("POST")
     * @Route("/submit-verification-code")
     */
    public function verificationCodeAction(Request $request)
    { 
        $return = new Manager();
        $params = (object) $request->request->all();

        if(!$params->Email) {
            $return->Message = 'Email tidak boleh kosong';
            return $this->json($return->Load(true));
        }

        if(!$params->Code) {
            $return->Message = 'Kode tidak boleh kosong';
            return $this->json($return->Load(true));
        }

        try {            
            $user = \AuthenticationModel\User::getByEmail($params)->Data;
            if($user){
                if($user->VerificationCode == $params->Code){
                    if($params->Activity){
                        $activities = explode(',', $params->Activity);
    
                        foreach ($activities as $key => $value) {
                            $value = trim($value);
                            if($value == 'activation'){
                                $user->StatusAccount = 1;
                                $user->save();
                            } 

                            if ($value == 'change-password') {
                                if($params->NewPassword){                        
                                    $user->Password = $params->NewPassword;
                                    $user->save();
                                } else {
                                    $return->Message = 'Gagal mengubah password';
                                    return $this->json($return->Load(true));                            
                                }
                            }
                        }
                    }

                    if($params->Auto){
                        $expired_time_token = \CustomHelper\General::getGlobalVariable('GLOBAL_TOKEN_EXPIRED_TIME');
                        $expired_time_token = (int) $expired_time_token ? $expired_time_token : "36000";

                        $signer = new Sha256();
                        $token = (new Builder())->setIssuer($request->getSchemeAndHttpHost())
                                                ->setAudience($request->getSchemeAndHttpHost())
                                                ->setId($user->o_id, true)
                                                ->setIssuedAt(time())
                                                ->setExpiration(time() + $expired_time_token)
                                                ->set('UserId', $user->o_id)
                                                ->set('Name', $user->Name)
                                                ->set('Email', $result->Email)
                                                ->set('Role', $user->Role->Name)
                                                ->set('Scope', $user->Scope)
                                                ->getToken();                        
                        $token = $token->getPayload().".";   

                        $session = $request->getSession();
                        $session->set('auth_token', $token);
                    }

                    $return->RedirectUrl = $user->Role->RedirectUrl;
                    $return->Status = 1;                  
                } else {
                    $return->Message = 'Kode verifikasi salah';   
                }
            } else {
                $return->Message = 'Akun tidak ditemukan';   
            }
        } catch (Exception $e) {
            $return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';
        }

        return $this->json($return->Load(true));
    }

}
