<?php

namespace CustomBundle\Controller;

use Pimcore\Controller\FrontendController;
use Symfony\Component\HttpFoundation\Request;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;

/**
 * @Route("/global-variable")
 */
class GlobalVariableController extends FrontendController
{

    public function __construct()
    {

        // check pimcore admin user
        $user = \AppHelper\Authentication::checkPimcoreLogin();
        if (!$user) {
            echo "
	            Maaf anda tidak dapat mengakses halaman ini, silahkan login sebagai Administrator <br><br>
                <button onclick=\"window.open('/admin/login', '_blank');\";> login Administrator </button>
            ";
            die();
        } else {
	        if (!$user->admin) {
		        echo "
		            Maaf akun Anda tidak dapat mengakses halaman ini, silahkan logout dan login kembali sebagai Administrator <br><br>
	                <button onclick=\"window.open('/admin/login', '_blank');\";> login Administrator </button>
		        ";

	        	\AppHelper\Authentication::logoutPimcorePanel($this);
          	  	die();
	        }
        }

    }

    /**
     * @Route("/")
     */
    public function defaultAction()
    {
        $objects = \CustomHelper\General::getGlobalVariable();
        
        $this->view->Global = $objects;
    }

    /**
     * @Route("/process")
     * @Method({"GET", "POST"})
     */
    public function processAction(Request $request){

        $index = $_POST["id"];
        $key = $_POST["name"];
        $value = $_POST["value"];
        $description = $_POST["description"];
        $process = $_POST["process"];

        if($process){
            \CustomHelper\General::crudGlobalVariable($process, $key, $value, $description, $index);

        } else if ($_POST["dataOrder"]){

            $global = $_POST['dataOrder'];
            \CustomHelper\General::replaceDataGlobalVariable($global);
        
        } else if ($_GET["export"] == "yes"){
            
            \CustomHelper\General::exportGlobalVariable();
        
        } else if (isset($_FILES['file'])){
            $import = $_POST['import'];
            $file_type = $_FILES['file']['type'];
            
            if ($file_type != "application/vnd.ms-excel"){
                $this->redirect("/custom/global-variable/default/?upload=no-csv");
            }else{
                $file_name = $_FILES['file']['name'];
                $file_size = $_FILES['file']['size'];
                $file_tmp  = $_FILES['file']['tmp_name'];
                
                move_uploaded_file($file_tmp,$_SERVER['DOCUMENT_ROOT']."/var/".$file_name);
                \CustomHelper\General::importGlobalVariable($_SERVER['DOCUMENT_ROOT']."/var/".$file_name, $import);
                $this->redirect("/custom/global-variable/");
            }
            
        }

        die();

    }

    /**
     * @Route("/helper/")
     * @Method("GET")
     */
    public function helperAction()
    {
        $objects = \CustomHelper\General::getGlobalVariable('GLOBAL_VARIABLE_URL');
        
        print_r($objects); die();
    }
}
