<?php

namespace CustomBundle\Controller;

use Pimcore\Controller\FrontendController;
use Symfony\Component\HttpFoundation\Request;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Method;
use Sensio\Bundle\FrameworkExtraBundle\Configuration\Route;

/**
 * @Route("/static-route")
 */
class StaticRouteController extends FrontendController
{

	public function __construct()
    {

        // check pimcore admin user
        $user = \AppHelper\Authentication::checkPimcoreLogin();
        if (!$user) {
            echo "
	            Maaf anda tidak dapat mengakses halaman ini, silahkan login sebagai Administrator <br><br>
                <button onclick=\"window.open('/admin/login', '_blank');\";> login Administrator </button>
            ";
            die();
        } else {
	        if (!$user->admin) {
		        echo "
		            Maaf akun Anda tidak dapat mengakses halaman ini, silahkan logout dan login kembali sebagai Administrator <br><br>
	                <button onclick=\"window.open('/admin/login', '_blank');\";> login Administrator </button>
		        ";

	        	\AppHelper\Authentication::logoutPimcorePanel($this);
          	  	die();
	        }
        }

    }

    /**
     * @Route("/")
     */
    public function defaultAction()
    {
        $objects = \CustomHelper\General::getStaticRoute();
    	$this->view->Static = $objects;
    }

    /**
     * @Route("/process")
     * @Method({"GET", "POST"})
     */
    public function processAction(){

        $index = $_POST["_index"];
        $patternUrl = $_POST["_patternUrl"];
        $patternUrlId = $_POST["_patternUrlId"];
        $module = $_POST["_module"];
        $controller = $_POST["_controller"];
        $action = $_POST["_action"];
        $staticRouteName = $_POST["_staticRouteName"];
        $publish = $_POST["_publish"];
        $process = $_POST["process"];

        if($process){

            \CustomHelper\General::crudStaticRoute(
                    $process, 
                    $patternUrl, 
                    $module, 
                    $controller, 
                    $action, 
                    $staticRouteName, 
                    $index, 
                    $patternUrlId, 
                    $publish
                );

        } else if ($_POST["dataOrder"]){

            $static = $_POST['dataOrder'];
            \CustomHelper\General::replaceDataStaticRoute($static, 1);
        
        } else if ($_GET["export"] == "yes"){
            
            \CustomHelper\General::exportStaticRoute();
        
        } else if (isset($_FILES['file'])){
            $overwrite = $_POST['overwrite'];
            $file_type = $_FILES['file']['type'];

            if ($file_type != "application/vnd.ms-excel"){
                $this->redirect("/custom/static-route/default/?upload=no-csv");
            }else{
                $file_name = $_FILES['file']['name'];
                $file_size = $_FILES['file']['size'];
                $file_tmp  = $_FILES['file']['tmp_name'];
                
                move_uploaded_file($file_tmp,$_SERVER['DOCUMENT_ROOT']."/var/".$file_name);
                \CustomHelper\General::importStaticRoute($_SERVER['DOCUMENT_ROOT']."/var/".$file_name, $overwrite);
                $this->redirect("/custom/static-route/");
            }
            
        }
        die();

    }
}
