<?php

/*
	This is for PHP function helper
	Initial by Hasmya Dwi Azra
    Adapted from CustomHelper Pimcore 4
*/

namespace CustomHelper;

use Pimcore\File;
use Pimcore\Model\Asset;

class General {

	public static function createTableGlobalVariable(){
        
        $queryNewTable = "CREATE TABLE dreamcube_global_variable (
                _key VARCHAR(100) NOT NULL,
                _value VARCHAR(500),
                _description VARCHAR(5000),
                _index INT NOT NULL,
                PRIMARY KEY(_key)
            )DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci";

        $createTable = \AppHelper\Mysql::runQuery($queryNewTable);
    }

    // function for get global varibale data, if params $key is empty => get all data
    public static function getGlobalVariable($key = null){
      
        $key = $key ? strtoupper($key) : '';

        $databaseConfig = \Pimcore\Config::getSystemConfig()->database->toArray();
        $existTable = \AppHelper\Mysql::makeQuery("SELECT * FROM information_schema.TABLES WHERE TABLE_NAME = 'dreamcube_global_variable' AND TABLE_SCHEMA = '". $databaseConfig['params']['dbname'] ."'");
        
        if(!$existTable){
            \CustomHelper\General::createTableGlobalVariable();
        }

        if($key){

            $existRecord = \AppHelper\Mysql::makeQuery("select * FROM dreamcube_global_variable WHERE _key = '" . $key . "'");

            if(!$existRecord){
                \CustomHelper\General::crudGlobalVariable('create', $key);
            }        

            // if(!$existRecord[0]["_value"]){
            //     die('Global variable "' . $key . '" masih kosong');
            // }        

            return $existRecord[0]["_value"]; // return value global variable
        
        } else {

            $globalVariables = \AppHelper\Mysql::makeQuery("select * FROM dreamcube_global_variable ORDER BY _index ASC");
            return $globalVariables; // return all global variable
        
        }
    }

    // function for create, update and delete global varible
    public static function crudGlobalVariable($action, $key, $value = '', $description = '', $index = ''){

        $key = $key ? strtoupper($key) : '';

        $databaseConfig = \Pimcore\Config::getSystemConfig()->database->toArray();
        $existTable = \AppHelper\Mysql::makeQuery("SELECT * FROM information_schema.TABLES WHERE TABLE_NAME = 'dreamcube_global_variable' AND TABLE_SCHEMA = '". $databaseConfig['params']['dbname'] ."'");
        if(!$existTable){
            \CustomHelper\General::createTableGlobalVariable();
        }

        $existRecord = \AppHelper\Mysql::makeQuery("select * FROM dreamcube_global_variable WHERE _key = '" . $key . "'");

        if($action == 'create'){
            if(!$existRecord){
                $query = "INSERT INTO dreamcube_global_variable (_key, _value, _description, _index) VALUES ('". $key . "', '". $value . "', '". $description . "', '". $index . "')";
            } else {
                \CustomHelper\General::crudGlobalVariable('update',  $key, $value, $description, $index);
            }
        } else if($action == 'update') {
            if($existRecord){
                $query = "UPDATE dreamcube_global_variable SET _value = '". $value ."', _description = '". $description ."', _index = '". $index ."' WHERE _key = '". $key ."'";
            }
        } else if($action == 'delete') {
            if($existRecord){
                $query = "DELETE FROM dreamcube_global_variable WHERE _key = '". $key ."'";
            }
        }
    
        if($query)  \AppHelper\Mysql::runQuery($query);

    }

    // function for export all data global variable
    public static function exportGlobalVariable(){  
        $data = array();
        $objects = \CustomHelper\General::getGlobalVariable();     
        if($objects){
            foreach($objects as $object){
                $temp = array();
                foreach($object as $obj){
                    array_push($temp, $obj);
                }
                array_push($data, $temp);
            }

            $path = $_SERVER['DOCUMENT_ROOT'].'/var/files';
            if(!file_exists($path)){
                mkdir($path, 0777);
            }

            $filename = (string)microtime(true);
            \AppHelper\Csv::createCsvFile($path, $filename, $data);

            $file = $path.$filename.".csv";     
            if (file_exists($file)) {
                header('Content-Description: File Transfer');
                header('Content-Type: application/octet-stream');
                header('Content-Disposition: attachment; filename="global-variable.csv"');
                header('Expires: 0');
                header('Cache-Control: must-revalidate');
                header('Pragma: public');
                header('Content-Length: ' . filesize($file));
                readfile($file);
                unlink($file);
            }
        }

        exit;            
    }

    // function for import data global variable, params $filename is path of uploaded file
    public static function importGlobalVariable($filename, $import = ''){
        $data = \AppHelper\Csv::readCsvFile($filename);
        \CustomHelper\General::replaceDataGlobalVariable($data, $import);

        unlink($filename);
    }

    // function for replace all data on table dreamcube_global_variable, if params $data is empty == clear all data on the table
    public static function replaceDataGlobalVariable($data = null, $import = ''){
        // check exist table dreamcube_global_variable
        $databaseConfig = \Pimcore\Config::getSystemConfig()->database->toArray();
        $existTable = \AppHelper\Mysql::makeQuery("SELECT * FROM information_schema.TABLES WHERE TABLE_NAME = 'dreamcube_global_variable' AND TABLE_SCHEMA = '". $databaseConfig['params']['dbname'] ."'");
        if(!$existTable){
            \CustomHelper\General::createTableGlobalVariable();
        }
        // truncate table dreamcube_global_variable
        if($import == 'all'){
           \AppHelper\Mysql::runQuery("TRUNCATE TABLE dreamcube_global_variable");
        }
        
        if($data){
            foreach ($data as $row) {  
                if($import == 'notAll'){
                    $existRecord = \AppHelper\Mysql::makeQuery("select * FROM dreamcube_global_variable WHERE _key = '" . $row[0]. "'");          
                    if(!$existRecord && $row['0']){
                        \CustomHelper\General::crudGlobalVariable('create',  $row[0], $row[1], $row[2], $row[3]);   
                    }
                }elseif($import == 'all' && $row['0']){
                    \CustomHelper\General::crudGlobalVariable('create',  $row[0], $row[1], $row[2], $row[3]);   
                }                             
            }            
        }
    }

    public static function createTableStaticRoute(){
        $queryNewTable = "CREATE TABLE dreamcube_static_route (
                _patternUrl VARCHAR(255) NOT NULL,
                _module VARCHAR(255),
                _controller VARCHAR(255),
                _action VARCHAR(255),
                _staticRouteName VARCHAR(255),
                _index INT NOT NULL,
                _publish INT NOT NULL,
                PRIMARY KEY(_patternUrl)
            )DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci";

        $createTable = \AppHelper\Mysql::runQuery($queryNewTable);
    }

    // function for get global varibale data, if params $patternUrl is empty => get all data
    public static function getStaticRoute($patternUrl = null){
        $databaseConfig = \Pimcore\Config::getSystemConfig()->database->toArray();
        $existTable = \AppHelper\Mysql::makeQuery("SELECT * FROM information_schema.TABLES WHERE TABLE_NAME = 'dreamcube_static_route' AND TABLE_SCHEMA = '". $databaseConfig['params']['dbname'] ."'");
        if(!$existTable){
            \CustomHelper\General::createTableStaticRoute();
        }

        if($patternUrl){

            $existRecord = \AppHelper\Mysql::makeQuery("select * FROM dreamcube_static_route WHERE _patternUrl = '" . $patternUrl . "'");

            if(!$existRecord){
                \CustomHelper\General::crudStaticRoute('create', $patternUrl);
            }        

            if(!$existRecord[0]["_module"]){
                die('static route "' . $patternUrl . '" masih kosong');
            }        

            return $existRecord[0]["_module"]; // return module static route
        
        } else {

            $staticRoutes = \AppHelper\Mysql::makeQuery("select * FROM dreamcube_static_route ORDER BY _index ASC");
            return $staticRoutes; // return all static route
        
        }
    }

    // function for create, update and delete static route
    public static function crudStaticRoute($action, $patternUrl, $module = '', $controller = '', $nameaction = '', $staticRouteName = '', $index = '', $patternUrlId = '', $publish = ''){

        $databaseConfig = \Pimcore\Config::getSystemConfig()->database->toArray();
        $existTable = \AppHelper\Mysql::makeQuery("SELECT * FROM information_schema.TABLES WHERE TABLE_NAME = 'dreamcube_static_route' AND TABLE_SCHEMA = '". $databaseConfig['params']['dbname'] ."'");
        
        if(!$existTable){
            \CustomHelper\General::createTableStaticRoute();
        }

        $existRecord = \AppHelper\Mysql::makeQuery("select * FROM dreamcube_static_route WHERE _patternUrl = '" . $patternUrlId . "'");

        if($action == 'create'){

            if(!$existRecord){
                $query = "INSERT INTO dreamcube_static_route (_patternUrl, _module, _controller, _action,_staticRouteName, _index, _publish) VALUES ('". $patternUrl . "', '". $module . "', '". $controller . "', '". $nameaction . "','". $staticRouteName . "','". $index . "','". $publish . "')";
                \AppHelper\Mysql::runQuery($query);            
            } else {
                \CustomHelper\General::crudStaticRoute('update',  $patternUrl, $module, $controller, $nameaction, $staticRouteName, $index, $patternUrlId, $publish);
            }

        } else if($action == 'update') {
            if($existRecord){
                $query = "UPDATE dreamcube_static_route SET _patternUrl = '". $patternUrl ."', _module = '". $module ."', _controller = '". $controller ."', _action= '". $nameaction ."', _staticRouteName= '". $staticRouteName ."', _index = '". $index ."' WHERE _patternUrl = '". $patternUrlId ."'";
                \AppHelper\Mysql::runQuery($query);
            }
        } else if($action == 'delete') {
            $query = "DELETE FROM dreamcube_static_route WHERE _patternUrl = '". $patternUrl ."'";
            \AppHelper\Mysql::runQuery($query);

            $data = [];
            $staticRoutes = \AppHelper\Mysql::makeQuery("select _patternUrl, _module, _controller, _action, _staticRouteName, _publish FROM dreamcube_static_route");
            foreach ($staticRoutes as $static) { 
                $temp = [
                        $static['_patternUrl'],
                        $static['_module'],
                        $static['_controller'],
                        $static['_action'],
                        $static['_staticRouteName'],
                        $static['_publish']                        
                    ];
                array_push($data, $temp);
            }  

            \CustomHelper\General::replaceDataStaticRoute($data, 1);

        } else if($action == 'publish') {
            if($existRecord){
                $query = "UPDATE dreamcube_static_route SET _publish = '". $publish ."' WHERE _patternUrl = '". $patternUrlId ."'";
                \AppHelper\Mysql::runQuery($query);
            }
        }
    
    }

    // function for export all data static route
    public static function exportStaticRoute(){  
        $data = array();
        $objects = \CustomHelper\General::getStaticRoute();     
        if($objects){
            foreach($objects as $object){
                $temp = array();
                foreach($object as $obj){
                    array_push($temp, $obj);
                }
                array_push($data, $temp);
            }

            $path = $_SERVER['DOCUMENT_ROOT'].'/var/files';
            if(!file_exists($path)){
                mkdir($path, 0777);
            }

            $filename = (string)microtime(true);
            \AppHelper\Csv::createCsvFile($path, $filename, $data);

            $file = $path.$filename.".csv";     
            if (file_exists($file)) {
                header('Content-controller: File Transfer');
                header('Content-Type: application/octet-stream');
                header('Content-Disposition: attachment; filename="static-route.csv"');
                header('Expires: 0');
                header('Cache-Control: must-revalidate');
                header('Pragma: public');
                header('Content-Length: ' . filesize($file));
                readfile($file);
                unlink($file);
            }
        }

        exit;            
    }

    // function for import data static route, params $filename is path of uploaded file
    public static function importStaticRoute($filename, $overwrite = null){
        $data = \AppHelper\Csv::readCsvFile($filename);
        \CustomHelper\General::replaceDataStaticRoute($data, $overwrite);

        unlink($filename);
    }

    // function for replace all data on table dreamcube_static_route, if params $data is empty == clear all data on the table
    public static function replaceDataStaticRoute($data = null, $overwrite= null){
        // check exist table dreamcube_static_route
        $databaseConfig = \Pimcore\Config::getSystemConfig()->database->toArray();
        $existTable = \AppHelper\Mysql::makeQuery("SELECT * FROM information_schema.TABLES WHERE TABLE_NAME = 'dreamcube_static_route' AND TABLE_SCHEMA = '". $databaseConfig['params']['dbname'] ."'");
        if(!$existTable){
            \CustomHelper\General::createTableStaticRoute();
        }

        if($overwrite){
            // truncate table dreamcube_static_route
            \AppHelper\Mysql::runQuery("TRUNCATE TABLE dreamcube_static_route");
            $index = 0;
        } else {
            $index = \AppHelper\Mysql::makeQuery("select count(*) FROM dreamcube_static_route")[0]['count(*)'];
        }
        
        if($data){
            foreach ($data as $row) {  
                if($row['0']){
                    $existRecord = \AppHelper\Mysql::makeQuery("select * FROM dreamcube_static_route WHERE _patternUrl = '" . $row[0] . "'");
                    if(!$existRecord){
                        \CustomHelper\General::crudStaticRoute('create',  $row[0], $row[1], $row[2], $row[3], $row[4], $index++, '', $row[5]);
                    }                
                }
            }            
        }
    }
    
}
