<?php
/**
 * @var \Pimcore\Templating\PhpEngine $this
 * @var \Pimcore\Templating\PhpEngine $view
 * @var \Pimcore\Templating\GlobalVariables $app
 */
    $this->extend('CustomBundle::layout.html.php');
?>

<?php 

	if($_GET["upload"] == "no-csv"){
		echo "<div class='alert alert-warning'>
				<a href='#' class='close' data-dismiss='alert' aria-label='close'>&times;</a>
				File yang dimasukkan harus .csv
			</div>";
	}

	$static= $this->Static;		

?>

<div class='alert alert-warning hide'>
	<a href='javacript:void(0)' class='close' onclick="$('.alert.alert-warning').addClass('hide')">&times;</a>
	<span class="message"></span>
</div>

<div class="container">
	<button type="button" class="btn btn-primary" id="btn-import"  style="float:left; margin: 20px 0">Import</button>
	<button type="button" class="btn btn-primary" id="btn-export" style="float:left; margin: 20px 5px">Export</button>
	<button type="button" class="btn btn-primary" id="btn-tambah-static"  style="float:right; margin: 20px" onclick="newStaticRoute()">Tambah</button>
	
	<table id="myTable" class="display table table-bordered cell-border stripe table-action responsive" cellspacing="0">
		<thead class="head-table">
			<tr>
				<th valign="center">No</th>
				<th style="display: none">ID</th>
				<th valign="center">Pattern Url</th>
				<th valign="center">Module</th>
				<th valign="center">Controller</th>
				<th valign="center">Action</th>
				<th valign="center">Static Route Name</th>
				<th valign="center">Publish</th>
				<th valign="center">Aksi</th>
			</tr>
		</thead>
		
		<tbody>

			<?php foreach ($static as $key => $val) { ?> 

			<tr>
				<td> <?=  $val["_index"] + 1 ?> </td>
				<td style="display: none;"> <?= $val["_index"]; ?> </td>
				<td><?= $val["_patternUrl"]; ?></td>
				<td> <?= $val["_module"]; ?> </td>
				<td> <?= $val["_controller"]; ?> </td>
				<td> <?= $val["_action"]; ?> </td>
				<td> <?= $val["_staticRouteName"]; ?> </td>
				<td>
					<input type="checkbox" name="publish" data-on-text="ON" data-off-text="OFF" data-size="small"  <?= $val['_publish'] ? 'checked' : '' ?> >
				</td>						
				<td align="center">
					<button type="button" id="btn-delete" class="btn btn-primary" onClick="window.open('<?= $val["_patternUrl"] ?>', '_blank')">Go</button>
					<button type="button" class="btn btn-primary" id="btn-edit" onClick="editStaticRoute(<?= $key ?>)">Edit</button>
					<button type="button" id="btn-delete" class="btn btn-primary" onClick="deleteVar('<?= $val['_patternUrl'];?>')">Hapus</button>
				</td>
			</tr>

			<?php } ?>

		</tbody>
			
	</table>

	<div class="modal fade" id="modal-form-data" role="dialog">
	    <div class="modal-dialog modal-xs" role="document">
	        <div class="modal-content">

	            <div class="modal-header">
	                <button type="button" class="close" style="padding: 5px" data-dismiss="modal" aria-label="Tutup"><span aria-hidden="true">&times;</span></button>
	                <h4>Lengkapi form di bawah ini</h4>
	            </div>

	            <div class="modal-body">
	            	<form id="form-staticroute">

		                <div class="form-group">
							<label>Pattern Url</label>
							<input type="text" name="_patternUrl" class="form-control">
							<small class="error-message"></small>
						</div>

						<div class="form-group">
				            <label>Module :</label>
				            <select name="_module" class="form-control" onchange="changeModule()"> </select>
							<small class="error-message"></small>
				        </div>

				        <div class="form-group">
				            <label>Controller :</label>
				            <select name="_controller" class="form-control" onchange="changeController()"> </select>
							<small class="error-message"></small>					            
				        </div>

				        <div class="form-group">
				            <label>Action :</label>
				            <select name="_action" class="form-control"> </select>
							<small class="error-message"></small>					            
				        </div>

				        <div class="form-group">
				            <label>Static Route Name :</label>
				            <input type="text" name="_staticRouteName" class="form-control" >
							<small class="error-message"></small>
				        </div>

						<input type="hidden" name="_index">
						<input type="hidden" name="_publish">
						<input type="hidden" name="_patternUrlId">
						<input type="hidden" name="process">

	            	</form>

	            </div>

	            <div class="modal-footer">
	                <button type="button" class="btn btn-default" data-dismiss="modal">Batal</button>
	                <button type="button" class="btn btn-primary btn-create-update" onclick="$('#form-staticroute').submit();">Buat</button>
	            </div>
	        </div>
	    </div>
	</div>

	<div class="modal fade bx-modal" role="dialog" id="deletestatic">
	  	<div class="modal-dialog" role="document">
	    	<div class="modal-content">
	    	  	<div class="modal-header" style="padding: 20px">
					<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
				</div>
	    		<div class="modal-body">
	    			<div class="form-group hide">
						<input type="text" id="id_del">
			         </div>
	    			<div class="bx-send-role" id="delete-static">
	    			</div>
				</div>
				<div class="modal-footer">
			        <button type="button" class="btn-cool-reset btn-cool btn" data-dismiss="modal">
			            Batal
			        </button>
					<button type="button" class="btn-primary-update btn-hero btn" id="deleteAction">
			            Hapus
			        </button>
				</div>
		    </div>
	  	</div>
	</div>
   
	<div class="modal fade bx-modal" role="dialog" id="importModal">
	  	<div class="modal-dialog" role="document">
	    	<div class="modal-content">
				<button type="button" class="close" data-dismiss="modal" aria-label="Close"><span aria-hidden="true">&times;</span></button>
				<div class="modal-header">
	    			<span><strong>Masukkan File CSV</strong></span>
	    		</div>
	    		<form action="/custom/static-route/process" method="POST" enctype="multipart/form-data">			    
		    		<div class="modal-body">
			    		<input type="file" name="file" id="file" accept=".csv" />
                        <div class="help-block">Pilih file CSV</div>
                        <div class="form-group">
							<input type="checkbox" name="overwrite" value='1'>
							Overwrite
						</div>
					<div class="modal-footer">
				        <button type="button" class="btn-cool-reset btn-cool btn" data-dismiss="modal">
				            Batal
				        </button>
						<button type="submit" class="btn-primary-update btn-hero btn" id="importAction">
				            Import
				        </button>
					</div>
				</form>
		    </div>
	  	</div>
	</div>

</div>
		
<script type="text/javascript">

	var staticRoutes = JSON.parse('<?= json_encode($static) ?>');
	var table;

	$( document ).ready(function() {
		
		$("[name='publish']").bootstrapSwitch();

	    $("#btn-export").on("click", function(){
	    	window.location = "/custom/static-route/process?export=yes";
		});

	    $("#btn-import").on("click", function(){
			$('#importModal').modal('show');
		});

		table = $('#myTable').DataTable({
	            "aaSorting": [[ 0, "desc" ]],
	            "sPaginationType": "simple_numbers",
	            "oLanguage": {
	                 "sSearch": "<span class='search-table' style='display:none'>Pencarian:</span> _INPUT_", 
	                  "sSearchPlaceholder": "Pencarian",
	                 "sInfoEmpty": "",
	                 "sEmptyTable": "Tidak terdapat static route",
	                 "sZeroRecords": "Tidak terdapat hasil Pencarian",
	                "sInfo": "Menampilkan _START_ sampai _END_ dari total _TOTAL_ Static Route ",
	            },	            
	            'createdRow': function(row, data, dataIndex){
			        $(row).attr('id', 'row-' + dataIndex);
		      	}
	        });

    	table.rowReordering({
			fnUpdateCallback: function(row){
				var allData = []; 
          		var data = table.rows().data();
          		for (var i = 0; i < data.length; i++) {
          			var temp = {
          				0 : data[i][2],
          				1 : data[i][3],
          				2 : data[i][4],
          				3 : data[i][5],
          				4 : data[i][6],
          				5 : $(data[i][7]).find('[name=publish]').prop('checked') ? 1 : 0
          			};
          			allData.push(temp);
          		}

          		showLoading();
          		$.ajax({            
		            type : "POST",
		            url  : "/custom/static-route/process",
		            data : {
	            		dataOrder : allData,		                    
		            },
		            success:function(response){
		              	window.location = "/custom/static-route/";
		            },
		    		error: function(response){
		               $('.alert.alert-warning').removeClass('hide').find('.message').html('Gagal ordering static route');
		               hideLoading();
		            }
		        });
       		}
   		});

   		$("[name=patternUrl]").on({
			keydown: function(e) {
				if (e.which === 32)
				  	return false;
				},
			change: function() {
				this.value = this.value.replace(/\s/g, "");
			}
		});

   	}); 
		
	function newStaticRoute(){
		$("#form-staticroute input").val('');
		$('[name=_index]').val(staticRoutes.length);
		$('[name=_publish]').val(1);
		$('[name=process]').val('create');
		getModule();
		validasiForm();

		$('.btn-create-update').html('Buat');
		$('#modal-form-data').modal('show');
	}

	function editStaticRoute(key){
		$("#form-staticroute input").val('');
		validasiForm();

		$('[name=_index]').val(staticRoutes[key]['_index']);
		$('[name=_patternUrl]').val(staticRoutes[key]['_patternUrl']);
		$('[name=_staticRouteName]').val(staticRoutes[key]['_staticRouteName']);
		$('[name=_publish]').val(staticRoutes[key]['_publish']);
		$('[name=_patternUrlId]').val(staticRoutes[key]['_patternUrl']);
		$('[name=process]').val('update');

		getModule(staticRoutes[key]['_module'], staticRoutes[key]['_controller'], staticRoutes[key]['_action']);

		$('.btn-create-update').html('Ubah');
		$('#modal-form-data').modal('show');
	}

	function submitStaticRoute(){
		var data = $('#form-staticroute').serialize();

		showLoading();
        $.ajax({            
            type : "POST",
            url  : "/custom/static-route/process",
            data : data,
            success:function(response){
               window.location = "/custom/static-route";
            },
    		error: function(response){
               $('.alert.alert-warning').removeClass('hide').find('.message').html('Gagal menambah static route');
               hideLoading();
            }
        });
	}

    function deleteVar(patternUrl){
		var notif = "<span>Apakah anda yakin ingin menghapus</span> '" + patternUrl + "'?";
		$('#id_del').val(patternUrl);
		$('#delete-static').html(notif);	
		$('#deletestatic').modal('show');
    }

    $("#deleteAction").on("click", function(){
    	showLoading();
		$.ajax({
    		type : "POST",
    		url  : "/custom/static-route/process",
    		data : {
				_patternUrl : $("#id_del").val(),
				process : "delete"
    		},
    		success:function(response){
    			window.location = "/custom/static-route";
    		},
    		error: function(response){
               $('.alert.alert-warning').removeClass('hide').find('.message').html('Gagal menghapus static route');
               hideLoading();
            }
    	});

	});

	$('input[name="publish"]').on('switchChange.bootstrapSwitch', function(event, state) {
		var patternUrl = $(this).closest('tr').find('td')[2].innerHTML;

		showLoading();
		$.ajax({
    		type : "POST",
    		url  : "/custom/static-route/process",
    		data : {
				_publish : state ? 1 : 0,
				_patternUrlId : patternUrl,
				process : "publish"
    		},
    		success:function(response){
    			window.location = "/custom/static-route";
    		},
    		error: function(response){
               $('.alert.alert-warning').removeClass('hide').find('.message').html('Gagal mengubah status static route');
               hideLoading();
            }
    	}); 
	});

   	function getModule(module, controller, action){
   		$.ajax({            
            type : "GET",
            url  : "/admin/misc/get-available-modules",
	        timeout: 30000,
            success:function(response){
    			$('[name=_module]').html('<option value=""> -- pick module -- </option>');
    			$.each(response.data, function(i){
					$('[name=_module]').append('<option value='+response.data[i].name+'>'+response.data[i].name+'</option>');		
    			}); 

    			if(module){
	    			$('[name=_module]').val(module)
	    			changeModule(controller, action);
    			} else {
	    			changeModule();
    			}

            	hideLoading();
            },
            error: function(response){
            	hideLoading();
	        }
        });
   	}


   	function changeModule(controller, action){
   		var module = $('[name=_module]').val();

   		showLoading();
   		$.ajax({            
            type : "GET",
            url  : "/admin/misc/get-available-controllers?moduleName=" + module,
	        timeout: 30000,
            success:function(response){
    			$('[name=_controller]').html('<option value=""> -- pick controller -- </option>');
    			$.each(response.data, function(i){
					$('[name=_controller]').append('<option value=' + response.data[i].name + '>' + response.data[i].name + '</option>');		
    			}); 

    			if(controller){
	    			$('[name=_controller]').val(controller)
		    		changeController(action);
    			} else {
		    		changeController();
    			}

            	hideLoading();
            },
            error: function(response){
            	hideLoading();
	        }
        });
   	}

   	function changeController(action){
   		var module = $('[name=_module]').val();
   		var controller = $('[name=_controller]').val();

   		showLoading();
   		$.ajax({            
            type : "GET",
            url  : "/admin/misc/get-available-actions?moduleName=" + module + "&controllerName=" + controller,
	        timeout: 30000,
            success:function(response){
    			$('[name=_action]').html('<option value="">-- pick action --</option>');
    			$.each(response.data, function(i){
					$('[name=_action]').append('<option value=' + response.data[i].name + '>' + response.data[i].name + '</option>');		
    			}); 

				if(action){
					$('[name=_action]').val(action);
				}    			

            	hideLoading();
            },
            error: function(response){
            	hideLoading();
	        }
        });
   	}

	function validasiForm(){

		var frmvalidator  = new Validator("form-staticroute");
		
		frmvalidator.EnableOnPageErrorDisplay();
		frmvalidator.EnableMsgsTogether();

		frmvalidator.addValidation("_patternUrl", "required", "pattern url harus diisi");
		frmvalidator.addValidation("_patternUrl", "regexp=^[\/].*$", "pattern url harus diawali oleh kaarakter '/'");
		frmvalidator.addValidation("_module", "required", "module harus dipilih");
		frmvalidator.addValidation("_controller", "required", "controller harus dipilih");
		frmvalidator.addValidation("_action", "required", "action harus dipilih");
		frmvalidator.addValidation("_staticRouteName", "required", "static route name harus diisi");
		
		// set callback function after pass all of validation
		frmvalidator.setCallbackFunction('submitStaticRoute()');
		
	}

</script>
