<?php
/**
 * 
 */

namespace AppModel; 

use \Pimcore\Model\DataObject;
use \AppHelper\Manager;


class OauthClient
{

	public static function checkOauthClient($params = null)
	{

		$return = new Manager();

		if (!$params->ApiKey){
			$return->Message = 'Api Key kosong';
			return $return;
		}

		if (!$params->Domain){
			$return->Message = 'Domain kosong';
			return $return;
		}

		try {
			
			$object = new DataObject\OauthClient\Listing();
			$object->setCondition('ApiKey = ? AND Domain = ?', [$params->ApiKey, $params->Domain]);
			$object = $object->load()[0];
			
			if (!$object) {
				$return->Message = 'Data tidak ditemukan';
			} else {
				$scopes = [];

				if ($object->Scope) {
					foreach ($object->Scope as $key => $value) {
						array_push($scopes, $value->Name);
					}
				}

				$object->Scope = $scopes;

				$return->Status = 1;
				$return->Data = $object;
			}

		} catch (Exception $e) {
			$return->Message = $e->getMessage();
		}

		return $return;

	}
	
	/**
	 * Fungsi untuk membuat OauthClient baru
	 * 
	 * @param  stdClass $params Name, ApiKey, Scope, Domain, Secret, RedirectUri
	 * @return stdClass	Status, Message, Data
	 */
	public static function create($params = null) {

		$return = new Manager();

		if (!$params->Name) {
			$return->Message = 'Nama kosong';
			return $return;
		}

		if (!$params->Domain) {
			$return->Message = 'Domain kosong';
			return $return;
		}
		
		try {

			// Inisialisasi object
			$object = DataObject\OauthClient::create();
			$get_path = DataObject\AbstractObject::getByPath('/oauth/client');
			$name_key = microtime(true) .'_'. rand();

			// Set core
			$object->setKey(\Pimcore\File::getValidFilename($name_key));
			$object->setParentId($get_path->o_id);
			$object->setIndex(0); 
	        $object->setPublished(1);

	        // Set data

	        if ($params->Scope) {
		        $params->Scope = str_replace(' ', '', $params->Scope);
		        $scope_array = explode(",", $params->Scope);
		        
				$scope_items = [];
				$params_scope = new \stdClass;

				foreach ($scope_array as $value) {
					$params_scope->Name = $value;
					$scope = \AppModel\OauthScope::getByName($params_scope)->Data;

					$item = DataObject\AbstractObject::getById($scope->o_id);
					array_push($scope_items, $item);
				}

				$object->setScope($scope_items);
	        }

			$object->setDomain($params->Domain);
			$object->setName($params->Name);
			$object->setRedirectUri($params->RedirectUri);
			
			$issuedDate = time();
			$randomKey = \AppHelper\General::getRandomPassword(10);
			$apiKey = hash('sha256', $issuedDate.$randomKey);
			$object->setApiKey($apiKey);

			$options = [
			    'issuedDate' => time(),
			    'randomKey' => \AppHelper\General::getRandomPassword(10),
			];

			$secret = password_hash("secret_key", PASSWORD_BCRYPT, $options);
			$object->setSecret($secret);

	        if ($object->save()) {
	        	$return->Status = 1;
	        	$return->Data = $object;
	        } else {
	        	$return->Message = 'Data gagal disimpan';
	        }

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}

		return $return;
	
	}

	/**
	 * Fungsi untuk mengambil seluruh data dari object OauthClient
	 * 
	 * @param  stdClass $params SortBy, SortType, Offset, Limit
	 * @return stdClass	Status, Message, Data
	 */
	public static function getAll($params = null) {
		
		$return = new Manager();
		
		try {

			$objects = new DataObject\OauthClient\Listing();
			
			$condition = "";
			$params_condition = [];
			
			if ($condition) {
				$objects->setCondition($condition, $params_condition);
			}

			$count = count($objects);
			$return->Count = $count;

			if ($params->SortBy) {
				$objects->setOrderKey($params->SortBy);
			}
			if ($params->SortType) {
				$objects->setOrder($params->SortType);		
			}		
			if ($params->Limit) {
				$objects->setLimit($params->Limit);		
			}		
			if ($params->Offset) {
				$objects->setOffset($params->Offset);		
			}

			if (!$count && !count($objects)) {
				$return->Message = 'Data tidak ditemukan';
			} else {
				$return->Status = 1;
				$return->Data = $objects->load();
			}

		} catch (Exception $e) {

			$return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

		}
		
		return $return;
	
	}

}