
function showLoading(){
    var style = `
            background: #000 url(/pimcore/static-custom/images/loading.gif) no-repeat center center; 
            height: 100%; width: 100%; 
            position: fixed; z-index: 9999999;  
            margin: 0px;  opacity: 0.6; filter: alpha(opacity=60); 
        `;

    var html = '<div id="divLoading" style="' + style + '"></div>';

    $("body").prepend(html);
    $("body").css("overflow","hidden");
}

function hideLoading(){
    $('#divLoading').fadeOut(2000);
    $("#divLoading").remove();
    $("body").css("overflow","auto");
}

function formatNumberCurrency(value) {
    return value.toString().replace(/(\d)(?=(\d{3})+(?!\d))/g, "$1,");
}

function validateEmail(email) {
    var re = /\S+@\S+\.\S+/;
    return re.test(email);
}

function validationText(dom) {
    dom = $(dom);
    dom.val( dom.val().replace(/[^a-z A-Z]/g, '') );
}    

function toRupiah(value){
    var rgx = /(\d+)(\d{3})/;

    value += '';
    x = value.split('.');
    x1 = x[0];
    x2 = x.length > 1 ? '.' + x[1] : '';

    while (rgx.test(x1)) {
        x1 = x1.replace(rgx, '$1' + '.' + '$2');
    }

    return 'Rp. ' + x1 + x2;
}

function checkIndonesiaNumber(phoneNumber){

    var operators = {
        "FLEXI":{
            "name":"TELKOM",
            "pattern":new RegExp(/^021(68|70)\d{4,8}$|^0([2-7]|9)[^1]\d?(3[^1]|68|70|80|81)\d{4,8}$/)
        },
        "SIMPATI":{
            "name":"TELKOMSEL",
            "pattern":new RegExp(/^08(11|12|13|21)\d{6,8}$/)
        },
        "AS":{
            "name":"TELKOMSEL",
            "pattern":new RegExp(/^08(52|53)\d{8}$/)
        },
        "MENTARI":{
            "name":"INDOSAT",
            "pattern":new RegExp(/^08(14|15|16|55|58)\d{6,8}$/)
        },
        "IM2":{
            "name":"INDOSAT",
            "pattern":new RegExp(/^0814\d{8}$/)
        },
        "IM3":{
            "name":"INDOSAT",
            "pattern":new RegExp(/^08(56|57)\d{7,8}$/)
        },
        "STARONE":{
            "name":"INDOSAT",
            "pattern":new RegExp(/^0(2130|3160)\d{4,8}$|^0([2-7]|9)[^1]\d?(61|62|63|90)\d{4,8}$/)
        },
        "XL BEBAS":{
            "name":"XL AXIATA",
            "pattern":new RegExp(/^08(17|18|19|77|78|79)\d{6,8}$/)
        },
        "SMART":{
            "name":"SMARTFREN","pattern":new RegExp(/^08(81|82)\d{4,8}$/)
        },
        "FREN":{
            "name":"SMARTFREN","pattern":new RegExp(/^0888\d{4,8}$/)
        },
        "HEPI":{
            "name":"SMARTFREN",
            "pattern":new RegExp(/^0([2-7]|9)\d{1,2}(21|31|50)\d{4,8}$/)
        },
        "ESIA":{
            "name":"BTEL",
            "pattern":new RegExp(/^(02180)\d{4,8}$|^0([2-7]|9)[^1]\d?9\d{4,8}$/)
        },
        "THREE":{
            "name":"HCPT",
            "pattern":new RegExp(/^08(96|97|98|99)\d{7,8}$/)
        },
        "AXIS":{
            "name":"AXIS",
            "pattern":new RegExp(/^08(38|31)\d{7,8}$/)
        },
        "CERIA":{
            "name":"STI",
            "pattern":new RegExp(/^0828\d{4,8}$/)
        }
    };

    var result = false;
    $.each(operators, function(service, operator) { 
        if (operator['pattern'].test(phoneNumber)) {
            result = {'provider' : operator['name'], 'product' : service};
            return false;
        }   
    });
    
    return result;  
}

function bindInputCustom(element, regex, errMsg){
   
    // event keypress
    element.unbind('keypress');
    element.bind('keypress', function (e) {
        var allowedChars = new RegExp(regex);
        var str = String.fromCharCode(!e.charCode ? e.which : e.charCode);
        if (allowedChars.test(str)) {
            return true;
        }
        e.preventDefault();
        return false;
    });

    // event change
    element.unbind('change');
    element.bind('change', function (e) {
        var allowedChars = new RegExp(regex);
        var str = $(this).val();
        if (allowedChars.test(str)) {
            return true;
        }
        e.preventDefault();
        $(this).val('');
        $(this).parent().find('.error-message').html(errMsg);
        return false;
    });
}

function setLocalStorage(key, value){
    var stringValue = JSON.stringify(value);
    localStorage.setItem(key, stringValue);
}

function getLocalStorage(key){
    var stringifyString = localStorage.getItem(key);
    return JSON.parse(stringifyString);
}

function removeLocalStorage(key){
    localStorage.removeItem(key);
}

function setLocalStorageParent(keyStorage, keySubStorage, value){
    var stringValue = JSON.stringify(value);

    var temp = getLocalStorage(keyStorage);
    var storage = temp ? temp : new Object;

    storage[keySubStorage] = value;

    setLocalStorage(keyStorage, storage);
}    

function setSessionStorage(key, value){
    var stringValue = JSON.stringify(value);
    sessionStorage.setItem(key, stringValue);
}

function getSessionStorage(key){
    var stringifyString = sessionStorage.getItem(key);
    return JSON.parse(stringifyString);
}

function removeSessionStorage(key){
    sessionStorage.removeItem(key);
}

function setSessionStorageParent(keyStorage, keySubStorage, value){
    var stringValue = JSON.stringify(value);

    var temp = getSessionStorage(keyStorage);
    var storage = temp ? temp : new Object;

    storage[keySubStorage] = value;

    setSessionStorage(keyStorage, storage);
}

function getSessionStorageParent(keyStorage, keySubStorage){
    var temp = getSessionStorage(keyStorage);
    var storage = temp ? temp : new Object;

    return storage[keySubStorage];
}
