// Function to get name of month by number
function numToMonth(num, is_long) {
    var short_months = ['Jan', 'Feb', 'Mar', 'Apr', 'Mei', 'Jun', 'Jul', 'Ags', 'Sep', 'Okt', 'Nov', 'Des'];
    var long_months = ['Januari','Februari','Maret','April','Mei','Juni','Juli','Agustus','September','Oktober','November','Desember'];
    if (is_long == 1) {
        return long_months[num];
    } else {
        return short_months[num];
    }
}

// Show overlay loading screen function
function showLoading(){
    var style = 
            'background: #fff url(/assets/images/loading.gif) no-repeat center center;'+
            'height: 100%; width: 100%;'+ 
            'position: fixed; z-index: 9999999;'+ 
            'margin: 0px;  opacity: 0.6; filter: alpha(opacity=60);';

    var html = '<div id="divLoading" style="' + style + '"></div>';

    if(!$('#divLoading').length){    
        $("body").prepend(html);
        $("body").css("overflow","hidden");
    }
}

function hideLoading(){
    setTimeout(function(){     
        $('#divLoading').fadeOut(2000);
        $("#divLoading").remove();
        $("body").css("overflow","auto");
    }, 700);
}

//show hide loading field
function showLoadingField(parent){
    var html = '<div class="loading-field">\
                    <img src="/assets/images/spinner.gif" alt="">\
                </div>';
    parent.append(html);
}

function hideLoadingField(parent){
    if(parent){
        parent.find('.loading-field').remove();
    } else {
        $('.loading-field').remove();
    }
}

function validateEmail(email) {
    var re = /\S+@\S+\.\S+/;
    return re.test(email);
}

function validationText(dom) {
    dom = $(dom);
    dom.val( dom.val().replace(/[^a-z A-Z]/g, '') );
}    

function formatNumberCurrency(value) {
    return value.toString().replace(/(\d)(?=(\d{3})+(?!\d))/g, "$1,");
}

function toRupiah(value, prefix){
    var rgx = /(\d+)(\d{3})/;

    value += '';
    x = value.split('.');
    x1 = x[0];
    x2 = x.length > 1 ? '.' + x[1] : '';

    while (rgx.test(x1)) {
        x1 = x1.replace(rgx, '$1' + '.' + '$2');
    }

    prefix = prefix ? prefix : "Rp. "
    return prefix + x1 + x2;
}

function checkIndonesiaNumber(phoneNumber){

    var operators = {
        "FLEXI":{
            "name":"TELKOM",
            "pattern":new RegExp(/^021(68|70)\d{4,8}$|^0([2-7]|9)[^1]\d?(3[^1]|68|70|80|81)\d{4,8}$/)
        },
        "SIMPATI":{
            "name":"TELKOMSEL",
            "pattern":new RegExp(/^08(11|12|13|21)\d{6,8}$/)
        },
        "AS":{
            "name":"TELKOMSEL",
            "pattern":new RegExp(/^08(52|53)\d{8}$/)
        },
        "MENTARI":{
            "name":"INDOSAT",
            "pattern":new RegExp(/^08(14|15|16|55|58)\d{6,8}$/)
        },
        "IM2":{
            "name":"INDOSAT",
            "pattern":new RegExp(/^0814\d{8}$/)
        },
        "IM3":{
            "name":"INDOSAT",
            "pattern":new RegExp(/^08(56|57)\d{7,8}$/)
        },
        "STARONE":{
            "name":"INDOSAT",
            "pattern":new RegExp(/^0(2130|3160)\d{4,8}$|^0([2-7]|9)[^1]\d?(61|62|63|90)\d{4,8}$/)
        },
        "XL BEBAS":{
            "name":"XL AXIATA",
            "pattern":new RegExp(/^08(17|18|19|77|78|79)\d{6,8}$/)
        },
        "SMART":{
            "name":"SMARTFREN","pattern":new RegExp(/^08(81|82)\d{4,8}$/)
        },
        "FREN":{
            "name":"SMARTFREN","pattern":new RegExp(/^0888\d{4,8}$/)
        },
        "HEPI":{
            "name":"SMARTFREN",
            "pattern":new RegExp(/^0([2-7]|9)\d{1,2}(21|31|50)\d{4,8}$/)
        },
        "ESIA":{
            "name":"BTEL",
            "pattern":new RegExp(/^(02180)\d{4,8}$|^0([2-7]|9)[^1]\d?9\d{4,8}$/)
        },
        "THREE":{
            "name":"HCPT",
            "pattern":new RegExp(/^08(96|97|98|99)\d{7,8}$/)
        },
        "AXIS":{
            "name":"AXIS",
            "pattern":new RegExp(/^08(38|31)\d{7,8}$/)
        },
        "CERIA":{
            "name":"STI",
            "pattern":new RegExp(/^0828\d{4,8}$/)
        }
    };

    var result = false;
    $.each(operators, function(service, operator) { 
        if (operator['pattern'].test(phoneNumber)) {
            result = {'provider' : operator['name'], 'product' : service};
            return false;
        }   
    });
    
    return result;  
}

function bindInputCustom(element, regex, errMsg){
   
    // event keypress
    element.unbind('keypress');
    element.bind('keypress', function (e) {
        var allowedChars = new RegExp(regex);
        var str = String.fromCharCode(!e.charCode ? e.which : e.charCode);
        if (allowedChars.test(str)) {
            return true;
        }
        e.preventDefault();
        return false;
    });

    // event change
    element.unbind('change');
    element.bind('change', function (e) {
        var allowedChars = new RegExp(regex);
        var str = $(this).val();
        if (allowedChars.test(str)) {
            return true;
        }
        e.preventDefault();
        $(this).val('');
        $(this).parent().find('.error-message').html(errMsg);
        return false;
    });
}

function setLocalStorage(key, value){
    var stringValue = JSON.stringify(value);
    localStorage.setItem(key, stringValue);
}

function getLocalStorage(key){
    var stringifyString = localStorage.getItem(key);
    return JSON.parse(stringifyString);
}

function removeLocalStorage(key){
    localStorage.removeItem(key);
}

function setLocalStorageParent(keyStorage, keySubStorage, value){
    var stringValue = JSON.stringify(value);

    var temp = getLocalStorage(keyStorage);
    var storage = temp ? temp : new Object;

    storage[keySubStorage] = value;

    setLocalStorage(keyStorage, storage);
}    

function setSessionStorage(key, value){
    var stringValue = JSON.stringify(value);
    sessionStorage.setItem(key, stringValue);
}

function getSessionStorage(key){
    var stringifyString = sessionStorage.getItem(key);
    return JSON.parse(stringifyString);
}

function removeSessionStorage(key){
    sessionStorage.removeItem(key);
}

function setSessionStorageParent(keyStorage, keySubStorage, value){
    var stringValue = JSON.stringify(value);

    var temp = getSessionStorage(keyStorage);
    var storage = temp ? temp : new Object;

    storage[keySubStorage] = value;

    setSessionStorage(keyStorage, storage);
}

function getSessionStorageParent(keyStorage, keySubStorage){
    var temp = getSessionStorage(keyStorage);
    var storage = temp ? temp : new Object;

    return storage[keySubStorage];
}

function getDate() {

    now = new Date();

    year = "" + now.getFullYear();
    month = "" + (now.getMonth() + 1); if (month.length == 1) { month = "0" + month; }
    day = "" + now.getDate(); if (day.length == 1) { day = "0" + day; }
    hour = "" + now.getHours(); if (hour.length == 1) { hour = "0" + hour; }
    minute = "" + now.getMinutes(); if (minute.length == 1) { minute = "0" + minute; }
    second = "" + now.getSeconds(); if (second.length == 1) { second = "0" + second; }

    return year + month +  day +  hour + minute + second;

}

function indonesiaDate(timestamp, date_format, suffix){

    if(timestamp == ''){
        timestamp = new Date();
    } else if(!isNaN(timestamp)){
        timestamp = new Date(timestamp * 1000);
    }

    if(date_format == ''){
        date_format = 'd-M-Y';
    }

    (function() {
        // This function created by : https://github.com/jacwright/date.format

        Date.shortMonths = ['Jan', 'Feb', 'Mar', 'Apr', 'Mei', 'Jun', 'Jul', 'Ags', 'Sep', 'Okt', 'Nov', 'Des'];
        Date.longMonths = ['Januari','Februari','Maret','April','Mei','Juni','Juli','Agustus','September','Oktober','November','Desember'];
        Date.shortDays = ['Min','Sen','Sel','Rab','Kam','Jum','Sab'];
        Date.longDays = ['Minggu','Senin','Selasa','Rabu','Kamis','Jumat','Sabtu'];

        // defining patterns
        var replaceChars = {
            // Day
            d: function() { return (this.getDate() < 10 ? '0' : '') + this.getDate(); },
            D: function() { return Date.shortDays[this.getDay()]; },
            j: function() { return this.getDate(); },
            l: function() { return Date.longDays[this.getDay()]; },
            N: function() { return (this.getDay() == 0 ? 7 : this.getDay()); },
            S: function() { return (this.getDate() % 10 == 1 && this.getDate() != 11 ? 'st' : (this.getDate() % 10 == 2 && this.getDate() != 12 ? 'nd' : (this.getDate() % 10 == 3 && this.getDate() != 13 ? 'rd' : 'th'))); },
            w: function() { return this.getDay(); },
            z: function() { var d = new Date(this.getFullYear(),0,1); return Math.ceil((this - d) / 86400000); }, // Fixed now
            // Week
            W: function() {
                var target = new Date(this.valueOf());
                var dayNr = (this.getDay() + 6) % 7;
                target.setDate(target.getDate() - dayNr + 3);
                var firstThursday = target.valueOf();
                target.setMonth(0, 1);
                if (target.getDay() !== 4) {
                    target.setMonth(0, 1 + ((4 - target.getDay()) + 7) % 7);
                }
                var retVal = 1 + Math.ceil((firstThursday - target) / 604800000);
              
                return (retVal < 10 ? '0' + retVal : retVal);
            },
            // Month
            F: function() { return Date.longMonths[this.getMonth()]; },
            m: function() { return (this.getMonth() < 9 ? '0' : '') + (this.getMonth() + 1); },
            M: function() { return Date.shortMonths[this.getMonth()]; },
            n: function() { return this.getMonth() + 1; },
            t: function() {
                var year = this.getFullYear(), nextMonth = this.getMonth() + 1;
                if (nextMonth === 12) {
                    year = year++;
                    nextMonth = 0;
                }
                return new Date(year, nextMonth, 0).getDate();
            },
            // Year
            L: function() { var year = this.getFullYear(); return (year % 400 == 0 || (year % 100 != 0 && year % 4 == 0)); },   // Fixed now
            o: function() { var d  = new Date(this.valueOf());  d.setDate(d.getDate() - ((this.getDay() + 6) % 7) + 3); return d.getFullYear();}, //Fixed now
            Y: function() { return this.getFullYear(); },
            y: function() { return ('' + this.getFullYear()).substr(2); },
            // Time
            a: function() { return this.getHours() < 12 ? 'am' : 'pm'; },
            A: function() { return this.getHours() < 12 ? 'AM' : 'PM'; },
            B: function() { return Math.floor((((this.getUTCHours() + 1) % 24) + this.getUTCMinutes() / 60 + this.getUTCSeconds() / 3600) * 1000 / 24); }, // Fixed now
            g: function() { return this.getHours() % 12 || 12; },
            G: function() { return this.getHours(); },
            h: function() { return ((this.getHours() % 12 || 12) < 10 ? '0' : '') + (this.getHours() % 12 || 12); },
            H: function() { return (this.getHours() < 10 ? '0' : '') + this.getHours(); },
            i: function() { return (this.getMinutes() < 10 ? '0' : '') + this.getMinutes(); },
            s: function() { return (this.getSeconds() < 10 ? '0' : '') + this.getSeconds(); },
            u: function() { var m = this.getMilliseconds(); return (m < 10 ? '00' : (m < 100 ?
        '0' : '')) + m; },
            // Timezone
            e: function() { return /\((.*)\)/.exec(new Date().toString())[1]; },
            I: function() {
                var DST = null;
                    for (var i = 0; i < 12; ++i) {
                            var d = new Date(this.getFullYear(), i, 1);
                            var offset = d.getTimezoneOffset();

                            if (DST === null) DST = offset;
                            else if (offset < DST) { DST = offset; break; }                     else if (offset > DST) break;
                    }
                    return (this.getTimezoneOffset() == DST) | 0;
                },
            O: function() { return (-this.getTimezoneOffset() < 0 ? '-' : '+') + (Math.abs(this.getTimezoneOffset() / 60) < 10 ? '0' : '') + Math.floor(Math.abs(this.getTimezoneOffset() / 60)) + (Math.abs(this.getTimezoneOffset() % 60) == 0 ? '00' : ((Math.abs(this.getTimezoneOffset() % 60) < 10 ? '0' : '')) + (Math.abs(this.getTimezoneOffset() % 60))); },
            P: function() { return (-this.getTimezoneOffset() < 0 ? '-' : '+') + (Math.abs(this.getTimezoneOffset() / 60) < 10 ? '0' : '') + Math.floor(Math.abs(this.getTimezoneOffset() / 60)) + ':' + (Math.abs(this.getTimezoneOffset() % 60) == 0 ? '00' : ((Math.abs(this.getTimezoneOffset() % 60) < 10 ? '0' : '')) + (Math.abs(this.getTimezoneOffset() % 60))); }, // Fixed now
            T: function() { return this.toTimeString().replace(/^.+ \(?([^\)]+)\)?$/, '$1'); },
            Z: function() { return -this.getTimezoneOffset() * 60; },
            // Full Date/Time
            c: function() { return this.format("Y-m-d\\TH:i:sP"); }, // Fixed now
            r: function() { return this.toString(); },
            U: function() { return this.getTime() / 1000; }
        };

        // Simulates PHP's date function
        Date.prototype.format = function(format) {
            var date = this;
            return format.replace(/(\\?)(.)/g, function(_, esc, chr) {
                return (esc === '' && replaceChars[chr]) ? replaceChars[chr].call(date) : chr;
            });
        };

    }).call(this);

    
    return timestamp.format(date_format);
}

function toRomawi(num) {  
  var result = '';
  var decimal = [1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1];
  var roman = ["M", "CM","D","CD","C", "XC", "L", "XL", "X","IX","V","IV","I"];
  for (var i = 0;i<=decimal.length;i++) {
    while (num%decimal[i] < num) {     
      result += roman[i];
      num -= decimal[i];
    }
  }
  return result;
}

function fromRomawi(str) {  
  var result = 0;
  // the result is now a number, not a string
  var decimal = [1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1];
  var roman = ["M", "CM","D","CD","C", "XC", "L", "XL", "X","IX","V","IV","I"];
  for (var i = 0;i<=decimal.length;i++) {
    while (str.indexOf(roman[i]) === 0){
      result += decimal[i];
      str = str.replace(roman[i],'');
    }
  }
  return result;
}

var capt_cha = {
    bounds: {
        lower: 5,
        upper: 50
    },
    first: 0,
    second: 0,
    third: 0,
    generate: function()
    {
        this.first = Math.floor(Math.random() * this.bounds.lower) + 1;
        this.second = Math.floor(Math.random() * this.bounds.upper) + 1;
        this.third = Math.floor(Math.random() * this.bounds.lower) + 1;        
    },
    show: function()
    {
        return this.first + ' + ' + this.second + ' + ' + this.third;
    },
    solve: function()
    {
        return this.first + this.second + this.third;
    }
};
