module.exports = function (grunt) {
    grunt.initConfig({
        pkg: grunt.file.readJSON('package.json'),

        // Tasks
        sass: { // Begin Sass Plugin
            dist: {
                options: {
                    sourcemap: 'none'
                },
                files: [{
                    expand: true,
                    cwd: 'sass',
                    src: ['style.scss'],
                    dest: 'css/',
                    ext: '.css'
                }]
            }
        },
        cssmin: { // Begin CSS Minify Plugin
            target: {
                files: [{
                    expand: true,
                    cwd: 'css',
                    src: ['!style.min.css'], // ['style.css', '!style.min.css]
                    dest: 'css/',
                    ext: '.min.css'
                }]
            }
        },
        // uglify: { // Begin JS Uglify Plugin
        //     build: {
        //         src: ['src/*.js'],
        //         dest: 'js/script.min.js'
        //     }
        // },
        watch: { // Compile everything into one task with Watch Plugin
            css: {
                files: 'scss/*.scss',
                tasks: ['scss', 'cssmin']
            },
            // js: {
            //     files: '**/.js',
            //     tasks: ['uglify']
            // }
        },
        browserSync: {
            dev: {
                bsFiles: {
                    src: ['css/*.css']
                },
                options: {
                    watchTask: true,
                    proxy: 'localhost/grunt',
                    debugInfo: true,
                }               
            }
        }
  });
    
    // Load Grunt plugins
    grunt.loadNpmTasks('grunt-browser-sync');
    grunt.loadNpmTasks('grunt-contrib-sass');
    grunt.loadNpmTasks('grunt-contrib-cssmin');
    // grunt.loadNpmTasks('grunt-contrib-uglify');
    grunt.loadNpmTasks('grunt-contrib-watch');
    grunt.loadNpmTasks('grunt-sass');

    // Register Grunt tasks
    grunt.registerTask('default', ['sass','browserSync','watch']);
};