<?php
use Api\Controller\Action;

class Api_EmailBucketController extends Zend_Rest_Controller {

    public function init() {
        $this->_helper->viewRenderer->setNoRender(true);
        $this->_helper->AjaxContext()
                ->addActionContext('get', 'json')
                ->addActionContext('post', 'json')
                ->addActionContext('new', 'json')
                ->addActionContext('edit', 'json')
                ->addActionContext('put', 'json')
                ->addActionContext('delete', 'json')
                ->initContext('json');
    }

    public function sendEmailAction(){

        $params = new stdClass;
        $params->SortBy = "o_creationDate";
        $params->Order = "desc";

        // initial condition for get valid data
        $condition1 = "((Status <> 'Success' OR (IFNULL(Counter, 0) < 1)))"; // if Status != Success OR (Counter < 1 OR Counter = NULL)        
        $condition2 = "(IFNULL(Counter, 0) < 100)"; // if Counter < 100)
        $params->Condition = "o_published = 1 AND " . $condition1 . " AND " . $condition2;

        $params->Limit = 10;
        $emails = Object_EmailBucketManager::get($params);
        
        if($emails->Status){            
            foreach ($emails->Data as $email) {
                $params = new stdClass;  
                $params->From = $email->From;      
                $params->To = $email->To;
                $params->Subject = $email->Subject;
                $params->Cc = $email->CC;
                $params->Bcc = $email->BCC;
                $params->Template = $email->Template;
                $params->Params = (array)json_decode($email->Params);
                $params->BodyHtml = $email->BodyText;

                $return = Website_Helper::sendEmail($params); 
                if($return->Status){
                    $email->Status = "Success";
                }else{
                    $email->Message = $return->Message;
                    $email->Status = "Failed";
                }
                $email->Counter = $email->Counter ? $email->Counter+1 : 1;
                $email->save(); 
            }              
        }
    }

    public function sendEmailByIdAction(){

        $email = Object\EmailBucket::getById($_POST['id']);      
        if($email){
            $params = new stdClass;  
            $params->From = $email->From;      
            $params->To = $email->To;
            $params->Subject = $email->Subject;
            $params->Cc = $email->CC;
            $params->Bcc = $email->BCC;
            $params->Template= $email->Template;
            $params->Params = (array) json_decode($email->Params);
            $params->BodyHtml = $email->BodyText;

            $return = Website_Helper::sendEmail($params); 
            if($return->Status){
                $email->Status = "Success";
            }else{
                $email->Message = $return->Message;
                $email->Status = "Failed";
            }
            $email->Counter = $email->Counter ? ($email->Counter+1) : 1;
            $email->save(); 
        }
    }    

    public function deleteEmailAction(){

        $time = $_GET["t"];

        $params = new stdClass;
        $params->SortBy = "o_modificationDate";
        $params->Order = "desc";
        $limitTime = strtotime('-'.$time.' minutes', time());
        $params->Condition = "o_published = 1 AND Status = 'Success' AND o_modificationDate < ".$limitTime;

        $emails = Object_EmailBucketManager::get($params);
        
        if($emails->Status){            
            foreach ($emails->Data as $email) {
                $object = Object\EmailBucket::getById($email->o_id);
                $object->delete();
            
            }              
        }
    }

    public function addEmailAction(){

        $params = new stdClass;
        $params->Delay = $_POST['Delay'];
        $params->Activity = $_POST['Activity'];
        $params->To = $_POST['To'];
        $params->From = $_POST['From'];
        $params->Subject = $_POST['Subject'];
        $params->Cc = $_POST['Cc'];
        $params->Bcc = $_POST['Bcc'];
        $params->Template = (array) json_decode($_POST['Template']);
        $params->Params = $_POST['Params'];
        $params->Message = $_POST['Message'];
        $params->BodyText = $_POST['BodyText'];

        $object = Object_EmailBucketManager::add($params);
    }

    public function headAction() {}
    public function indexAction() {}
    public function postAction() {}    
    public function putAction() {}
    public function deleteAction() {}
    public function getAction() {}

}
