<?php
use Api\Controller\Action;

class Api_OrganisasiController extends Zend_Rest_Controller {

    public function init() {
        $this->_helper->viewRenderer->setNoRender(true);
        $this->_helper->AjaxContext()
                ->addActionContext('get', 'json')
                ->addActionContext('post', 'json')
                ->addActionContext('new', 'json')
                ->addActionContext('edit', 'json')
                ->addActionContext('put', 'json')
                ->addActionContext('delete', 'json')
                ->initContext('json');
    }

    public function headAction() {}
    public function indexAction() {}
    public function postAction() {}    
    public function putAction() {}
    public function getAction() {}

    public function createAction(){
        $params = (object) $_POST['Data'];

        $result = Object_OrganisasiManager::create($params);
        
        $resultJson = json_encode($result, JSON_PARTIAL_OUTPUT_ON_ERROR);
        echo $resultJson;

        die();
    }

    public function updateAction(){
        $params = (object) $_POST['Data'];

        $result = Object_OrganisasiManager::update($params);

        $resultJson = json_encode($result, JSON_PARTIAL_OUTPUT_ON_ERROR);
        echo $resultJson;

        die();
    }

    public function deleteAction(){

        $params = new stdClass;
        $params->Id = $_POST['Id'];

        $result = Object_OrganisasiManager::delete($params);
        
        $resultJson = json_encode($result, JSON_PARTIAL_OUTPUT_ON_ERROR);
        echo $resultJson;

        die();
    }

    public function searchAction(){

        $params = new stdClass;
        $params->Search = $_POST['Search'];
        $result = Object_OrganisasiManager::getDetail($params);
        
        $resultJson = json_encode($result, JSON_PARTIAL_OUTPUT_ON_ERROR);
        echo $resultJson;

    }

    public function searchUnitOrganisasiAction(){

        $params = new stdClass;
        $params->Search = $_POST['Search'];
        $params->IdOrganisasi = $_POST['IdOrganisasi'];
        $result = Object_UnitOrganisasiManager::getDetailByOrganisasi($params);
        
        $resultJson = json_encode($result, JSON_PARTIAL_OUTPUT_ON_ERROR);
        echo $resultJson;

    }

    public function searchPesertaAction(){

        $params = new stdClass;
        $params->Search = $_POST['Search'];
        $params->IdOrganisasi = $_POST['IdOrganisasi'];
        $result = Object_PesertaManager::getDetailByOrganisasi($params);
        
        $resultJson = json_encode($result, JSON_PARTIAL_OUTPUT_ON_ERROR);
        echo $resultJson;

    }

    public function listPesertaByTopologiAction(){

        $params = (object) $_POST;
        $result = Object_PesertaManager::getDetailByOrganisasi($params);

        // for temporary hardcode list
        $result = new stdClass;
        $result->Status = 1;
        $result->Message = '';
        $result->Data = array(
                    [121, "Budiarto"],
                    [122, "Wati"],
                    [123, "Kusuma"],
                    [124, "Meri"],
                    [121, "Budiarto"],
                    [122, "Wati"],
                    [123, "Kusuma"],
                    [124, "Meri"],
                    [124, "Meri"],
                    [124, "Meri"],
                    [125, "Joko"]
            );
        
        $resultJson = json_encode($result, JSON_PARTIAL_OUTPUT_ON_ERROR);
        echo $resultJson;

    }    

}
