<?php
use Api\Controller\Action;

class Api_UserController extends Zend_Rest_Controller {

    public function init() {
        $this->_helper->viewRenderer->setNoRender(true);
        $this->_helper->AjaxContext()
                ->addActionContext('get', 'json')
                ->addActionContext('post', 'json')
                ->addActionContext('new', 'json')
                ->addActionContext('edit', 'json')
                ->addActionContext('put', 'json')
                ->addActionContext('delete', 'json')
                ->initContext('json');
    }

    public function headAction() {}
    public function indexAction() {}
    public function postAction() {}    
    public function putAction() {}
    public function deleteAction() {}
    public function getAction() {}

    public function loginAction(){
        $params = (object) $_POST;
    
        $resultUser = Object_UserManager::checkUserPass($params);
        $resultPeserta = Object_PesertaManager::checkUserPass($params);

        if($resultUser->Status){
            $result = $resultUser;
            $user = $resultUser->Data[0];
            $user->Role = "Admin";
            $session = Website_Helper::setSession("SESSION_LOGIN", $user);
        }elseif ($resultPeserta->Status) {
            $result = $resultPeserta;
            $user = $resultPeserta->Data[0];
            $user->Role = "Peserta";
            $session = Website_Helper::setSession("SESSION_LOGIN", $user);
        } else {
            $result = $resultPeserta;
        }

        $resultJson = json_encode($result, JSON_PARTIAL_OUTPUT_ON_ERROR);
        echo $resultJson;

        die();
    }

    public function registerAction(){

        $params = (object) $_POST;    
        $result = Object_PesertaManager::create($params);

        $resultJson = json_encode($result, JSON_PARTIAL_OUTPUT_ON_ERROR);
        echo $resultJson;

        die();
    }    

}
