<?php

use Custom\Controller\Action;

class Custom_StaticRouteController extends Action
{
    public function init() {
        parent::init();

        // check pimcore admin user
        $user = Website_Helper::checkPimcoreLogin();
        if (!$user) {
            echo "
	            Maaf anda tidak dapat mengakses halaman ini, silahkan login sebagai Administrator <br><br>
                <button onclick=\"window.open('/admin/login', '_blank');\";> login Administrator </button>
            ";
            die();
        } else {
	        if (!$user->admin) {
		        echo "
		            Maaf akun Anda tidak dapat mengakses halaman ini, silahkan logout dan login kembali sebagai Administrator <br><br>
	                <button onclick=\"window.open('/admin/login', '_blank');\";> login Administrator </button>
		        ";

	        	Website_Helper::logoutPimcorePanel($this);
          	  	die();
	        }
        }

    }

    public function defaultAction(){
        $objects = Custom_Helper::getStaticRoute();
    	$this->view->Static = $objects;
        
        $this->enableLayout();
    }

    public function processAction(){

		$index = $_POST["id"];
		$patternUrl = $_POST["patternUrl"];
		$module = $_POST["module"];
		$controller = $_POST["nameController"];
		$action = $_POST["action"];
        $staticRouteName = $_POST["staticRouteName"];
        $metaTitle = $_POST['metaTitle'];
        $metaDesc = $_POST['metaDesc'];
        $metaKeyword = $_POST['metaKeyword'];
        $metaH1 = $_POST['metaH1'];
        $metaH2 = $_POST['metaH2'];
        $metaH3 = $_POST['metaH3'];
        $process = $_POST["process"];

		if($process){

			Custom_Helper::crudStaticRoute($process, $patternUrl, $module, $controller, $action, $staticRouteName, $metaTitle, $metaDesc, $metaKeyword, $metaH1, $metaH2, $metaH3 , $index);

		} else if ($_POST["dataOrder"]){

			$static = $_POST['dataOrder'];
			Custom_Helper::replaceDataStaticRoute($static);
		
		} else if ($_GET["export"] == "yes"){
            
			Custom_Helper::exportStaticRoute();
		
		} else if (isset($_FILES['file'])){

			$file_type = $_FILES['file']['type'];

			if ($file_type != "application/vnd.ms-excel"){
				Website_Helper::redirect("/custom/static-route/default/?upload=no-csv");
			}else{
				$file_name = $_FILES['file']['name'];
				$file_size = $_FILES['file']['size'];
		      	$file_tmp  = $_FILES['file']['tmp_name'];
		     	
		     	move_uploaded_file($file_tmp,$_SERVER['DOCUMENT_ROOT']."/website/var/".$file_name);
				Custom_Helper::importStaticRoute($_SERVER['DOCUMENT_ROOT']."/website/var/".$file_name);
				Website_Helper::redirect("/custom/static-route/");
			}
			
		}
        die();

    }
    
}	

?>