<?php

/*
    This is for PHP function helper
    Initial by Ahmad Somadi
*/

use Pimcore\File;
use Pimcore\Model\Asset;

class Custom_Helper {

    public static function createTableGlobalVariable(){
        $queryNewTable = "CREATE TABLE dreamcube_global_variable (
                _key VARCHAR(100) NOT NULL,
                _value VARCHAR(500),
                _description VARCHAR(5000),
                _index INT NOT NULL,
                PRIMARY KEY(_key)
            )DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci";

        $createTable = Website_Helper::runQuery($queryNewTable);
    }

    // function for get global varibale data, if params $key is empty => get all data
    public static function getGlobalVariable($key = null){

        $key = $key ? strtoupper($key) : '';

        $databaseConfig = \Pimcore\Config::getSystemConfig()->database->toArray();
        $existTable = Website_Helper::makeQuery("SELECT * FROM information_schema.TABLES WHERE TABLE_NAME = 'dreamcube_global_variable' AND TABLE_SCHEMA = '". $databaseConfig['params']['dbname'] ."'");
        if(!$existTable){
            Custom_Helper::createTableGlobalVariable();
        }

        if($key){

            $existRecord = Website_Helper::makeQuery("select * FROM dreamcube_global_variable WHERE _key = '" . $key . "'");

            if(!$existRecord){
                Custom_Helper::crudGlobalVariable('create', $key);
            }        

            if(!$existRecord[0]["_value"]){
                die('Global variable "' . $key . '" masih kosong');
            }        

            return $existRecord[0]["_value"]; // return value global variable
        
        } else {

            $globalVariables = Website_Helper::makeQuery("select * FROM dreamcube_global_variable ORDER BY _index ASC");
            return $globalVariables; // return all global variable
        
        }
    }

    /**
     * Fungsi ini digunakan untuk mengeset nilai global variable
     * Jika belum terdapat key global variable tersebut, maka akan otomatis membuat global variable dengan key tersebut
     * 
     * @param String $key   not null, key untuk mendapatkan nilai global variable
     * @param String $value not null, nilai untuk global variable dari key yang diinginkan 
     * @param String $description not null, deskripsi untuk global variable dari key yang diinginkan 
     * @return boolean true, jika global variable berhasil di set, false jika gagal
     */
    public static function setGlobalVariable($key, $value, $description)
    {

        if ($key && $value && $description) {
            self::getGlobalVariable($key);
            self::crudGlobalVariable('update', $key, $value, $description);
            return true;
        }

        return false;
    
    }

    // function for create, update and delete global varible
    public static function crudGlobalVariable($action, $key, $value = '', $description = '', $index = ''){

        $key = $key ? strtoupper($key) : '';

        $databaseConfig = \Pimcore\Config::getSystemConfig()->database->toArray();
        $existTable = Website_Helper::makeQuery("SELECT * FROM information_schema.TABLES WHERE TABLE_NAME = 'dreamcube_global_variable' AND TABLE_SCHEMA = '". $databaseConfig['params']['dbname'] ."'");
        if(!$existTable){
            Custom_Helper::createTableGlobalVariable();
        }

        $existRecord = Website_Helper::makeQuery("select * FROM dreamcube_global_variable WHERE _key = '" . $key . "'");

        if($action == 'create'){
            if(!$existRecord){
                $query = "INSERT INTO dreamcube_global_variable (_key, _value, _description, _index) VALUES ('". $key . "', '". $value . "', '". $description . "', '". $index . "')";
            } else {
                Custom_Helper::crudGlobalVariable('update',  $key, $value, $description, $index);
            }
        } else if($action == 'update') {
            if($existRecord){
                $query = "UPDATE dreamcube_global_variable SET _value = '". $value ."', _description = '". $description ."', _index = '". $index ."' WHERE _key = '". $key ."'";
            }
        } else if($action == 'delete') {
            if($existRecord){
                $query = "DELETE FROM dreamcube_global_variable WHERE _key = '". $key ."'";
            }
        }
    
        if($query)  Website_Helper::runQuery($query);

    }

    // function for export all data global variable
    public static function exportGlobalVariable(){  
         $data = array();
        $objects = Custom_Helper::getGlobalVariable();     
        if($objects){
            foreach($objects as $object){
                $temp = array();
                foreach($object as $obj){
                    array_push($temp, $obj);
                }
                array_push($data, $temp);
            }

            $path = PIMCORE_DOCUMENT_ROOT .'/website/var/tmp/';
            if(!file_exists($path)){
                mkdir($path, 0777);
            }

            $filename = (string)microtime(true);
            Website_Helper::createCsvFile($path, $filename, $data);

            $file = $path.$filename.".csv";     
            if (file_exists($file)) {
                header('Content-Description: File Transfer');
                header('Content-Type: application/octet-stream');
                header('Content-Disposition: attachment; filename="global-variable.csv"');
                header('Expires: 0');
                header('Cache-Control: must-revalidate');
                header('Pragma: public');
                header('Content-Length: ' . filesize($file));
                readfile($file);
                unlink($file);
            }
        }

        exit;            
    }

    // function for import data global variable, params $filename is path of uploaded file
    public static function importGlobalVariable($filename){
        $data = Website_Helper::readCsvFile($filename);
        Custom_Helper::replaceDataGlobalVariable($data);

        unlink($filename);
    }

    // function for replace all data on table dreamcube_global_variable, if params $data is empty == clear all data on the table
    public static function replaceDataGlobalVariable($data = null){
        // check exist table dreamcube_global_variable
        $databaseConfig = \Pimcore\Config::getSystemConfig()->database->toArray();
        $existTable = Website_Helper::makeQuery("SELECT * FROM information_schema.TABLES WHERE TABLE_NAME = 'dreamcube_global_variable' AND TABLE_SCHEMA = '". $databaseConfig['params']['dbname'] ."'");
        if(!$existTable){
            Custom_Helper::createTableGlobalVariable();
        }

        // truncate table dreamcube_global_variable
        Website_Helper::runQuery("TRUNCATE TABLE dreamcube_global_variable");

        if($data){
            foreach ($data as $row) {            
                if($row[0])
                    Custom_Helper::crudGlobalVariable('create',  $row[0], $row[1], $row[2], $row[3]);                        
            }            
        }
    }

    public static function createTableStaticRoute(){
        $queryNewTable = "CREATE TABLE dreamcube_static_route (
                _patternUrl VARCHAR(255) NOT NULL,
                _module VARCHAR(255),
                _controller VARCHAR(255),
                _action VARCHAR(255),
                _staticRouteName VARCHAR(255),
                _metaTitle VARCHAR(255),
                _metaDescription VARCHAR(255),
                _metaKeyword VARCHAR(255),
                _metaH1 VARCHAR(255),
                _metaH2 VARCHAR(255),
                _metaH3 VARCHAR(255),
                _index INT NOT NULL,
                PRIMARY KEY(_patternUrl)
            )DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci";

        $createTable = Website_Helper::runQuery($queryNewTable);
    }

    // function for get global varibale data, if params $patternUrl is empty => get all data
    public static function getStaticRoute($patternUrl = null){
        $databaseConfig = \Pimcore\Config::getSystemConfig()->database->toArray();
        $existTable = Website_Helper::makeQuery("SELECT * FROM information_schema.TABLES WHERE TABLE_NAME = 'dreamcube_static_route' AND TABLE_SCHEMA = '". $databaseConfig['params']['dbname'] ."'");
        if(!$existTable){
            Custom_Helper::createTableStaticRoute();
        }

        if($patternUrl){

            $existRecord = Website_Helper::makeQuery("select * FROM dreamcube_static_route WHERE _patternUrl = '" . $patternUrl . "'");

            if(!$existRecord){
                Custom_Helper::crudStaticRoute('create', $patternUrl);
            }        

            if(!$existRecord[0]["_module"]){
                die('static route "' . $patternUrl . '" masih kosong');
            }        

            return $existRecord[0]["_module"]; // return module static route
        
        } else {

            $staticRoutes = Website_Helper::makeQuery("select * FROM dreamcube_static_route ORDER BY _index ASC");
            return $staticRoutes; // return all static route
        
        }
    }

    // function for create, update and delete global varible
    public static function crudStaticRoute($action, $patternUrl, $module = '', $controller = '', $nameaction = '', $staticRouteName = '',$metaTitle = '', $metaDescription = '', $metaKeyword = '', $metaH1 = '', $metaH2 = '', $metaH3 = '', $index = ''){

        $databaseConfig = \Pimcore\Config::getSystemConfig()->database->toArray();
        $existTable = Website_Helper::makeQuery("SELECT * FROM information_schema.TABLES WHERE TABLE_NAME = 'dreamcube_static_route' AND TABLE_SCHEMA = '". $databaseConfig['params']['dbname'] ."'");
        
        if(!$existTable){
            Custom_Helper::createTableStaticRoute();
        }

        $existRecord = Website_Helper::makeQuery("select * FROM dreamcube_static_route WHERE _patternUrl = '" . $patternUrl . "'");

        if($action == 'create'){

            if(!$existRecord){
                $query = "INSERT INTO dreamcube_static_route (_patternUrl, _module, _controller, _action, _staticRouteName, _metaTitle, _metaDescription, _metaKeyword, _metaH1, _metaH2, _metaH3, _index) VALUES ('". $patternUrl . "', '". $module . "', '". $controller . "', '". $nameaction . "','". $staticRouteName . "','". $metaTitle . "','". $metaDescription . "','". $metaKeyword . "','". $metaH1 . "','". $metaH2 . "','". $metaH3 . "','". $index . "')";
            } else {
                Custom_Helper::crudStaticRoute('update',  $patternUrl, $module, $controller, $nameaction, $staticRouteName, $metaTitle, $metaDescription, $metaKeyword, $metaH1, $metaH2, $metaH3, $index);
            }
        } else if($action == 'update') {
            if($existRecord){
                $query = "UPDATE dreamcube_static_route SET _module = '". $module ."', _controller = '". $controller ."', _action= '". $nameaction ."', _staticRouteName= '". $staticRouteName ."', _metaTitle= '". $metaTitle ."', _metaDescription= '". $metaDescription ."', _metaKeyword= '". $metaKeyword ."', _metaH1= '". $metaH1 ."', _metaH2= '". $metaH2 ."', _metaH3= '". $metaH3 ."', _index = '". $index ."' WHERE _patternUrl = '". $patternUrl ."'";
            }
        } else if($action == 'delete') {
            if($existRecord){
                $query = "DELETE FROM dreamcube_static_route WHERE _patternUrl = '". $patternUrl ."'";
            }
        }
    
        if($query)  Website_Helper::runQuery($query);

    }

    // function for export all data static route
    public static function exportStaticRoute(){  
        $data = array();
        $objects = Custom_Helper::getStaticRoute();     
        if($objects){
            foreach($objects as $object){
                $temp = array();
                foreach($object as $obj){
                    array_push($temp, $obj);
                }
                array_push($data, $temp);
            }

            $path = PIMCORE_DOCUMENT_ROOT .'/website/var/tmp/';
            if(!file_exists($path)){
                mkdir($path, 0777);
            }

            $filename = (string)microtime(true);
            Website_Helper::createCsvFile($path, $filename, $data);

            $file = $path.$filename.".csv";     
            if (file_exists($file)) {
                header('Content-controller: File Transfer');
                header('Content-Type: application/octet-stream');
                header('Content-Disposition: attachment; filename="static-route.csv"');
                header('Expires: 0');
                header('Cache-Control: must-revalidate');
                header('Pragma: public');
                header('Content-Length: ' . filesize($file));
                readfile($file);
                unlink($file);
            }
        }

        exit;            
    }

    // function for import data static route, params $filename is path of uploaded file
    public static function importStaticRoute($filename){
        $data = Website_Helper::readCsvFile($filename);
        Custom_Helper::replaceDataStaticRoute($data);

        unlink($filename);
    }

    // function for replace all data on table dreamcube_static_route, if params $data is empty == clear all data on the table
    public static function replaceDataStaticRoute($data = null){
        // check exist table dreamcube_static_route
        $databaseConfig = \Pimcore\Config::getSystemConfig()->database->toArray();
        $existTable = Website_Helper::makeQuery("SELECT * FROM information_schema.TABLES WHERE TABLE_NAME = 'dreamcube_static_route' AND TABLE_SCHEMA = '". $databaseConfig['params']['dbname'] ."'");
        if(!$existTable){
            Custom_Helper::createTableStaticRoute();
        }

        // truncate table dreamcube_static_route
        Website_Helper::runQuery("TRUNCATE TABLE dreamcube_static_route");

        if($data){
            foreach ($data as $row) {            
                if($row[0])
                    Custom_Helper::crudStaticRoute('create',  $row[0], $row[1], $row[2], $row[3], $row[4], $row[5], $row[6], $row[7], $row[8], $row[9], $row[10], $row[11]);                        
            }            
        }
    }
}
