<?php

use Sabos\Controller\Action;

class Sabos_DashboardController extends Action
{

	public function init()
    {
        $user = Website_Helper::getSession('SESSION_LOGIN');
        if(!$user){
            website_Helper::redirect('/sabos/login');
        }elseif ($user->Role == "Peserta") {
            website_Helper::redirect('/sabos/update-profile');
        }
        
        $this->view->User = $user;
    }

    public function defaultAction()
    {
        $this->enableLayout();
    }

    public function historyAction()
    {        

        $events = array();
        for($i=0; $i < 10; $i++){
            array_push($events, 
                    array(
                        "Name" => "History Name",
                        "Description" => "History Description",
                        "Date" => 1497999252  + ((60*60*24*2) * $i)
                    )
                );
        }

        $this->view->events = $events;
        $this->layout()->setLayout('layout');
    }    
    
}
