<?php

use Sabos\Controller\Action;

class Sabos_DefaultController extends Action
{
    
    public function defaultAction()
    {
        Website_Helper::redirect('/sabos/login');
    }

    public function loginAction()
    {   
        $user = Website_Helper::getSession('SESSION_LOGIN');
        if ($user->Role == 'Admin') {
            website_Helper::redirect('/sabos/dashboard');
        }elseif ($user->Role == "Peserta") {
            website_Helper::redirect('/sabos/update-profile');
        }

        $this->layout()->setLayout('layout-login');
    }

    public function logoutAction()
    {
        Website_Helper::removeSession("SESSION_LOGIN");
        website_Helper::redirect("/sabos/login");
    }

    public function lockAction()
    {
        $this->layout()->setLayout('layout-lock');        
    }

    public function registerAction()
    {
        $this->layout()->setLayout('layout-login');        
    }    

    public function activateAction()
    {
        $this->view->SuccessActivate = 0;

        $params = new stdClass;
        $params->Email = Website_Helper::stringDecompress($_GET['e']);    
        $user = Object_PesertaManager::getByEmail($params)->Data;

        if(!$user){
            Website_Helper::redirect('/error404');
        }

        if($user->Status){
            $this->view->alreadyActivate = 1;
        } else {

            $chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
            $password = substr(str_shuffle( $chars ), 0, 6);                 

            $user->setStatus(1);
            $user->setPassword($password);

            if($user->save()){
                $this->view->SuccessActivate = 1;

                // send email
                $params = new stdClass;
                $params->Activity = "Sukses aktifasi peserta independen";
                $params->To = $user->Email;
                $params->Params = array(
                        'Username' => $user->Username,
                        'Nama' => $user->Nama,
                        'Password' => $password,
                        'LinkLogin' => Website_Helper::getSiteUrl() . 'sabos/login'                    
                    );
                $params->Template = '/template-email/sabos/success_activate_independent';
                $objectMail = Object_EmailBucketManager::add($params);                    
            }
            
        }

        $this->layout()->setLayout('layout-peserta');
    }        

    public function successRegistrationAction()
    {
        $this->layout()->setLayout('layout-peserta');
    }    

    public function updateProfileAction()
    {

        $user = Website_Helper::getSession('SESSION_LOGIN');
        if(!$user){
            website_Helper::redirect('/sabos/login');
        }elseif ($user->Role == "Admin") {
            website_Helper::redirect('/sabos/dashboard/');
        }

        // already do kuesioner, if yes = 1
        $params = new stdClass;
        $params->IdPeserta = $user->o_id;
        $this->view->flagKuesioner = Object_MsaiManager::getByPeserta($params)->Status ? 1 : 0;

        $user = Object\Peserta::getById($user->o_id);
        $this->view->Peserta = $user;

        $city = Object_MasterManager::getCity()->Data;
        $province = Object_MasterManager::getProvince()->Data; 

        $this->view->City = $city;
        $this->view->Province = $province;  

        $this->view->titlePage = "Lengkapi Profil Anda";
        $this->layout()->setLayout('layout-peserta');
    }

    public function thankyouAction()
    {

        $user = Website_Helper::getSession('SESSION_LOGIN');
        if(!$user){
            website_Helper::redirect('/sabos/login');
        }elseif ($user->Role == "Admin") {
            website_Helper::redirect('/sabos/dashboard/');
        }

        if($_GET['ok']){
            // send email
            $params = new stdClass;
            $params->Activity = "Berhasil melakukan asesmen";
            $params->To = $entries->Email;
            $params->Params = array(
                    'Nama' => $entries->Nama,
                    'LinkResume' => Website_Helper::getSiteUrl() . 'sabos/summary'
                );
            $params->Template = '/template-email/sabos/success_assesment';
            $objectMail = Object_EmailBucketManager::add($params);                    
        }    

        $user = Object\Peserta::getById($user->o_id);
        $this->view->Peserta = $user;
        $this->view->titlePage = "";
        $this->layout()->setLayout('layout-peserta');
    }

    public function summaryAction()
    {
        $user = Website_Helper::getSession('SESSION_LOGIN');
        if(!$user){
            website_Helper::redirect('/sabos/login');
        }elseif ($user->Role == "Admin") {
            website_Helper::redirect('/sabos/dashboard/');
        }

        $params = new stdClass;
        $params->IdPeserta = $user->o_id;
        $summary = Object_SummaryManager::getSummary($params)->Data; 
        
        $this->view->Summary = $summary;

        $user = Object\Peserta::getById($user->o_id);
        $this->view->Peserta = $user;
        $this->view->titlePage = "";
        $this->layout()->setLayout('layout-peserta');
    }        

    public function getResumeAction()
    {
        $userLogin = Website_Helper::getSession('SESSION_LOGIN');
        if(!$userLogin){
            website_Helper::redirect('/sabos/login');
        }

        $id = $_GET['id'];
        if(!$id){
            Website_Helper::redirect('/error404');
        }

        $user = Object::getById($id);
        $type = $user->o_className;

        $params = new stdClass;

        if($type == "Peserta"){
            $params->IdPeserta = $id;        
            $summary = Object_SummaryManager::getSummary($params)->Data;
        } else {
            if ($userLogin->Role == "Admin") {            
                if($type == "Organisasi") {
                    $params->IdOrganisasi = $id;
                    $summary = Object_SummaryManager::getSummary($params)->Data; 
                } else if($type == "UnitOrganisasi") {
                    $params->IdUnitOrganisasi = $id;
                    $summary = Object_SummaryManager::getSummary($params)->Data;
                } else {
                    Website_Helper::redirect('/error404');            
                }
            } else {
                Website_Helper::redirect('/error404');                            
            }
        }

        $this->view->Summary = $summary;
        $this->view->User = $user;
        $this->view->Type = $type;
        $this->view->titlePage = "";

        $this->layout()->setLayout('layout-peserta');
    }            

}
