<?php

use Sabos\Controller\Action;

class Sabos_OrganisasiController extends Action
{

    public function init()
    {
        $user = Website_Helper::getSession('SESSION_LOGIN');
        if(!$user){
            website_Helper::redirect('/sabos/login');
        }elseif ($user->Role == "Peserta") {
            website_Helper::redirect('/sabos/update-profile');
        }
        
        $this->view->User = $user;
    }

    public function defaultAction()
    {
        $data_organisasi = Object_OrganisasiManager::getDetail()->Data;
        
        $this->view->DataOrganisasi = $data_organisasi;
        $this->enableLayout();
    }

    public function detailAction()
    {
        $id_organisasi = $_GET['id'];
        
        $params = new stdClass;
        $params->IdOrganisasi = $id_organisasi;

        $data_organisasi = Object_OrganisasiManager::getDetail($params)->Data;
        $summary = Object_SummaryManager::getSummary($params)->Data;

        $this->view->HaveSummary = $summary['rvs'] && $summary['ocai'] && $summary['msai'];
        $this->view->Summary = $summary;
        $this->view->DataOrganisasi = $data_organisasi;

        if(!$this->view->HaveSummary){
            Website_Helper::redirect('error404');            
        }
        
	    $this->enableLayout();
    }

    public function manajemenDataAction()
    {
        $organisasi = Object_OrganisasiManager::getDetail()->Data;
        
        $data = array();

        foreach ($organisasi as $key => $value) {
            array_push($data,
                    (object) array(
                        "o_id" => $value["o_id"],
                        "Nama" => $value["Nama"],
                        "Email" => $value["Email"],
                        "Alamat" => $value["Alamat"],
                        "UnitKerja" => $value["UnitKerja"],
                        "Peserta" => $value["Peserta"],
                        "Logo" => $value["Logo"]
                    )            
            );
        }

        $this->view->data = $data;
        $this->enableLayout();
    }

    public function unitKerjaAction()
    {
        $id_organisasi = $_GET['id'];

        $params = new stdClass;
        $params->IdOrganisasi = $id_organisasi;

        $data_unit_organisasi = Object_UnitOrganisasiManager::getDetailByOrganisasi($params)->Data;
        $data_organisasi = Object_OrganisasiManager::getDetail($params)->Data;
        $summary = Object_SummaryManager::getSummary($params)->Data;

        $this->view->HaveSummary = $summary['rvs'] && $summary['ocai'] && $summary['msai'];
        $this->view->Summary = $summary;
        $this->view->DataOrganisasi = $data_organisasi;
        $this->view->DataUnitOrganisasi = $data_unit_organisasi;
        $this->enableLayout();
    }

    public function pesertaAction()
    {
        $id_organisasi = $_GET['id'];

        $params = new stdClass;
        $params->IdOrganisasi = $id_organisasi;

        $data_peserta = Object_PesertaManager::getDetailByOrganisasi($params)->Data;
        $data_organisasi = Object_OrganisasiManager::getDetail($params)->Data;
        $summary = Object_SummaryManager::getSummary($params)->Data;

        $this->view->HaveSummary = $summary['rvs'] && $summary['ocai'] && $summary['msai'];
        $this->view->Summary = $summary;
        $this->view->DataOrganisasi = $data_organisasi;
        $this->view->DataPeserta = $data_peserta;
        $this->enableLayout();

    }

}
