<?php

use Sabos\Controller\Action;

class Sabos_PesertaController extends Action
{

    public function init()
    {
        $user = Website_Helper::getSession('SESSION_LOGIN');
        if(!$user){
            website_Helper::redirect('/sabos/login');
        }elseif ($user->Role == "Peserta") {
            website_Helper::redirect('/sabos/update-profile');
        }
        
        $this->view->User = $user;
    }

    public function defaultAction()
    {

        $data_peserta = Object_PesertaManager::getDetailByOrganisasi()->Data;
        
        $this->view->DataPeserta = $data_peserta;
        $this->enableLayout();

    }	

    public function independentAction()
    {

        $data_peserta = Object_PesertaManager::getIndependent()->Data;

        $this->view->DataPeserta = $data_peserta;
        $this->enableLayout();

    }  

    public function personalInfoAction()
    {
    	$id_peserta = $_GET['id'];

        $params = new stdClass;
        $params->Id = $id_peserta;

        $data_peserta = Object_PesertaManager::getById($params)->Data;
        
        $params->IdPeserta = $id_peserta;
        $summary = Object_SummaryManager::getSummary($params)->Data;

        $this->view->HaveSummary = $summary['rvs'] && $summary['ocai'] && $summary['msai'];
        $this->view->Summary = $summary;
        $this->view->DataPeserta = $data_peserta;
        $this->enableLayout();
    }   

    public function detailAction()
    {
        $id_peserta = $_GET['id'];

        $params = new stdClass;
        $params->Id = $id_peserta;

        $data_peserta = Object_PesertaManager::getById($params)->Data;
        
        $params->IdPeserta = $id_peserta;
        $summary = Object_SummaryManager::getSummary($params)->Data;

        $this->view->HaveSummary = $summary['rvs'] && $summary['ocai'] && $summary['msai'];
        $this->view->Summary = $summary;
        $this->view->DataPeserta = $data_peserta;

        if(!$this->view->HaveSummary){
            Website_Helper::redirect('error404');            
        }

        $this->enableLayout();
    }    

    public function manajemenDataAction()
    {

        $id_unit_organisasi = $_GET['id'];
        
        $params = new stdClass;
        $params->IdUnitOrganisasi = $id_unit_organisasi;
        $peserta = Object_PesertaManager::getByUnitOrganisasi($params)->Data;

        $params = new stdClass;
        $params->Id = $id_unit_organisasi;
        $unit_organisasi = Object_UnitOrganisasiManager::getById($params)->Data->Name;

        $params = new stdClass;
        $params->Id = $unit_organisasi->o_id;
        $organisasi = Object_OrganisasiManager::getById($params)->Data->Name;

        $data = array();

        if($peserta) {
            foreach ($peserta as $key => $value) {
                array_push($data,
                    (object) array(
                        "o_id" => $value['o_id'],
                        "Nama" => $value['Nama'],
                        "Email" => $value['Email'],
                        "Telepon" => $value['Telepon'],
                        "JenisKelamin" => $value['JenisKelamin'],
                        "TingkatPendidikan" => $value['TingkatPendidikan'],
                        "TanggalLahir" => date('d/m/Y',$value['TanggalLahir']),
                        "Provinsi" => $value['Provinsi'],
                        "Kota" => $value['Kota'],                    
                        "Jabatan" => $value['Jabatan'],
                        "Nip" => $value['NIP'],
                        "Foto" => $value['FotoProfil'],
                        "Username" => $value['Username']
                    )
                );
            }
        }

        $city = Object_MasterManager::getCity()->Data;
        $province = Object_MasterManager::getProvince()->Data; 

        $this->view->City = $city;
        $this->view->Province = $province;	
        $this->view->data = $data;
        $this->enableLayout();
    }

}
