<?php

use Sabos\Controller\Action;

class Sabos_UnitOrganisasiController extends Action
{

    public function init()
    {
        $user = Website_Helper::getSession('SESSION_LOGIN');
        if(!$user){
            website_Helper::redirect('/sabos/login');
        }elseif ($user->Role == "Peserta") {
            website_Helper::redirect('/sabos/update-profile');
        }
        
        $this->view->User = $user;
    }

    public function defaultAction()
    {
	    $this->enableLayout();
    }	

    public function detailAction()
    {
        $id_unit_organisasi = $_GET['id'];
        
        $params = new stdClass;
        $params->IdUnitOrganisasi = $id_unit_organisasi;

        $data_unit_organisasi = Object_UnitOrganisasiManager::getDetail($params)->Data;
        $summary = Object_SummaryManager::getSummary($params)->Data;

        $this->view->HaveSummary = $summary['rvs'] && $summary['ocai'] && $summary['msai'];
        $this->view->Summary = $summary;
        $this->view->DataUnitOrganisasi = $data_unit_organisasi;

        if(!$this->view->HaveSummary){
            Website_Helper::redirect('error404');            
        }

        $this->enableLayout();
    }   

    public function manajemenDataAction()
    {

        $id_organisasi = $_GET['id'];

        $params = new stdClass;
        $params->IdOrganisasi = $id_organisasi;

        $data_unit_organisasi = Object_UnitOrganisasiManager::getDetailByOrganisasi($params)->Data;
        
        $data = array();
        if ($data_unit_organisasi) {
            foreach ($data_unit_organisasi as $key => $value) {
                array_push($data,
                    (object) array(
                        "o_id" => $value['o_id'],
                        "Nama" => $value['Nama'],
                        "Peserta" => $value['Peserta']
                    )
                );
            }
        }

        $summary = Object_SummaryManager::getSummary($params)->Data;

        $this->view->HaveSummary = $summary['rvs'] && $summary['ocai'] && $summary['msai'];
        $this->view->Summary = $summary;
        $this->view->data = $data;
        $this->enableLayout();
    }

    public function pesertaAction()
    {
        $id_unit_organisasi = $_GET['id'];
        
        $params = new stdClass;
        $params->IdUnitOrganisasi = $id_unit_organisasi;

        $data_unit_organisasi = Object_UnitOrganisasiManager::getDetail($params)->Data;
        $data_peserta = Object_PesertaManager::getByUnitOrganisasi($params)->Data;

        $summary = Object_SummaryManager::getSummary($params)->Data;

        $this->view->HaveSummary = $summary['rvs'] && $summary['ocai'] && $summary['msai'];
        $this->view->Summary = $summary;
        $this->view->DataUnitOrganisasi = $data_unit_organisasi;
        $this->view->DataPeserta = $data_peserta;
        $this->enableLayout();
    }

}
