<?php

class Object_MsaiManager { 

    public static function create($params = null) {

    	$return = new stdClass;
		$return->Status = 0;
		$return->Message = '';
		$return->Data = NULL;

        $peserta = Object\Peserta::getById($params->IdPeserta);

        $path = $peserta->o_path.$peserta->o_key;
        $getParentPath = Object_Abstract::getByPath($path);
        $parentId = $getParentPath->o_id;

        //create folder msai each peserta
        $folderKey = \Pimcore\File::getValidFilename("msai"); // Name of the folder

        if (!Object\Service::pathExists($path."/".$folderKey)) {
            $folder = Object\Folder::create(array(
                  "o_parentId" => $parentId,
                  "o_creationDate" => time(),
                  "o_userOwner" => 1,
                  "o_userModification" => 1,
                  "o_key" => $folderKey,
                  "o_published" => true
            ));

            $folder->setCreationDate(time());
            $folder->setUserOwner(1);
            $folder->setUserModification(1);

            try {
                $folder->save();
                $path = $path."/".$folderKey;
            } catch (\Exception $e) {
                $return->Message = $e->getMesage();
            }     
        } else {
            $path = $path."/".$folderKey;
        }

		$getPath = Object_Abstract::getByPath($path);

		$entries = new Object\Msai();
        $entries->setNama($params->Nama);
		$entries->setPernyataan($params->Pernyataan);
		$entries->setNilai($params->Nilai);
        $entries->setKeterangan($params->Keterangan);


		$peserta = Object\Peserta::getById($params->IdPeserta);
		$entries->setPeserta($peserta);

		$entries->setKey(\Pimcore\File::getValidFilename($params->Nama."-".microtime(true)));
		$entries->setParentId($getPath->o_id);
		$entries->setIndex(0);
		$entries->setPublished(1);
		
		if($entries->save()){
			$return->Status = 1;
			$return->Message = "Anda berhasil menambahkan MSAI";
			$return->Data = $entries;
		}else{
			$return->Message = "Anda gagal menambahkan MSAI";
		}

		return $return;

    }
    
    public static function getById($params = null){

    	$return = new stdClass;
        $return->Status = 0;
        $return->Message = '';
        $return->Data = NULL;

        if(!$params->Id){
            $return->Message = 'Id MSAI kosong';
            return $return;
        }

        try{
            $object = Object\Msai::getById($params->Id);
            if(!$object){
                $return->Message = 'MSAI tidak ditemukan';
                return $return;
            }
            
            $return->Data = $object;
            $return->Status = 1;
        }

        catch(Exception $e){
            $return->Message = 'Periksa lagi data yang dimasukkan';
            $return->Data = $e;
        }
        return $return;

    }

    public static function getByPeserta($params = null){

    	$return = new stdClass;
		$return->Status = 0;
		$return->Message = '';
		$return->Data = NULL;

		if(!$params->IdPeserta){
            $return->Message = 'Id peserta kosong';
            return $return;
        }

        try{
            $objects = new Object\Msai\Listing();
            $objects->setCondition("Peserta__id = ?", [$params->IdPeserta]);
            $objects = $objects->load();

            if(!$objects){
                $return->Message = 'MSAI tidak ditemukan';
                return $return;
            }
            
            $return->Data = $objects;
            $return->Status = 1;
        }

        catch(Exception $e){
            $return->Message = 'Periksa lagi data yang dimasukkan';
            $return->Data = $e;
        }

		return $return;
    }
               
}
