<?php

class Object_OcaiManager { 

    public static function create($params = null) {

        $return = new stdClass;
        $return->Status = 0;
        $return->Message = '';
        $return->Data = NULL;


        $peserta = Object\Peserta::getById($params->IdPeserta);

        $path = $peserta->o_path.$peserta->o_key;
        $getParentPath = Object_Abstract::getByPath($path);
        $parentId = $getParentPath->o_id;

        //create folder Ocai each peserta
        $folderKey = \Pimcore\File::getValidFilename("ocai"); // Name of the folder

        if (!Object\Service::pathExists($path."/".$folderKey)) {
            $folder = Object\Folder::create(array(
                  "o_parentId" => $parentId,
                  "o_creationDate" => time(),
                  "o_userOwner" => 1,
                  "o_userModification" => 1,
                  "o_key" => $folderKey,
                  "o_published" => true
            ));

            $folder->setCreationDate(time());
            $folder->setUserOwner(1);
            $folder->setUserModification(1);

            try {
                $folder->save();
                $path =$path."/".$folderKey;
            } catch (\Exception $e) {
               $return->Message = $e->getMessage();
               return $return;
            }     
        } else {
            $path =$path."/".$folderKey;
        }

        $getPath = Object_Abstract::getByPath($path);

        $entries = new Object\Ocai();
        $entries->setPernyataan($params->Pernyataan);
        $entries->setKategori($params->Kategori);
        $entries->setTipe($params->Tipe);
        $entries->setUkSi($params->UkSi);
        $entries->setUkDi($params->UkDi);
        $entries->setKlhSi($params->KlhSi);
        $entries->setKlhDi($params->KlhDi);
        
        $entries->setPeserta($peserta);

        $entries->setKey(\Pimcore\File::getValidFilename($params->Kategori."-".$params->Tipe));
        $entries->setParentId($getPath->o_id);
        $entries->setIndex(0);
        $entries->setPublished(1);
        
        if($entries->save()){
            $return->Status = 1;
            $return->Message = "Anda berhasil menambahkan OCAI";
            $return->Data = $entries;
        }else{
            $return->Message = "Anda gagal menambahkan OCAI";
        }

        return $return;

    }
    
    public static function getById($params = null){

        $return = new stdClass;
        $return->Status = 0;
        $return->Message = '';
        $return->Data = NULL;

        if(!$params->Id){
            $return->Message = 'Id OCAI kosong';
            return $return;
        }

        try{
            $object = Object\Ocai::getById($params->Id);
            if(!$object){
                $return->Message = 'OCAI tidak ditemukan';
                return $return;
            }
            
            $return->Data = $object;
            $return->Status = 1;
        }

        catch(Exception $e){
            $return->Message = 'Periksa lagi data yang dimasukkan';
            $return->Data = $e;
        }
        return $return;

    }

    public static function getByPeserta($params = null){

        $return = new stdClass;
        $return->Status = 0;
        $return->Message = '';
        $return->Data = NULL;

        if(!$params->IdPeserta){
            $return->Message = 'Id peserta kosong';
            return $return;
        }

        try{
            $objects = new Object\Ocai\Listing();
            $objects->setCondition("Peserta__id = ?", [$params->IdPeserta]);
            $objects = $objects->load();

            if(!$objects){
                $return->Message = 'MSAI tidak ditemukan';
                return $return;
            }
            
            $return->Data = $objects;
            $return->Status = 1;
        }

        catch(Exception $e){
            $return->Message = 'Periksa lagi data yang dimasukkan';
            $return->Data = $e;
        }

        return $return;
    }


               
}
