<?php

class Object_OrganisasiManager { 

    public static function create($params = null) 
    {

        $return = new stdClass;
        $return->Status = 0;
        $return->Message = '';
        $return->Data = NULL;

        try {

            $getPath = Object_Abstract::getByPath("/sabos/organisasi");

            $entries = new Object\Organisasi();
            $entries->setNama($params->Nama);
            $entries->setAlamat($params->Alamat);
            $entries->setEmail($params->Email);
       
            if ($params->Logo) {
                $logo;
                $logo_params = new stdClass;
                if (isset($params->Foto['tmp_name'])) {
                    $logo = $params->Foto;
                } else {
                    $logo = [];
                    $logo['Data'] = $params->Logo;
                    $logo['Name'] = microtime(true) .'.jpg';
                    $logo_params->Type = 'base64';
                }
                $logo_params->Path = '/organisasi/';
                $logo_params->Image = $logo;
                $asset = Website_Helper::uploadFileToAsset($logo_params);
                if ($asset) {
                    $entries->setLogo($asset);
                }
            }

            $entries->setKey(\Pimcore\File::getValidFilename($params->Nama."-".microtime(true)));
            $entries->setParentId($getPath->o_id);
            $entries->setIndex(0);
            $entries->setPublished(1);
            
            if($entries->save()){
                $return->Status = 1;
                $return->Message = "Anda berhasil menambahkan organisasi";
                $return->Data = $entries;
            }else{
                $return->Message = "Anda gagal menambahkan RVS";
            }
        } catch (Exception $e) {
            $return->Message = $e->getMessage();
        }
        

        return $return;

    }

    public static function update($params = null) 
    {

        $return = new stdClass;
        $return->Status = 0;
        $return->Message = '';
        $return->Data = NULL;

        try {
            
            if(!$params->Id){
                $return->Message = "Id organisasi tidak ada";
                return $return;
            }

            $organisasi = Object\Organisasi::getById($params->Id);

            if(!$organisasi){
                $return->Message = "Organisasi dengan Id ".$params->Id." ini tidak ada";
                return $return;
            }

            if($params->Nama) $organisasi->Nama = $params->Nama;     
            if($params->Alamat) $organisasi->Alamat = $params->Alamat;  
            if($params->Email) $organisasi->Email = $params->Email;

            if ($params->Logo) {
                $logo_params = new stdClass;
                if (isset($params->Logo['tmp_name'])) {
                    $logo = $params->Logo;
                } else {
                    $logo = [];
                    $logo['Data'] = $params->Logo;
                    $logo['Name'] = microtime(true) .'.jpg';
                    $logo_params->Type = 'base64';
                }
                $logo_params->Path = '/organisasi/';
                $logo_params->Image = $logo;

                $asset = Website_Helper::uploadFileToAsset($logo_params);
                
                if ($asset) {
                    if ($organisasi->Logo) {
                        $organisasi->Logo->delete();
                    }
                    $organisasi->setLogo($asset);
                }
            }
            
            if($organisasi->save()){
                $return->Status = 1;
                $return->Data = $organisasi;
            }else{
                $return->Message = "Anda gagal mengirim pesan kepada kami.";
            }

        } catch (Exception $e) {
            $return->Message = $e->getMessage();
        }
            
        return $return;
    }

    public static function delete($params = null)
    {

        $return = new stdClass;
        $return->Status = 0;
        $return->Message = '';
        $return->Data = NULL;

        if(!$params->Id){
            $params->Message = "Id Organisasi tidak boleh kosong";
        }

        $object = Object\Organisasi::getById($params->Id);
        if(!$object){
            $return->Message = "Organisasi tidak ada";
            return $return;
        }
        $object->delete();
        $return->Status = 1;

        return $return;
    }
    
    public static function getById($params = null)
    {

        $return = new stdClass;
        $return->Status = 0;
        $return->Message = '';
        $return->Data = NULL;

        if(!$params->Id){
            $return->Message = 'Id Organisasi kosong';
            return $return;
        }

        try{
            $object = Object\Organisasi::getById($params->Id);
            if(!$object){
                $return->Message = 'Organisasi tidak ditemukan';
                return $return;
            }
            
            $return->Data = $object;
            $return->Status = 1;
        }

        catch(Exception $e){
            $return->Message = 'Periksa lagi data yang dimasukkan';
            $return->Data = $e;
        }
        return $return;

    }

    public static function getByName($params = null) 
    {

        $return = new stdClass;
        $return->Status = 0;
        $return->Message = '';
        $return->Data = NULL;

        try{
            $objects = new Object\Organisasi\Listing();
            $objects->setCondition("Nama LIKE '%".$params->Nama."%'");
            $objects = $objects->load();
            if(!$objects){
                $return->Message = 'Organisasi dengan nama ini tidak ditemukan';
                return $return;
            }

            $return->Data = $objects;
            $return->Status = 1;
        }

        catch(Exception $e){
            $return->Message = 'Periksa lagi data yang dimasukkan';
            $return->Data = $e;
        }
        return $return;

    }

    public static function getAll($params = null) 
    {

        $return = new stdClass;
        $return->Status = 0;
        $return->Message = '';
        $return->Data = NULL;

        try{
            $objects = new Object\Organisasi\Listing();
            $objects = $objects->load();
            if(!$objects){
                $return->Message = 'Organisasi dengan nama ini tidak ditemukan';
                return $return;
            }

            $return->Data = $objects;
            $return->Status = 1;
        }

        catch(Exception $e){
            $return->Message = 'Periksa lagi data yang dimasukkan';
            $return->Data = $e;
        }
        return $return;

    }

    /**
     * Manager ini untuk mendapatkan organisasi yang terdiri dari Id, Nama, Logo, 
     * Total Unit Organisasi dan Total Peserta 
     * parameter yang dapat digunakan adala id organisasi yang nantinya dipakai pada detail organisasi
     *  
     * @param  stdClass $params 
     * @return stdClass [description]
     */
    public static function getDetail($params = null)
    {

        $return = new stdClass;
        $return->Status = 0;
        $return->Message = '';
        $return->Data = NULL;

        $id_peserta = Website_Helper::getIdByClassName('Peserta');
        $id_unit_organisasi = Website_Helper::getIdByClassName('UnitOrganisasi');
        $id_organisasi = Website_Helper::getIdByClassName('Organisasi');
 
        $condition = $params->IdOrganisasi ? "Where Og.o_id = ".$params->IdOrganisasi : "";
        if($params->Search){
            $condition .=  $condition ? " AND (Og.Nama LIKE '%".$params->Search."%')" : "Where (Og.Nama LIKE '%".$params->Search."%')";
        }
        $query = "  SELECT 
                        Og.o_id as 'o_id',
                        Og.Nama as 'Nama',
                        Og.Email as 'Email',
                        Og.Alamat as 'Alamat',
                        count(UOG.Unit_Organisasi) as 'UnitKerja',
                        IF(sum(UOG.Total_Peserta) IS NULL, '0',sum(UOG.Total_Peserta) ) AS 'Peserta',
                        CONCAT(assets.path,assets.filename) as 'Logo'

                    from object_".$id_organisasi." as Og

                    LEFT JOIN 
                        (
                            select 
                            tmp_og.Nama As 'Organisasi',
                            tmp_uog.Nama as 'Unit_Organisasi',
                            count(tmp_p.Nama) as 'Total_Peserta'

                            from object_".$id_peserta." as tmp_p 
                            RIGHT JOIN object_".$id_unit_organisasi." as tmp_uog ON tmp_uog.o_id = tmp_p.UnitOrganisasi__id
                            LEFT JOIN object_".$id_organisasi." as tmp_og ON tmp_uog.Organisasi__id = tmp_og.o_id

                            group by tmp_uog.Nama

                        ) as UOG ON Og.Nama = UOG.Organisasi

                    LEFT JOIN assets ON assets.id = Og.Logo ".$condition." 
                    group by Og.Nama ";
        
        $objects = Website_Helper::makeQuery($query);

        $return->Status = 1;
        $return->Data = $objects;
        
        return $return;

    }

}
