<?php

class Object_PesertaManager { 

    public static function getAll($params = null) {

        $return = new stdClass;
        $return->Status = 0;
        $return->Message = '';
        $return->Data = NULL;
        
        try {

            $objects = new Object\Peserta\Listing();
            if($params->Condition)
                $objects->setCondition($params->Condition);
            $objects = $objects->load();

            if (count($objects)) {
                $return->Status = 1;
                $return->Data = $objects;
            } else {
                 $return->Message = 'Data tidak ditemukan';
            }

        } catch (Exception $e) {

            $return->Message = 'Terjadi kesalahan, silahkan hubungi Administrator';

        }
        
        return $return;
    
    }

    public static function create($params = null) {

        $return = new stdClass;
        $return->Status = 0;
        $return->Message = '';
        $return->Data = NULL;

        try {
            
            $emailPeserta = self::getByEmail($params);
            $usernamePeserta = self::getByUsername($params);

            //check email dan username user (admin) 
            $emailUser = Object_UserManager::getByEmail($params);
            $usernameUser = Object_UserManager::getByUsername($params);

            // check email null/empty can register peserta
            if(!$params->Email){
                $emailPeserta->Status = 0;                
                $emailUser->Status = 0;
            }

            if($emailPeserta->Status || $emailUser->Status){

                $return->Message = "Email " . $params->Email . " sudah digunakan oleh user lain";

            }elseif ($usernamePeserta->Status || $usernameUser->Status) {

                $return->Message = "Username " . $params->Username . " sudah digunakan oleh user lain";

            }else {

                $entries = new Object\Peserta();
                $entries->setNama($params->Nama);
                $entries->setEmail($params->Email);
                $entries->setJenisKelamin($params->JenisKelamin);
                $entries->setProvinsi($params->Provinsi);
                $entries->setKota($params->Kota);
                $entries->setUsia($params->Usia);
                $entries->setJabatan($params->Jabatan);
                $entries->setTingkatPendidikan($params->TingkatPendidikan);
                $entries->setTelepon($params->Telepon);
                $entries->setNIP($params->Nip);

                if ($params->Foto) {
                    $profile_image;
                    $profile_image_params = new stdClass;
                    if (isset($params->Foto['tmp_name'])) {
                        $profile_image = $params->Foto;
                    } else {
                        $profile_image = [];
                        $profile_image['Data'] = $params->Foto;
                        $profile_image['Name'] = microtime(true) .'.jpg';
                        $profile_image_params->Type = 'base64';
                    }
                    $profile_image_params->Path = '/profil/';
                    $profile_image_params->Image = $profile_image;
                    $asset = Website_Helper::uploadFileToAsset($profile_image_params);
                    if ($asset) {
                        $entries->setFotoProfil($asset);
                    }
                }

                if($params->TanggalLahir){
                    $dob = new Zend_Date();
                    $temp = explode("/", $params->TanggalLahir);
                    $params->TanggalLahir = $temp[1]."/".$temp[0]."/".$temp[2]; 
                    $dob->setTimestamp(strtotime($params->TanggalLahir));
                    $entries->setTanggalLahir($dob);
                }

                //for account
                $entries->setUsername($params->Username);
                
                $chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
                $password = substr(str_shuffle( $chars ), 0, 6);                 
                $entries->setPassword($password);

                $entries->setIndex(0);
                $entries->setPublished(1);

                $unitOrganisasi = Object\UnitOrganisasi::getById($params->IdUnitOrganisasi);                                
                if($unitOrganisasi){                
                    $entries->setUnitOrganisasi($unitOrganisasi);
                    $entries->setStatus(1);
                    $entries->setKey(\Pimcore\File::getValidFilename($params->Nama."-".microtime(true)));

                    $getPath = Object_Abstract::getByPath("/sabos/organisasi/".$unitOrganisasi->Organisasi->o_key."/".$unitOrganisasi->o_key);
                    $entries->setParentId($getPath->o_id);

                    // send email
                    $params = new stdClass;
                    $params->Activity = "Tambah peserta Sabos";
                    $params->To = $entries->Email;
                    $params->Params = array(
                            'Username' => $entries->Username,
                            'Nama' => $entries->Nama,
                            'Password' => $password,
                            'LinkLogin' => Website_Helper::getSiteUrl() . 'sabos/login'
                        );
                    $params->Template = '/template-email/sabos/success_registration_independent';
                    $objectMail = Object_EmailBucketManager::add($params);                    

                } else {
                    $entries->setUsername($entries->Email);
                    $entries->setStatus(0);
                    $entries->setKey(\Pimcore\File::getValidFilename($params->Nama."-".microtime(true)));

                    $getPath = Object_Abstract::getByPath("/sabos/peserta-independent");
                    $entries->setParentId($getPath->o_id); 

                    // send email
                    $params = new stdClass;
                    $params->Activity = "Register peserta independent Sabos";
                    $params->To = $entries->Email;
                    $params->Params = array(
                            'Nama' => $entries->Nama,
                            'LinkAktivasi' => Website_Helper::getSiteUrl() . 'sabos/activate?e='. Website_Helper::stringCompress($entries->Email)
                        );
                    $params->Template = '/template-email/sabos/success_registration_independent';
                    $objectMail = Object_EmailBucketManager::add($params);                    
                }
                
                if($entries->save()){
                    $return->Status = 1;
                    $return->Message = "Anda berhasil menambahkan peserta";
                    $entries->Password = $password;
                    $return->Data = $entries;
                }else{
                    $return->Message = "Anda gagal menambahkan peserta";
                }
            }

        } catch (Exception $e) {
            $return->Message = "Maaf terjadi kesalahan pada koneksi anda";
            $return->Data = $e->getMessage();
        }

        return $return;

    }

    public static function update($params = null) {

    	$return = new stdClass;
		$return->Status = 0;
		$return->Message = '';
		$return->Data = NULL;

        if(!$params->Id){
            $return->Message = "Id peserta tidak boleh kosong";
            return $return;
        }

        try {

            $peserta = Object\Peserta::getById($params->Id);

            if($params->Nama) 
                $peserta->Nama = $params->Nama;
            if($params->Email) 
                $peserta->Email = $params->Email;
            if($params->JenisKelamin) 
                $peserta->JenisKelamin = $params->JenisKelamin;
            if($params->Usia) 
                $peserta->Usia = $params->Usia;
            if($params->Jabatan) 
                $peserta->Jabatan = $params->Jabatan;
            if($params->TingkatPendidikan) 
                $peserta->TingkatPendidikan = $params->TingkatPendidikan;
            if($params->Telepon) 
                $peserta->Telepon = $params->Telepon;
            if($params->Kota) 
                $peserta->Kota = $params->Kota;
            if($params->Provinsi) 
                $peserta->Provinsi = $params->Provinsi;    
            if($params->Nip) 
                $peserta->NIP = $params->Nip;   
            if($params->TanggalLahir){
                $dob = new Zend_Date();
                $temp = explode("/", $params->TanggalLahir);
                $params->TanggalLahir = $temp[1]."/".$temp[0]."/".$temp[2]; 
                $dob->setTimestamp(strtotime($params->TanggalLahir));
                $peserta->TanggalLahir = $dob;
            } 

            if ($params->Foto) {
                $profile_image;
                $profile_image_params = new stdClass;
                if (isset($params->Foto['tmp_name'])) {
                    $profile_image = $params->Foto;
                } else {
                    $profile_image = [];
                    $profile_image['Data'] = $params->Foto;
                    $profile_image['Name'] = microtime(true) .'.jpg';
                    $profile_image_params->Type = 'base64';
                }
                $profile_image_params->Path = '/profil/';
                $profile_image_params->Image = $profile_image;
                $asset = Website_Helper::uploadFileToAsset($profile_image_params);

                if ($asset) {
                    if ($peserta->FotoProfil) {
                        $peserta->FotoProfil->delete();
                    }
                    $peserta->FotoProfil = $asset;
                }
            }      
             
            //for account
            if($params->Username) 
                $peserta->Username = $params->Username;
            if($params->Reset){
                $chars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
                $password = substr(str_shuffle( $chars ), 0, 6);                 
                $peserta->Password = $password;
            } 
                

            if ($params->IdUnitOrganisasi) {
                $unitOrganisasi = Object\UnitOrganisasi::getById($params->IdUnitOrganisasi);
                $peserta->UnitOrganisasi = $unitOrganisasi;
            } 

            if($peserta->save()){
                $return->Status = 1;
                $peserta->Password = $password;
                $return->Data = $peserta;
            }else{
                $return->Message = "Anda gagal memperbaharui peserta";
            }

        } catch (Exception $e) {
            $return->Message = $e->getMessage();
        }
    		
		return $return;

    }

    public static function delete($params = null){

        $return = new stdClass;
        $return->Status = 0;
        $return->Message = '';
        $return->Data = NULL;

        if($params->Id){
            $params->Message = "Id Unit Organisasi tidak boleh kosong";
        }

        $object = Object\Peserta::getById($params->Id);
        if(!$object){
            $return->Message = "Unit Organisasi tidak ada";
            return $return;
        }
        $object->delete();
        $return->Status = 1;

        return $return;
    }

    public static function getById($params = null){

    	$return = new stdClass;
        $return->Status = 0;
        $return->Message = '';
        $return->Data = NULL;

        if(!$params->Id){
            $return->Message = 'Id peserta kosong';
            return $return;
        }

        try{
            $object = Object\Peserta::getById($params->Id);
            if(!$object){
                $return->Message = 'peserta tidak bisa ditemukan';
                return $return;
            }
            
            $return->Data = $object;
            $return->Status = 1;
        }

        catch(Exception $e){
            $return->Message = 'Periksa lagi data yang dimasukkan';
            $return->Data = $e;
        }
        return $return;

    }

    public static function getByEmail($params = null){

        $return = new stdClass;
        $return->Status = 0;
        $return->Message = '';
        $return->Data = NULL;

        try{
            $objects = new Object\Peserta\Listing();
            $objects->setCondition("Email = ? ", [$params->Email]);
            $objects = $objects->load();
            if(!$objects){
                $return->Message = 'peserta tidak ditemukan';
                return $return;
            }

            $return->Data = $objects[0];
            $return->Status = 1;
        }

        catch(Exception $e){
            $return->Message = 'Periksa lagi data yang dimasukkan';
            $return->Data = $e;
        }
        return $return;

    }

    public static function getByUsername($params = null) {

        $return = new stdClass;
        $return->Status = 0;
        $return->Message = '';
        $return->Data = NULL;

        try{
            $objects = new Object\Peserta\Listing();
            $objects->setCondition("Username = ? ", [$params->Username]);
            $objects = $objects->load();
            if(!$objects){
                $return->Message = 'peserta tidak ditemukan';
                return $return;
            }

            $return->Data = $objects[0];
            $return->Status = 1;
        }

        catch(Exception $e){
            $return->Message = 'Periksa lagi data yang dimasukkan';
            $return->Data = $e;
        }
        return $return;

    }

    public static function getByUnitOrganisasi($params = null) {

        $return = new stdClass;
        $return->Status = 0;
        $return->Message = '';
        $return->Data = NULL;

        $id_peserta = Website_Helper::getIdByClassName('Peserta');
        $id_unit_organisasi = Website_Helper::getIdByClassName('UnitOrganisasi');
        $id_organisasi = Website_Helper::getIdByClassName('Organisasi');

        $condition = $params->IdUnitOrganisasi ? "Where u_og.o_id = ".$params->IdUnitOrganisasi : "";
        
        if($params->Search){
            $condition .=  $condition ? " AND (p.Nama LIKE '%".$params->Search."%' OR p.Jabatan LIKE '%".$params->Search."%')" : "Where (Og.Nama LIKE '%".$params->Search."%' OR Og.Nama LIKE '%".$params->Search."%' OR p.Nama LIKE '%".$params->Search."%' OR u_og.Nama LIKE '%".$params->Search."%' OR p.Jabatan LIKE '%".$params->Search."%')";
        }

        $query = "  SELECT 
                        p.o_id as 'o_id',
                        p.Nama as 'Nama',
                        p.Email as 'Email',
                        p.Telepon as 'Telepon',
                        p.JenisKelamin as 'JenisKelamin',
                        p.TingkatPendidikan as 'TingkatPendidikan',
                        p.TanggalLahir as 'TanggalLahir',
                        p.Provinsi as 'Provinsi',
                        p.Kota as 'Kota',
                        p.NIP as 'NIP',
                        p.Username as 'Username',
                        p.Jabatan as 'Jabatan',
                        u_og.Nama as 'UnitKerja',
                        og.Nama as 'Organisasi',
                        u_og.Organisasi__id as 'IdOrganisasi',
                        CONCAT(assets.path,assets.filename) as 'FotoProfil'

                    FROM object_".$id_peserta." as p
                    INNER JOIN object_".$id_unit_organisasi." as u_og ON u_og.o_id = p.UnitOrganisasi__id 
                    INNER JOIN object_".$id_organisasi." as og ON og.o_id = u_og.Organisasi__id 
                    LEFT JOIN assets ON assets.id = p.FotoProfil " . $condition ;

        $objects = Website_Helper::makeQuery($query);

        $return->Status = 1;
        $return->Data = $objects;

        return $return;

    }

    public static function checkUserPass($params = null){

        $return = new stdClass;
        $return->Status = 0;
        $return->Message = '';
        $return->Data = NULL;

        try{
            $objects = new Object\Peserta\Listing();
            $objects->setCondition("Username = ? AND Password = ?", [$params->Username , md5($params->Password)]);
            $objects = $objects->load();
            if(!$objects){
                $return->Message = 'peserta tidak ditemukan';
                return $return;
            }

            $return->Data = $objects;
            $return->Status = 1;
        }

        catch(Exception $e){
            $return->Message = 'Periksa lagi data yang dimasukkan';
            $return->Data = $e;
        }
        return $return;

    }

    /**
     * Manager ini untuk mendapatkan peserta berdasarkan id organisasi dan juga bisa menggunakan id peserta yang terdiri dari 
     * Id, Nama, Email, Logo, Total Unit Organisasi dan Total Peserta 
     * parameter yang dapat digunakan adalah id organisasi yang nantinya dipakai pada detail organisasi
     *  
     * @param  stdClass $params 
     * @return stdClass [description]
     */
    public static function getDetailByOrganisasi($params = null)
    {
        $return = new stdClass;
        $return->Status = 0;
        $return->Message = '';
        $return->Data = NULL;

        $id_peserta = Website_Helper::getIdByClassName('Peserta');
        $id_unit_organisasi = Website_Helper::getIdByClassName('UnitOrganisasi');
        $id_organisasi = Website_Helper::getIdByClassName('Organisasi');

        $condition = $params->IdOrganisasi ? "Where og.o_id = ".$params->IdOrganisasi : "";

        if($params->Search){
            $condition .=  $condition ? " AND (Og.Nama LIKE '%".$params->Search."%' OR Og.Nama LIKE '%".$params->Search."%' OR p.Nama LIKE '%".$params->Search."%' OR u_og.Nama LIKE '%".$params->Search."%' OR p.Jabatan LIKE '%".$params->Search."%')" : "Where (Og.Nama LIKE '%".$params->Search."%' OR Og.Nama LIKE '%".$params->Search."%' OR p.Nama LIKE '%".$params->Search."%' OR u_og.Nama LIKE '%".$params->Search."%' OR p.Jabatan LIKE '%".$params->Search."%')";
        }

        if($params->IdPeserta){
            $condition .= $condition ? " AND p.o_id = ".$params->IdPeserta : "Where p.o_id = ".$params->IdPeserta ; 
        }
        $query = "  SELECT 
                        p.o_id as 'o_id',
                        p.Nama as 'Nama',
                        CONCAT(assets.path,assets.filename) as 'FotoProfil',
                        p.Jabatan as 'Jabatan',
                        p.JenisKelamin as 'JenisKelamin',
                        p.Email as 'Email',
                        p.Telepon as 'Telepon',
                        p.TanggalLahir as 'TanggalLahir',
                        p.TingkatPendidikan as 'TingkatPendidikan',
                        p.NIP as 'NIP',
                        u_og.Nama as 'UnitOrganisasi',
                        og.Nama as 'Organisasi'

                    FROM object_".$id_peserta." as p
                    INNER JOIN object_".$id_unit_organisasi." as u_og ON u_og.o_id = p.UnitOrganisasi__id 
                    LEFT JOIN object_".$id_organisasi." as og ON og.o_id = u_og.Organisasi__id 
                    LEFT JOIN assets ON assets.id = p.FotoProfil " . $condition ;

        $objects = Website_Helper::makeQuery($query);

        $return->Status = 1;
        $return->Data = $objects;

        return $return;
    }

    /**
     * Manager ini untuk mendapatkan peserta independent.  
     * Id, Nama, Email, Photo
     *  
     * @param  stdClass $params 
     * @return stdClass [description]
     */
    public static function getIndependent($params = null)
    {
        $return = new stdClass;
        $return->Status = 0;
        $return->Message = '';
        $return->Data = NULL;

        $id_peserta = Website_Helper::getIdByClassName('Peserta');
        $id_unit_organisasi = Website_Helper::getIdByClassName('UnitOrganisasi');
        $id_organisasi = Website_Helper::getIdByClassName('Organisasi');

        $condition = "Where u_og.o_id IS NULL";

        if($params->Search){
            $condition .=  $condition ? " AND (p.Nama LIKE '%".$params->Search."%' OR p.Email LIKE '%".$params->Search."%' OR p.Provinsi LIKE '%".$params->Search."%' OR p.Kota LIKE '%".$params->Search."%')" : "Where (p.Nama LIKE '%".$params->Search."%' OR p.Email LIKE '%".$params->Search."%' OR p.Provinsi LIKE '%".$params->Search."%' OR p.Kota LIKE '%".$params->Search."%')";
        }


        if($params->IdPeserta){
            $condition .= $condition ? " AND p.o_id = ".$params->IdPeserta : "Where p.o_id = ".$params->IdPeserta ; 
        }

        $query = "  SELECT 
                        p.o_id as 'o_id',
                        p.Nama as 'Nama',
                        CONCAT(assets.path,assets.filename) as 'FotoProfil',
                        p.Jabatan as 'Jabatan',
                        p.JenisKelamin as 'JenisKelamin',
                        p.Email as 'Email',
                        p.Telepon as 'Telepon',
                        p.TanggalLahir as 'TanggalLahir',
                        p.TingkatPendidikan as 'TingkatPendidikan',
                        p.NIP as 'NIP',
                        p.Provinsi as 'Provinsi',
                        p.Kota as 'Kota'
                        
                    FROM object_".$id_peserta." as p
                    LEFT JOIN object_".$id_unit_organisasi." as u_og ON u_og.o_id = p.UnitOrganisasi__id 
                    LEFT JOIN object_".$id_organisasi." as og ON og.o_id = u_og.Organisasi__id 
                    LEFT JOIN assets ON assets.id = p.FotoProfil " . $condition ;

        $objects = Website_Helper::makeQuery($query);

        $return->Status = 1;
        $return->Data = $objects;

        return $return;
    }
               
}
