<?php

class Object_RvsManager { 

    public static function create($params = null) {

        $return = new stdClass;
        $return->Status = 0;
        $return->Message = '';
        $return->Data = NULL;

        $peserta = Object\Peserta::getById($params->IdPeserta);

        //create folder RVS each peserta
        $path = $peserta->o_path.$peserta->o_key;
        $folderKey = \Pimcore\File::getValidFilename("rvs"); // Name of the folder
        $folderPath = $path . "/" . $folderKey;

        if (!Object\Service::pathExists($folderPath)) {
            $parentId = Object_Abstract::getByPath($path)->o_id;

            $folder = Object\Folder::create(
                array(
                  "o_parentId" => $parentId,
                  "o_creationDate" => time(),
                  "o_userOwner" => 1,
                  "o_userModification" => 1,
                  "o_key" => $folderKey,
                  "o_published" => true
                )
            );

            $folder->setCreationDate(time());
            $folder->setUserOwner(1);
            $folder->setUserModification(1);

            try {
                $folder->save();
                $path = $folderPath;
            } catch (\Exception $e) {
                $return->Message = $e->getMessage();
                return $return;
            }     
        }

        $objectKey = \Pimcore\File::getValidFilename($params->Kategori . "-" . $params->Nilai);        

        $entries = Object_Abstract::getByPath($folderPath . "/" . $objectKey);
        if(!$entries){        
            $entries = new Object\Rvs();
            $entries->setParentId( Object_Abstract::getByPath($folderPath)->o_id );
            $entries->setKey($objectKey);
            $entries->setIndex(0);
            $entries->setPublished(1);        
        }

        $entries->setNama($params->Nama);
        $entries->setPernyataan($params->Pernyataan);
        $entries->setKategori($params->Kategori);
        $entries->setNilai($params->Nilai);
        
        $entries->setPeserta($peserta);

        if($entries->save()){
            $return->Status = 1;
            $return->Message = "Anda berhasil menambahkan RVS";
            $return->Data = $entries;
        }else{
            $return->Message = "Anda gagal menambahkan RVS";
        }

        return $return;

    }
    
    public static function getById($params = null){

        $return = new stdClass;
        $return->Status = 0;
        $return->Message = '';
        $return->Data = NULL;

        if(!$params->Id){
            $return->Message = 'Id RVS kosong';
            return $return;
        }

        try{
            $object = Object\Rvs::getById($params->Id);
            if(!$object){
                $return->Message = 'RVS tidak ditemukan';
                return $return;
            }
            
            $return->Data = $object;
            $return->Status = 1;
        }

        catch(Exception $e){
            $return->Message = 'Periksa lagi data yang dimasukkan';
            $return->Data = $e;
        }
        return $return;

    }

    public static function getByPeserta($params = null){

        $return = new stdClass;
        $return->Status = 0;
        $return->Message = '';
        $return->Data = NULL;

        if(!$params->IdPeserta){
            $return->Message = 'Id peserta kosong';
            return $return;
        }

        try{
            $objects = new Object\Rvs\Listing();
            $objects->setCondition("Peserta__id = ?", [$params->IdPeserta]);
            $objects = $objects->load();

            if(!$objects){
                $return->Message = 'RVS tidak ditemukan';
                return $return;
            }
            
            $return->Data = $objects;
            $return->Status = 1;
        }

        catch(Exception $e){
            $return->Message = 'Periksa lagi data yang dimasukkan';
            $return->Data = $e;
        }

        return $return;
    }

    public static function getAverage($params = null){

        $return = new stdClass;
        $return->Status = 0;
        $return->Message = '';
        $return->Data = NULL;

        $dataRvs = array();
        
        $db = Pimcore_Resource_Mysql::get();
        $idClass = Website_Helper::getIdByClassName('Rvs');

        // PERHITUNGAN NILAI RVS KATEGORI TERMINAL TERTINGGI DAN TERENDAH
        $query = "SELECT Nama, Pernyataan, AVG(Nilai) as 'Nilai Rata-rata' FROM  object_".$idClass." WHERE Kategori = 'terminal' GROUP BY Nama ORDER BY AVG(Nilai) ASC LIMIT 7";
        
        $dataTerminalMax = $db->fetchAll($query);
        if($dataTerminalMax){
            $dataRvs['terminal']['tertinggi'] = $dataTerminalMax;
        }

        $query = "SELECT Nama, Pernyataan, AVG(Nilai) as 'Nilai Rata-rata' FROM  object_".$idClass." WHERE Kategori = 'terminal' GROUP BY Nama ORDER BY AVG(Nilai) DESC LIMIT 7";
        
        $dataTerminalMin = $db->fetchAll($query);
        if($dataTerminalMin){
            $dataRvs['terminal']['terendah'] = $dataTerminalMin;
        }
        //END

        //QUERY PERHITUNGAN NILAI RVS KATEGORI INSTRUMENTAL TERTINGGI DAN TERENDAH
        $query = "SELECT Nama, Pernyataan, AVG(Nilai) as 'Nilai Rata-rata' FROM  object_".$idClass." WHERE Kategori = 'instrumental' GROUP BY Nama ORDER BY AVG(Nilai) ASC LIMIT 7";
        
        $dataInstrumentalMax = $db->fetchAll($query);
        if($dataInstrumentalMax){
            $dataRvs['instrumental']['tertinggi'] = $dataInstrumentalMax;   
        }

        $query = "SELECT Nama, Pernyataan, AVG(Nilai) as 'Nilai Rata-rata' FROM  object_".$idClass." WHERE Kategori = 'instrumental' GROUP BY Nama ORDER BY AVG(Nilai) DESC LIMIT 7";
        
        $dataInstrumentalMin = $db->fetchAll($query);
        if($dataInstrumentalMin){
            $dataRvs['instrumental']['terendah'] = $dataInstrumentalMin;   
        }

        //END

        if($dataRvs){
            $return->Status = 1;
            $return->Data = (object) $dataRvs;
        }
        return $return; 
    }
               
}
