<?php

class Object_SummaryManager { 

    public static function getSummary($params = null){

        $return = new stdClass;
        $return->Status = 0;
        $return->Message = '';
        $return->Data = NULL;

        if(!$params->IdOrganisasi && !$params->IdUnitOrganisasi && !$params->IdPeserta){
            $return->Message = 'Id peserta atau Id Unit Organisasi atau Id Organisasi kosong';
            return $return;
        }

        try{

            $summary['rvs'] = self::getRvs($params);
            $summary['ocai'] = self::getOcai($params);
            $summary['msai'] = self::getMsai($params);

            if($summary){
                $return->Status = 1;
                $return->Data = $summary;
            }
        }

        catch(Exception $e){
            $return->Message = 'Periksa lagi data yang dimasukkan';
            $return->Data = $e;
        }

        return $return;

    }

    public static function getRvs($params = null) {

        $db = Pimcore_Resource_Mysql::get();

        $idClass_organisasi = Website_Helper::getIdByClassName('Organisasi');
        $idClass_unit_organisasi = Website_Helper::getIdByClassName('UnitOrganisasi');
        $idClass_peserta = Website_Helper::getIdByClassName('Peserta');
        $idClass_rvs = Website_Helper::getIdByClassName('Rvs');

        $summary = [];

        $join = "object_".$idClass_organisasi." as og
                        INNER JOIN object_".$idClass_unit_organisasi." as uog ON uog.Organisasi__id = og.o_id
                        INNER JOIN object_".$idClass_peserta." as p ON p.UnitOrganisasi__id = uog.o_id"; 

        if($params->IdOrganisasi){
            $condition = "og.o_id = '".$params->IdOrganisasi."' AND"; 
        }
        if($params->IdUnitOrganisasi){
            $condition = "uog.o_id = '".$params->IdUnitOrganisasi."' AND"; 
        }
        if($params->IdPeserta){
            $condition = "p.o_id = '".$params->IdPeserta."' AND";

            $object = Object\Peserta::getById($params->IdPeserta);
            if(!$object->UnitOrganisasi){
                $join = "object_".$idClass_peserta." as p";    
            } 
        }
        
        try {
                
            $query = "SELECT 
                        rvs.Nama as 'kode',
                        ROUND(AVG(rvs.Nilai),2) as 'nilai',
                        rvs.Pernyataan as 'descripsi'
                    fROM ".$join." INNER JOIN object_".$idClass_rvs." as rvs ON rvs.Peserta__id = p.o_id
                    WHERE ".$condition;

            $category = " Kategori = 'terminal' GROUP BY rvs.Nama ORDER BY AVG(rvs.Nilai) ASC";
            $summary['terminal'] = $db->fetchAll($query.$category);

            $category = " Kategori = 'instrumental' GROUP BY rvs.Nama ORDER BY AVG(rvs.Nilai) ASC";
            $summary['instrument'] = $db->fetchAll($query.$category);

            if(!$summary['terminal']){
                $summary = [];                
            }

        } catch (Exception $e) {
            return $e->getMessage();
        }
        
        return $summary;

    }

    public static function getOcai($params = null){

        $db = Pimcore_Resource_Mysql::get();
        
        $idClass_organisasi = Website_Helper::getIdByClassName('Organisasi');
        $idClass_unit_organisasi = Website_Helper::getIdByClassName('UnitOrganisasi');
        $idClass_peserta = Website_Helper::getIdByClassName('Peserta');
        $idClass_ocai = Website_Helper::getIdByClassName('Ocai');
        
        $summary = [];

        $join = "object_".$idClass_organisasi." as og
                        INNER JOIN object_".$idClass_unit_organisasi." as uog ON uog.Organisasi__id = og.o_id
                        INNER JOIN object_".$idClass_peserta." as p ON p.UnitOrganisasi__id = uog.o_id"; 

        if($params->IdOrganisasi){
            $condition = "og.o_id = '".$params->IdOrganisasi."' AND"; 
        }
        if($params->IdUnitOrganisasi){
            $condition = "uog.o_id = '".$params->IdUnitOrganisasi."' AND"; 
        }
        if($params->IdPeserta){

            $condition = "p.o_id = '".$params->IdPeserta."' AND";

            $object = Object\Peserta::getById($params->IdPeserta);
            if(!$object->UnitOrganisasi){
                $join = "object_".$idClass_peserta." as p";                      
            }  
        }

        try {

            $query = "SELECT
                            t.Tipe as 'topologi',
                            ROUND(AVG(t.Uksi),2) as 'si',
                            ROUND(AVG(t.Ukdi),2) as 'di',
                            ROUND(AVG(t.KlhSi),2) as 'klh_si',
                            ROUND(AVG(t.KlhDi),2) as 'klh_di',
                            ROUND(AVG(t.Uksi),2) - ROUND(AVG(t.Ukdi),2) as 'selisih_si_di',
                            ROUND(AVG(t.KlhSi),2) - ROUND(AVG(t.KlhDi),2) as 'selisih_klhsi_klhdi'
                        FROM 
                            (select 
                            ocai.Kategori, 
                            ocai.Tipe, 
                            ocai.Uksi, 
                            ocai.Ukdi, 
                            ocai.KlhSi, 
                            ocai.KlhDi
                            from ".$join." INNER JOIN object_".$idClass_ocai." as ocai ON ocai.Peserta__id = p.o_id

                            WHERE ".$condition;

            $tipe_a = " ocai.Tipe = 'A') as t GROUP BY t.Tipe";
            $tipe_b = " ocai.Tipe = 'B') as t GROUP BY t.Tipe";
            $tipe_c = " ocai.Tipe = 'C') as t GROUP BY t.Tipe";
            $tipe_d = " ocai.Tipe = 'D') as t GROUP BY t.Tipe";

            $query = "(".$query.$tipe_a. " UNION ALL ".$query.$tipe_b. " UNION ALL ".$query.$tipe_c. " UNION ALL ".$query.$tipe_d.") as new_t" ;

            $query = "SELECT
                        CASE new_t.topologi 
                            WHEN 'A' THEN 'CLAN' 
                            WHEN 'B' THEN 'ADHOCRACY'
                            WHEN 'C' THEN 'MARKET'
                            ELSE 'HIERARCHY' 
                        END AS 'topologi',
                        new_t.si,
                        new_t.di,
                        new_t.klh_si,
                        new_t.klh_di,
                        new_t.selisih_si_di,
                        new_t.selisih_klhsi_klhdi
                    FROM ".$query;  

            $summary = $db->fetchAll($query);

        } catch (Exception $e) {
            return $e->getMessage();
        }

        return $summary;

    }

    public static function getMsai($params = null){


        $db = Pimcore_Resource_Mysql::get();

        $idClass_organisasi = Website_Helper::getIdByClassName('Organisasi');
        $idClass_unit_organisasi = Website_Helper::getIdByClassName('UnitOrganisasi');
        $idClass_peserta = Website_Helper::getIdByClassName('Peserta');
        $idClass_msai = Website_Helper::getIdByClassName('Msai');

        $summary = [];

        $join = "object_".$idClass_organisasi." as og
                        INNER JOIN object_".$idClass_unit_organisasi." as uog ON uog.Organisasi__id = og.o_id
                        INNER JOIN object_".$idClass_peserta." as p ON p.UnitOrganisasi__id = uog.o_id";

        if($params->IdOrganisasi){
            $condition = "og.o_id = '".$params->IdOrganisasi."' AND "; 
        }
        if($params->IdUnitOrganisasi){
            $condition = "uog.o_id = '".$params->IdUnitOrganisasi."' AND "; 
        }
        if($params->IdPeserta){

            $condition = "p.o_id = '".$params->IdPeserta."' AND "; 

            if(!$object->UnitOrganisasi){
                $join = "object_".$idClass_peserta." as p";    
            }  
        }

        try {

            // pernyataan yang tidak masuk hitungan 2,3,7,50,73,74,75,79,80,85

            $mte = '(msai.Nama = "pernyataan-18" OR msai.Nama = "pernyataan-12" OR msai.Nama = "pernyataan-21" OR msai.Nama = "pernyataan-22" OR msai.Nama = "pernyataan-49" OR msai.Nama = "pernyataan-61" OR msai.Nama = "pernyataan-76" ) GROUP BY p.o_id) as mte';
            $mir = '(msai.Nama = "pernyataan-1" OR msai.Nama = "pernyataan-13" OR msai.Nama = "pernyataan-23" OR msai.Nama = "pernyataan-48" OR msai.Nama = "pernyataan-62" OR msai.Nama = "pernyataan-77") GROUP BY p.o_id) as mir';
            $mdo = '(msai.Nama = "pernyataan-5" OR msai.Nama = "pernyataan-20" OR msai.Nama = "pernyataan-24" OR msai.Nama = "pernyataan-25" OR msai.Nama = "pernyataan-47" OR msai.Nama = "pernyataan-63" OR msai.Nama = "pernyataan-78") GROUP BY p.o_id) as mdo';
            $min = '(msai.Nama = "pernyataan-8" OR msai.Nama = "pernyataan-9" OR msai.Nama = "pernyataan-26" OR msai.Nama = "pernyataan-51" OR msai.Nama = "pernyataan-64") GROUP BY p.o_id) as min';
            $mfu = '(msai.Nama = "pernyataan-14" OR msai.Nama = "pernyataan-27" OR msai.Nama = "pernyataan-28" OR msai.Nama = "pernyataan-45" OR msai.Nama = "pernyataan-46" OR msai.Nama = "pernyataan-65") GROUP BY p.o_id) as mfu';
            $mci = '(msai.Nama = "pernyataan-29" OR msai.Nama = "pernyataan-44" OR msai.Nama = "pernyataan-52" OR msai.Nama = "pernyataan-53" OR msai.Nama = "pernyataan-59" OR msai.Nama = "pernyataan-66" OR msai.Nama = "pernyataan-81") GROUP BY p.o_id) as mci';
            $mco = '(msai.Nama = "pernyataan-15" OR msai.Nama = "pernyataan-30" OR msai.Nama = "pernyataan-35" OR msai.Nama = "pernyataan-43" OR msai.Nama = "pernyataan-60" OR msai.Nama = "pernyataan-67" OR msai.Nama = "pernyataan-82") GROUP BY p.o_id) as mco';
            $eem = '(msai.Nama = "pernyataan-6" OR msai.Nama = "pernyataan-31" OR msai.Nama = "pernyataan-42" OR msai.Nama = "pernyataan-68" OR msai.Nama = "pernyataan-83") GROUP BY p.o_id) as eem';
            $mcs = '(msai.Nama = "pernyataan-32" OR msai.Nama = "pernyataan-33" OR msai.Nama = "pernyataan-41" OR msai.Nama = "pernyataan-54" OR msai.Nama = "pernyataan-55" OR msai.Nama = "pernyataan-69" OR msai.Nama = "pernyataan-84") GROUP BY p.o_id) as mcs';
            $mac = '(msai.Nama = "pernyataan-10" OR msai.Nama = "pernyataan-11" OR msai.Nama = "pernyataan-34" OR msai.Nama = "pernyataan-40" OR msai.Nama = "pernyataan-56" OR msai.Nama = "pernyataan-70") GROUP BY p.o_id) as mac';
            $mcy = '(msai.Nama = "pernyataan-4" OR msai.Nama = "pernyataan-16" OR msai.Nama = "pernyataan-19" OR msai.Nama = "pernyataan-36" OR msai.Nama = "pernyataan-39" OR msai.Nama = "pernyataan-71" OR msai.Nama = "pernyataan-86") GROUP BY p.o_id) as mcy';
            $mcr = '(msai.Nama = "pernyataan-17" OR msai.Nama = "pernyataan-37" OR msai.Nama = "pernyataan-38" OR msai.Nama = "pernyataan-57" OR msai.Nama = "pernyataan-58" OR msai.Nama = "pernyataan-72" OR msai.Nama = "pernyataan-87") GROUP BY p.o_id) as mcr';

            $query_part = "(SELECT p.o_id as 'id', SUM(Nilai) as 'Nilai'
                            FROM ".$join." INNER JOIN object_".$idClass_msai." as msai ON msai.Peserta__id = p.o_id ";

            $select = "SELECT 
                        SUM(mte.Nilai) as 'MTE', 
                        SUM(mir.Nilai) as 'MIR',
                        SUM(mdo.Nilai) as 'MDO',
                        SUM(min.Nilai) as 'MIN',
                        SUM(mfu.Nilai) as 'MFU', 
                        SUM(mci.Nilai) as 'MCI',
                        SUM(mco.Nilai) as 'MCO', 
                        SUM(eem.Nilai) as 'EEM',
                        SUM(mcs.Nilai) as 'MCS',
                        SUM(mac.Nilai) as 'MAC',
                        SUM(mcy.Nilai) as 'MCY',
                        SUM(mcr.Nilai) as 'MCR',
                        COUNT(DISTINCT mte.Nilai) as 'jumlah_peserta' ";

            $query_body =  $query_part. " WHERE ".$condition.$mte;
            $query_body .=  " INNER JOIN ".$query_part." WHERE ".$condition.$mir." ON mte.id = mir.id";
            $query_body .=  " INNER JOIN ".$query_part." WHERE ".$condition.$mdo." ON mir.id = mdo.id";
            $query_body .=  " INNER JOIN ".$query_part." WHERE ".$condition.$min." ON mdo.id = min.id";
            $query_body .=  " INNER JOIN ".$query_part." WHERE ".$condition.$mfu." ON min.id = mfu.id";
            $query_body .=  " INNER JOIN ".$query_part." WHERE ".$condition.$mci." ON mfu.id = mci.id";
            $query_body .=  " INNER JOIN ".$query_part." WHERE ".$condition.$mco." ON mci.id = mco.id";
            $query_body .=  " INNER JOIN ".$query_part." WHERE ".$condition.$eem." ON mco.id = eem.id";
            $query_body .=  " INNER JOIN ".$query_part." WHERE ".$condition.$mcs." ON eem.id = mcs.id";
            $query_body .=  " INNER JOIN ".$query_part." WHERE ".$condition.$mac." ON mcs.id = mac.id";
            $query_body .=  " INNER JOIN ".$query_part." WHERE ".$condition.$mcy." ON mac.id = mcy.id";
            $query_body .=  " INNER JOIN ".$query_part." WHERE ".$condition.$mcr." ON mcy.id = mcr.id";

            $query = $select." FROM ".$query_body; 

            $msai = $db->fetchAll($query);
            
            $clan=[]; 
            $adhocracy=[]; 
            $market=[]; 
            $hierarchy=[];
            //deskripsi
            $clan_deskripsi = []; 
            $adhocracy_deskripsi = []; 
            $market_deskripsi = []; 
            $hierarchy_deskripsi = [];
            //total
            $clan_total=0; 
            $adhocracy_total=0; 
            $market_total=0; 
            $hierarchy_total=0;

            if(count($msai)){
                if($msai[0][jumlah_peserta] > 0){
                    foreach ($msai[0] as $key => $value) {
                        //CLAN      
                        if($key == "MTE"){
                            $deskripsi = array($key, "Managing Team", $value/$msai[0]['jumlah_peserta']);
                            array_push($clan_deskripsi, $deskripsi);
                            $clan_total += $value/$msai[0]['jumlah_peserta'];
                        }elseif($key == "MIR"){
                            $deskripsi = array($key, "Managing Interpersonal Relationship", $value/$msai[0]['jumlah_peserta']);
                            array_push($clan_deskripsi, $deskripsi);
                            $clan_total += $value/$msai[0]['jumlah_peserta'];
                        }elseif($key == "MDO"){
                            $deskripsi = array($key, "Managing the Development of the Other",$value/$msai[0]['jumlah_peserta']);
                            array_push($clan_deskripsi, $deskripsi);
                            $clan_total += $value/$msai[0]['jumlah_peserta'];
                        }
                        //ADHOCRACY
                        elseif($key == "MIN"){
                            $deskripsi = array($key, "Managing Innovation", $value/$msai[0]['jumlah_peserta']);
                            array_push($adhocracy_deskripsi, $deskripsi);
                            $adhocracy_total += $value/$msai[0]['jumlah_peserta'];
                        }elseif($key == "MFU"){
                            $deskripsi = array($key, "Managing the Future", $value/$msai[0]['jumlah_peserta']);
                            array_push($adhocracy_deskripsi, $deskripsi);
                            $adhocracy_total += $value/$msai[0]['jumlah_peserta'];
                        }elseif($key == "MCI"){
                            $deskripsi = array($key, "Managing Continuous Improvement",$value/$msai[0]['jumlah_peserta']);
                            array_push($adhocracy_deskripsi, $deskripsi);
                            $adhocracy_total += $value/$msai[0]['jumlah_peserta'];
                        }
                        //MARKET
                        elseif($key == "MCO"){
                            $deskripsi = array($key, "Managing Competitiveness", $value/$msai[0]['jumlah_peserta']);
                            array_push($market_deskripsi, $deskripsi);
                            $market_total += $value/$msai[0]['jumlah_peserta'];
                        }elseif($key == "EEM"){
                            $deskripsi = array($key, "Energizing Employee", $value/$msai[0]['jumlah_peserta']);
                            array_push($market_deskripsi, $deskripsi);
                            $market_total += $value/$msai[0]['jumlah_peserta'];
                        }elseif($key == "MCS"){
                            $deskripsi = array($key, "Managing Customer Service", $value/$msai[0]['jumlah_peserta']);
                            array_push($market_deskripsi, $deskripsi);
                            $market_total += $value/$msai[0]['jumlah_peserta'];
                        }
                        //HIERARCHY
                        elseif($key == "MAC"){
                            $deskripsi = array($key, "Managing Acculturation", $value/$msai[0]['jumlah_peserta']);
                            array_push($hierarchy_deskripsi, $deskripsi);
                            $hierarchy_total += $value/$msai[0]['jumlah_peserta'];
                        }elseif($key == "MCY"){
                            $deskripsi = array($key, "Managing the Control System", $value/$msai[0]['jumlah_peserta']);
                            array_push($hierarchy_deskripsi, $deskripsi);
                            $hierarchy_total += $value/$msai[0]['jumlah_peserta'];
                        }elseif($key == "MCR"){
                            $deskripsi = array($key, "Managing Coordination", $value/$msai[0]['jumlah_peserta']);
                            array_push($hierarchy_deskripsi, $deskripsi);
                            $hierarchy_total += $value/$msai[0]['jumlah_peserta'];
                        }
                    }
    
                    $clan = ['topologi'=>"CLAN", 'deskripsi'=>$clan_deskripsi, "total" =>$clan_total];
                    $adhocracy = ['topologi'=>"ADHOCRACY", 'deskripsi'=>$adhocracy_deskripsi, "total" =>$adhocracy_total];
                    $market = ['topologi'=>"MARKET", 'deskripsi'=>$market_deskripsi, "total" =>$market_total];
                    $hierarchy = ['topologi'=>"HIERARCHY", 'deskripsi'=>$hierarchy_deskripsi, "total" =>$hierarchy_total];
                    
                    $summary = array($clan,$adhocracy,$market,$hierarchy);
                }
            }

        } catch (Exception $e) {
            return $e->getMessage();
        }

        return $summary;

    }
               
}
