<?php

class Object_UnitOrganisasiManager { 

    public static function create($params = null) {

        $return = new stdClass;
        $return->Status = 0;
        $return->Message = '';
        $return->Data = NULL;

        $organisasi = Object\Organisasi::getById($params->IdOrganisasi);
        $getPath = Object_Abstract::getByPath("/sabos/organisasi/".$organisasi->o_key);

        $entries = new Object\UnitOrganisasi();
        $entries->setNama($params->Nama);
        $entries->setOrganisasi($organisasi);

        $entries->setKey(\Pimcore\File::getValidFilename($params->Nama."-".microtime(true)));
        $entries->setParentId($getPath->o_id);
        $entries->setIndex(0);
        $entries->setPublished(1);
        
        if($entries->save()){
            $return->Status = 1;
            $return->Message = "Anda berhasil menambahkan Unit Kerja";
            $return->Data = $entries;
        }else{
            $return->Message = "Anda gagal menambahkan Unit Kerja";
        }

        return $return;

    }
    
    public static function update($params = null) {

        $return = new stdClass;
        $return->Status = 0;
        $return->Message = '';
        $return->Data = NULL;

        if(!$params->Id){
            $return->Message = "Id unit organissasi tidak boleh kosong";
            return $return;
        }

        try {

            $object = Object_UnitOrganisasi::getById($params->Id);

            if($params->Nama) 
                $object->Nama = $params->Nama;

            if($params->IdOrganisasi) {
                $organisasi = Object\Organisasi::getById($params->IdOrganisasi);
                $object->Organisasi = $organisasi;
            } 

            if($object->save()){
                $return->Status = 1;
                $return->Data = $object;
            }else{
                $return->Message = "Anda gagal memperbaharui Unit Kerja";
            }

        } catch (Exception $e) {
            $return->Message = "Maaf terjadi kesalahan pada koneksi anda";
        }
            
        return $return;

    }

    public static function delete($params = null){

        $return = new stdClass;
        $return->Status = 0;
        $return->Message = '';
        $return->Data = NULL;

        if(!$params->Id){
            $params->Message = "Id Unit Organisasi tidak boleh kosong";
        }

        $object = Object\UnitOrganisasi::getById($params->Id);
        if(!$object){
            $return->Message = "Unit Kerja tidak ada";
            return $return;
        }

        $object->delete();
        $return->Status = 1;
        
        return $return;
    }

    public static function getById($params = null){

        $return = new stdClass;
        $return->Status = 0;
        $return->Message = '';
        $return->Data = NULL;

        if(!$params->Id){
            $return->Message = 'Id Unit Organisasi kosong';
            return $return;
        }

        try{
            $object = Object\UnitOrganisasi::getById($params->Id);
            if(!$object){
                $return->Message = 'Unit organisasi tidak ditemukan';
                return $return;
            }
            
            $return->Data = $object;
            $return->Status = 1;
        }

        catch(Exception $e){
            $return->Message = 'Periksa lagi data yang dimasukkan';
            $return->Data = $e;
        }
        return $return;

    }

    public static function getByOrganisasi($params = null) {

        $return = new stdClass;
        $return->Status = 0;
        $return->Message = '';
        $return->Data = NULL;

        if(!$params->IdOrganisasi){
            $return->Message = "Id Organisasi tidak ada";
            return $return;
        }
        try{
            $objects = new Object\UnitOrganisasi\Listing();
            $objects->setCondition("Organisasi__id = ? ", [$params->IdOrganisasi]);
            $objects = $objects->load();
            if(!$objects){
                $return->Message = 'Unit organisasi dengan organisasi ini tidak ditemukan';
                return $return;
            }

            $return->Data = $objects;
            $return->Status = 1;
        }

        catch(Exception $e){
            $return->Message = 'Periksa lagi data yang dimasukkan';
            $return->Data = $e;
        }
        return $return;

    }

    public static function getByName($params = null) {

        $return = new stdClass;
        $return->Status = 0;
        $return->Message = '';
        $return->Data = NULL;

        try{
            $objects = new Object\UnitOrganisasi\Listing();
            $objects->setCondition("Nama LIKE '%".$params->Nama."%'");
            $objects = $objects->load();
            if(!$objects){
                $return->Message = 'Unit organisasi dengan nama ini tidak ditemukan';
                return $return;
            }

            $return->Data = $objects;
            $return->Status = 1;
        }

        catch(Exception $e){
            $return->Message = 'Periksa lagi data yang dimasukkan';
            $return->Data = $e;
        }
        return $return;

    }

    public static function getDetail($params = null)
    {
        $return = new stdClass;
        $return->Status = 0;
        $return->Message = '';
        $return->Data = NULL;

        $id_peserta = Website_Helper::getIdByClassName('Peserta');
        $id_unit_organisasi = Website_Helper::getIdByClassName('UnitOrganisasi');

        $condition = $params->IdUnitOrganisasi ? "Where u_og.o_id = ".$params->IdUnitOrganisasi : "";

        $query = "  SELECT 
                        u_og.o_id as 'o_id',
                        u_og.Nama as 'Nama',
                        u_og.Email as 'Email',
                        u_og.Organisasi__id as 'IdOrganisasi',
                        CONCAT(assets.path,assets.filename) as 'Logo',
                        count(p.Nama) as 'Peserta'

                    FROM object_".$id_peserta." as p 
                    RIGHT JOIN object_".$id_unit_organisasi." as u_og ON u_og.o_id = p.UnitOrganisasi__id
                    LEFT JOIN assets ON assets.id = u_og.Logo ".$condition."                         
                    GROUP BY u_og.Nama";

        $objects = Website_Helper::makeQuery($query);
    
        $return->Status = 1;
        $return->Data = $objects;

        return $return;
    }

   /**
     * Manager ini untuk mendapatkan unit organisasi berdasarkan id organisasi yang terdiri dari 
     * Id, Nama, Email, Logo, Total Unit Organisasi dan Total Peserta 
     * parameter yang dapat digunakan adalah id organisasi yang nantinya dipakai pada detail organisasi
     *  
     * @param  stdClass $params 
     * @return stdClass [description]
     */
    public static function getDetailByOrganisasi($params = null)
    {
        $return = new stdClass;
        $return->Status = 0;
        $return->Message = '';
        $return->Data = NULL;

        $id_peserta = Website_Helper::getIdByClassName('Peserta');
        $id_unit_organisasi = Website_Helper::getIdByClassName('UnitOrganisasi');

        $condition = $params->IdOrganisasi ? "Where u_og.Organisasi__id = ".$params->IdOrganisasi : "";

        if($params->Search){
            $condition .=  $condition ? " AND (u_og.Nama LIKE '%".$params->Search."%')" : "Where (u_og.Nama LIKE '%".$params->Search."%')";
        }
        
        $query = "  SELECT 
                        u_og.o_id as 'o_id',
                        u_og.Nama as 'Nama',
                        u_og.Email as 'Email',
                        u_og.Organisasi__id as 'IdOrganisasi',
                        CONCAT(assets.path,assets.filename) as 'Logo',
                        count(p.Nama) as 'Peserta'

                    FROM object_".$id_peserta." as p 
                    RIGHT JOIN object_".$id_unit_organisasi." as u_og ON u_og.o_id = p.UnitOrganisasi__id
                    LEFT JOIN assets ON assets.id = u_og.Logo ".$condition."                         
                    GROUP BY u_og.Nama";

        $objects = Website_Helper::makeQuery($query);

        $return->Status = 1;
        $return->Data = $objects;

        return $return;
    }
               
}
