/*!
 * Custom Tooltip Bootstrap
 * Copyright 2016, Inc.
 * Author Romy Rudiansah
 */
 
function showTooltipInfo(el, msg, status, direction, auto) {
    
    if (status == 'error') {
        var templateTooltip = '<div class="tooltip error" role="tooltip"><div class="tooltip-arrow"></div><div class="tooltip-inner"></div><div class="tooltip-close"><i class="fa fa-times-circle"></i></div></div>'
    }else if(status == 'success') {
        var templateTooltip = '<div class="tooltip success" role="tooltip"><div class="tooltip-arrow"></div><div class="tooltip-inner"></div><div class="tooltip-close"><i class="fa fa-times-circle"></i></div></div>'
    }

    el.attr({'data-toggle':'tooltip','title':msg, 'data-original-title': msg}).tooltip({
        trigger: 'manual',
        placement: direction,
        template: templateTooltip,
        html: msg
    }).tooltip('show');

    if (auto) {
        setTimeout(function(){
            el.tooltip('destroy');
        },5000)
    }
}

$(document).on('click', '.tooltip-close', function(e) {
    $(this).parent().tooltip('destroy');
    $(this).unbind();
});

function closeAlert(el) {
    el.parent().fadeOut();
}