function showCustomModal(title, body, arrayButton){

    $('#custom-modal .modal-title').html(title);
    $('#custom-modal .modal-body').html(body);

    $('#custom-modal-button').html('');        
    if(arrayButton != undefined){
        var button = '';

        for(i in arrayButton){
            arrayButton[i].className = (arrayButton[i].className != undefined) ? arrayButton[i].className : 'btn-hero';
            arrayButton[i].text = (arrayButton[i].text != undefined) ? arrayButton[i].text : '';
            arrayButton[i].script = (arrayButton[i].script != undefined) ? arrayButton[i].script : '';

            button += '<button type="button" class="btn '+ arrayButton[i].className +'" onclick="'+  arrayButton[i].script +'">' + arrayButton[i].text + '</button>'
        }

        $('#custom-modal .modal-footer').css('display','block');
        $('#custom-modal .modal-footer').html(button);        
    }                

    $('#custom-modal').modal('show');
}

function setLocalStorage(key, value){
	var stringValue = JSON.stringify(value);
	localStorage.setItem(key, stringValue);
}

function getLocalStorage(key){
	var stringifyString = localStorage.getItem(key);
	return JSON.parse(stringifyString);
}

function removeLocalStorage(key){
	localStorage.removeItem(key);
}

function setLocalStorageParent(keyStorage, keySubStorage, value){
    var stringValue = JSON.stringify(value);

    var temp = getLocalStorage(keyStorage);
    var storage = temp ? temp : new Object;

    storage[keySubStorage] = value;

    setLocalStorage(keyStorage, storage);
}    

function setSessionStorage(key, value){
    var stringValue = JSON.stringify(value);
    sessionStorage.setItem(key, stringValue);
}

function getSessionStorage(key){
    var stringifyString = sessionStorage.getItem(key);
    return JSON.parse(stringifyString);
}

function removeSessionStorage(key){
    sessionStorage.removeItem(key);
}

function setSessionStorageParent(keyStorage, keySubStorage, value){
    var stringValue = JSON.stringify(value);

    var temp = getSessionStorage(keyStorage);
    var storage = temp ? temp : new Object;

    storage[keySubStorage] = value;

    setSessionStorage(keyStorage, storage);
}

function getSessionStorageParent(keyStorage, keySubStorage){
    var temp = getSessionStorage(keyStorage);
    var storage = temp ? temp : new Object;

    return storage[keySubStorage];
}

function showLoading(){
    var style = `
            background: #fff url(/modules/sabos/views/layouts/static/images/loading.gif) no-repeat center center; 
            height: 100%; width: 100%; 
            position: fixed; z-index: 9999999;  
            margin: 0px;  opacity: 0.85; filter: alpha(opacity=85); 
        `;

    var html = '<div id="divLoading" style="' + style + '"></div>';

    $("body").prepend(html);
    $("body").css("overflow","hidden");
}

function hideLoading(){
    $('#divLoading').fadeOut(2000);
    $("#divLoading").remove();
    $("body").css("overflow","auto");
}

function showNotif(title, description, status, auto) {
    $('#custom-notif-icon').attr("class", "");
     $('#custom-notif-color').css("background-color","#c7c9c7");
     $('#custom-notif-title').html("");
     $('#custom-notif-description').html("");
    if (status == 'success') {
        $('#custom-notif-icon').attr("class", "glyphicon glyphicon-ok-filled");
        $('#custom-notif-color').css("background-color","#64a70b");
    }
    else if (status == 'error') {
         $('#custom-notif-icon').attr("class", "glyphicon glyphicon-error");
         $('#custom-notif-color').css("background-color","#e1343e");
    }   
    else if (status == 'info') {
         $('#custom-notif-icon').attr("class", "glyphicon glyphicon-exclamation-sign");
         $('#custom-notif-color').css("background-color","#c7c9c7");
    }
          
    $('#custom-notif-title').html(title);
    $('#custom-notif-description').html(description);
    $('#custom-notif').fadeIn();

    if(auto) {
        $('#custom-notif').fadeOut(4000);    
        $('.notif .notif-close').addClass('hide');
    } else {
        $('.notif .notif-close').removeClass('hide');
    }
    
}
function closeNotif() {
    $(".notif").fadeOut(1000);
}

function setTextElementById(id, text, status){
    var html = '';

    if(status == 'error'){
        html += '<i class="fa fa-exclamation-triangle"></i> ';
    }

    html += text;
    $('#' + id).html(html);
    
    showElementById(id);
}

function showTooltipInfo(el, msg, status, direction, auto) {
    
    if (status == 'error') {
        var templateTooltip = '<div class="tooltip error" role="tooltip"><div class="tooltip-arrow"></div><div class="tooltip-inner"></div><div class="tooltip-close" onclick="closeTooltipInfo(this);"><i class="fa fa-times-circle"></i></div></div>'
    }else if(status == 'success') {
        var templateTooltip = '<div class="tooltip success" role="tooltip"><div class="tooltip-arrow"></div><div class="tooltip-inner"></div><div class="tooltip-close" onclick="closeTooltipInfo(this);"><i class="fa fa-times-circle"></i></div></div>'
    }

    el.attr({'data-toggle':'tooltip','title':msg, 'data-original-title': msg}).tooltip({
        trigger: 'manual',
        placement: direction,
        template: templateTooltip,
        html: msg
    }).tooltip('show');

    if (auto) {
        setTimeout(function(){
            el.tooltip('destroy');
        },5000)
    }
}

function closeTooltipInfo(el){
    $(el).parent().tooltip('destroy');
    $(el).unbind();
}

function showElementById(id){
    $('#' + id).removeClass('hide');
}

function hideElementById(id){
    $('#' + id).addClass('hide');
}

function addClassById(id, className){
    $('#' + id).addClass(className);
}

function removeClassById(id, className){
    $('#' + id).removeClass(className);
}

function formatNumberCurrency(value) {
    return value.toString().replace(/(\d)(?=(\d{3})+(?!\d))/g, "$1,");
}

function validateEmail(email) {
    var re = /\S+@\S+\.\S+/;
    return re.test(email);
}

function validationText(dom) {
    dom = $(dom);
    dom.val( dom.val().replace(/[^a-z A-Z]/g, '') );
}    

function callApi(url, type, dataParam, successScript, failScript){

    $.ajax({
        url: url,
        type: type,
        data: dataParam,
        success: function(response) 
        {
            try{
                response = JSON.parse(response);
            }catch(ex){}

            try{
                eval(successScript);
            }catch(ex){}
        },
        error: function (response)
        {
            try{
                eval(failScript);
            }catch(ex){}
        }
    });

}

function checkIndonesiaNumber(phoneNumber){

    var operators = {
        "FLEXI":{
            "name":"TELKOM",
            "pattern":new RegExp(/^021(68|70)\d{4,8}$|^0([2-7]|9)[^1]\d?(3[^1]|68|70|80|81)\d{4,8}$/)
        },
        "SIMPATI":{
            "name":"TELKOMSEL",
            "pattern":new RegExp(/^08(11|12|13|21)\d{6,8}$/)
        },
        "AS":{
            "name":"TELKOMSEL",
            "pattern":new RegExp(/^08(52|53)\d{8}$/)
        },
        "MENTARI":{
            "name":"INDOSAT",
            "pattern":new RegExp(/^08(14|15|16|55|58)\d{6,8}$/)
        },
        "IM2":{
            "name":"INDOSAT",
            "pattern":new RegExp(/^0814\d{8}$/)
        },
        "IM3":{
            "name":"INDOSAT",
            "pattern":new RegExp(/^08(56|57)\d{7,8}$/)
        },
        "STARONE":{
            "name":"INDOSAT",
            "pattern":new RegExp(/^0(2130|3160)\d{4,8}$|^0([2-7]|9)[^1]\d?(61|62|63|90)\d{4,8}$/)
        },
        "XL BEBAS":{
            "name":"XL AXIATA",
            "pattern":new RegExp(/^08(17|18|19|77|78|79)\d{6,8}$/)
        },
        "SMART":{
            "name":"SMARTFREN","pattern":new RegExp(/^08(81|82)\d{4,8}$/)
        },
        "FREN":{
            "name":"SMARTFREN","pattern":new RegExp(/^0888\d{4,8}$/)
        },
        "HEPI":{
            "name":"SMARTFREN",
            "pattern":new RegExp(/^0([2-7]|9)\d{1,2}(21|31|50)\d{4,8}$/)
        },
        "ESIA":{
            "name":"BTEL",
            "pattern":new RegExp(/^(02180)\d{4,8}$|^0([2-7]|9)[^1]\d?9\d{4,8}$/)
        },
        "THREE":{
            "name":"HCPT",
            "pattern":new RegExp(/^08(96|97|98|99)\d{7,8}$/)
        },
        "AXIS":{
            "name":"AXIS",
            "pattern":new RegExp(/^08(38|31)\d{7,8}$/)
        },
        "CERIA":{
            "name":"STI",
            "pattern":new RegExp(/^0828\d{4,8}$/)
        }
    };

    var result = false;
    $.each(operators, function(service, operator) { 
        if (operator['pattern'].test(phoneNumber)) {
            result = {'provider' : operator['name'], 'product' : service};
            return false;
        }   
    });
    
    return result;  
}

function toRupiah(value){
    var rgx = /(\d+)(\d{3})/;

    value += '';
    x = value.split('.');
    x1 = x[0];
    x2 = x.length > 1 ? '.' + x[1] : '';

    while (rgx.test(x1)) {
        x1 = x1.replace(rgx, '$1' + '.' + '$2');
    }

    return 'Rp. ' + x1 + x2;
}

function bindInputCustom(element, regex, errMsg){
   
    // event keypress
    element.unbind('keypress');
    element.bind('keypress', function (e) {
        var allowedChars = new RegExp(regex);
        var str = String.fromCharCode(!e.charCode ? e.which : e.charCode);
        if (allowedChars.test(str)) {
            return true;
        }
        e.preventDefault();
        return false;
    });

    // event change
    element.unbind('change');
    element.bind('change', function (e) {
        var allowedChars = new RegExp(regex);
        var str = $(this).val();
        if (allowedChars.test(str)) {
            return true;
        }
        e.preventDefault();
        $(this).val('');
        $(this).parent().find('.error-message').html(errMsg);
        return false;
    });
}

function getContentInsidePatten(text, prefix, postfix){

    if(!text || !prefix || !postfix){
        console.log('call function must be => getContentInsidePatten(text, prefix, postfix)');
        return;
    }

    var regExp = new RegExp(prefix + "([^)]+)" + postfix);
    var result = regExp.exec(text);

    return result[1] ? result[1] : '';

}

function quadrantTopologiChart(ele, size, opt){        
    var rotate = 'r-45';
    var topologiName = ['CLAN', 'ADHOCRACY', 'HIERARCHY', 'MARKET'];
    var midsize = size / 2;
    var rasio = midsize / 100;

    var s = Snap(ele); 
    s.attr({ viewBox: "0 0 " + size + " " + size});
    
    var lineX = s.line(0, midsize, size, midsize).attr({
        stroke: "#000",
        strokeWidth: 2
    });
    var lineY = s.line(midsize, 0, midsize, size).attr({
        stroke: "#000",
        strokeWidth: 2
    });

    textClan = s.text(midsize - (midsize/1.5), 20, "CLAN").attr({
        fill : 'black', fontSize:"10px"
    });
    textClan = s.text(size - (midsize/1.5), 20, "ADHOCRACY").attr({
        fill : 'black', fontSize:"10px"
    });        

    textClan = s.text(midsize - (midsize/1.5), (size - 20), "HIERARCHY").attr({
        fill : 'black', fontSize:"10px"
    });
    textClan = s.text(size - (midsize/2), (size - 20), "MARKET").attr({
        fill : 'black', fontSize:"10px"
    });

    $.each(opt.items, function(key, item){
     
        var line = item.line;
        var point = item.point;
        var value = item.value; 
        var clickFunction = item.clickFunction;
        tempPoint = [
            (midsize + (value[0] * rasio)), 
            (midsize + (value[1] * rasio)), 
            (midsize - (value[2] * rasio)), 
            (midsize - (value[3] * rasio))
        ];

        var poly = s.polygon(tempPoint[0], midsize, midsize, tempPoint[1], tempPoint[2], midsize, midsize, tempPoint[3])
        .attr({ fill: "none", stroke: line.color, opacity: line.opacity, 'strokeWidth': line.size });

        var a = s.circle( tempPoint[0], midsize, point.size ).attr({ fill: point.color, opacity: point.opacity }).append(Snap.parse('<title>' + topologiName[0] + ': ' + value[0] + '</title>')).click(function () { if(clickFunction) eval(clickFunction[0]) });
        var b = s.circle( midsize, tempPoint[1], point.size ).attr({ fill: point.color, opacity: point.opacity }).append(Snap.parse('<title>' + topologiName[1] + ': ' + value[1] + '</title>')).click(function () { if(clickFunction) eval(clickFunction[1]) });
        var c = s.circle( tempPoint[2], midsize, point.size ).attr({ fill: point.color, opacity: point.opacity }).append(Snap.parse('<title>' + topologiName[2] + ': ' + value[2] + '</title>')).click(function () { if(clickFunction) eval(clickFunction[2]) });
        var d = s.circle( midsize, tempPoint[3], point.size ).attr({ fill: point.color, opacity: point.opacity }).append(Snap.parse('<title>' + topologiName[3] + ': ' + value[3] + '</title>')).click(function () { if(clickFunction) eval(clickFunction[3]) });

        var g0 = s.group( poly, a, b, c, d );        
        g0.transform( 'r225, ' + midsize + ', ' + midsize + '' );        

    });

}    
