<?php

    $user = $this->User;
    $type = $this->Type;

    if($type == "Peserta"){
        $nama = $user->Nama;
        $jabatan = $user->Jabatan;
        $unitOrganisasi = $user->UnitOrganisasi ? $user->UnitOrganisasi->Nama : 'Trial User';;
        $organisasi = $user->UnitOrganisasi->Organisasi->Nama;
        $email = $user->Email;
        $telepon = $user->Telepon;        

        if ($user->FotoProfil)
            $image = $user->FotoProfil->path . $user->FotoProfil->filename;
        elseif (!$user->FotoProfil && $user->JenisKelamin == 'Pria')
            $image = '/modules/sabos/views/layouts/static/images/placeholder-male.png';
        elseif (!$user->FotoProfil && $user->JenisKelamin == 'Wanita')
            $user->FotoProfil = '/modules/sabos/views/layouts/static/images/placeholder-female.png';
        elseif (!$user->FotoProfil && $user->JenisKelamin)
            $image = '/modules/sabos/views/layouts/static/images/placeholder-male.png';
    } else if ($type == "Organisasi") {
        $nama = $user->Nama;
        $email = $user->Email;
        $organisasi = $Alamat;

        if ($user->Logo){
            $image = $user->Logo->path . $user->Logo->filename;
        } else {
            $image = '/modules/sabos/views/layouts/static/images/placeholder-logo.png';            
        }
    } else if ($type == "UnitOrganisasi") {
        $nama = $user->Nama;
        $email = $user->Email;
        $organisasi = $user->Organisasi->Nama;


        if ($user->Organisasi->Logo){
            $image = $user->Organisasi->Logo->path . $user->Organisasi->Logo->filename;
        } else {
            $image = '/modules/sabos/views/layouts/static/images/placeholder-logo.png';            
        }
    }

    $ocai_di = [];
    $ocai_si = [];
    
    foreach ($this->Summary[ocai] as $key => $item) {
        array_push($ocai_si, $item['si']);
        array_push($ocai_di, $item['di']);
    }

    $msai = [];
    foreach ($this->Summary[msai] as $key => $item) {
        array_push($msai, $item['total']);
    }    

?>

<link type="text/css" rel="stylesheet" href="/modules/sabos/views/layouts/static/css/custom/summary.css">
<link href='http://fonts.googleapis.com/css?family=Rokkitt:400,700|Lato:400,300' rel='stylesheet' type='text/css'>
<!--[if lt IE 9]>
<script src="//html5shiv.googlecode.com/svn/trunk/html5.js"></script>
<![endif]-->

<div id="cv" class="instaFade">
    <div class="mainDetails">
        <div id="headshot">
            <img src="<?= $image ?>" alt="Image Resume" />
        </div>

        <div id="headshot-mobile">
            <center>                    
                <img src="<?= $image ?>" alt="Image Resume" />
            </center>
        </div>
        
        <div id="name">
            <h1 class="quickFade delayTwo"><?= $nama ?></h1>
            <h2 class="quickFade delayThree"><?= $jabatan ?></h2>
            <h2 class="quickFade delayThree"><?= $unitOrganisasi ?>
            <?= $organisasi ?></h3>                    
        </div>
        
        <div id="contactDetails" class="quickFade delayFour">
            <ul>
                <?php if($email){ ?>

                <li>e: <a href="mailto:<?= $email ?>" target="_blank"><?= $email ?></a></li>

                <?php } ?>
                <?php if($telepon){ ?>
                
                <li>m: <?= $telepon ?></li>
                
                <?php } ?>
            </ul>
        </div>
        <div class="clear"></div>
    </div>
    
    <div id="mainArea" class="quickFade delayFive">

<!-- 
        <section>                    
            <div class="sectionContent" style="width: 100%; float: right;">
                <article>
                    <h2 style="color: #cf8a05; font-family: 'Rokkitt', Helvetica, Arial, sans-serif; font-style: italic; font-size: 1.5em;">
                        Resume Singkat
                    </h2>
                    <p class="subDetails">&nbsp;</p>
                    <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec ultricies massa et erat luctus hendrerit. Curabitur non consequat enim. Vestibulum bibendum mattis dignissim. Proin id sapien quis libero interdum porttitor.</p>
                </article>                        
            </div>
            <div class="clear"></div>
        </section>
 -->

        <section>                    
            <div class="sectionContent" style="width: 100%; float: right;">
                <article>
                    <h2 style="color: #cf8a05; font-family: 'Rokkitt', Helvetica, Arial, sans-serif; font-style: italic; font-size: 1.5em;">
                        Hasil OCAI
                    </h2>
                    <p class="subDetails">&nbsp;</p>
                    <!-- <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec ultricies massa et erat luctus hendrerit. Curabitur non consequat enim. Vestibulum bibendum mattis dignissim. Proin id sapien quis libero interdum porttitor.</p> -->
                    <!-- <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec ultricies massa et erat luctus hendrerit. Curabitur non consequat enim. Vestibulum bibendum mattis dignissim. Proin id sapien quis libero interdum porttitor.</p> -->

                    <table id="table-ocai" class="table table-striped table-bordered table-hover">
                        <thead>
                            <tr>
                                <th class="all" rowspan="2"> Topologi </th>
                                <th colspan="2"> Saat Ini (Des Sein) </th>
                                <th colspan="2"> Diinginkan (Des Solen) </th>
                                <th rowspan="2"> Selisih </th>
                            </tr>
                            <tr>
                                <th> Nilai </th>
                                <th> Posisi </th>
                                <th> Nilai </th>
                                <th> Posisi </th>
                            </tr>
                         </thead>

                        <tbody>

                            <?php 
                            if($this->Summary['ocai'])
                                foreach ($this->Summary['ocai'] as $key => $value) { ?>

                            <tr class="odd gradeX">
                                <td> <strong> <?= $value['topologi'] ?> </strong> </td>
                                <td> <?= $value['si'] ?> </td>
                                <td> (<?= $value['si_posisi'] ?>) </td>
                                <td> <?= $value['di'] ?> </td>
                                <td> (<?= $value['di_posisi'] ?>) </td>
                                <td> <?= $value['selisih_si_di'] ?> </td>
                            </tr>

                            <?php } ?>

                        </tbody>
                    </table>

                    <h2 class="text-center"> Visualisasi Hasil </h2>
                    <p class="subDetails">&nbsp;</p>

                    <div class="text-center">
                        <svg id="graphOcai" style="max-width: 500px"></svg>
                    </div>

                    <p class="subDetails">&nbsp;</p>

                </article>                        
            </div>
            <div class="clear"></div>
        </section>

        <div class="html2pdf__page-break"></div>        
        
        <section>                    
            <div class="sectionContent" style="width: 100%; float: right;">
                <article>
                    <h2 style="color: #cf8a05; font-family: 'Rokkitt', Helvetica, Arial, sans-serif; font-style: italic; font-size: 1.5em;">
                        Hasil MSAI
                    </h2>
                    <p class="subDetails">&nbsp;</p>
                    <!-- <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec ultricies massa et erat luctus hendrerit. Curabitur non consequat enim. Vestibulum bibendum mattis dignissim. Proin id sapien quis libero interdum porttitor.</p> -->
                    <!-- <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec ultricies massa et erat luctus hendrerit. Curabitur non consequat enim. Vestibulum bibendum mattis dignissim. Proin id sapien quis libero interdum porttitor.</p> -->

                    <table id="table-msai" class="table table-striped table-bordered table-hover">
                        <thead>
                            <tr>
                                <th class="all"> Topologi </th>
                                <th> Deskripsi </th>
                                <th> Nilai </th>
                                <th> Total Nilai Topologi </th>
                            </tr>
                         </thead>

                        <tbody>

                            <?php 
                            if($this->Summary['msai'])
                                foreach ($this->Summary['msai'] as $key => $value) { ?>

                            <tr class="odd gradeX">
                                <td rowspan="3"> <strong> <?= $value['topologi'] ?> </strong> </td>
                                <td> <?= $value['deskripsi'][0][0] ?> </td>
                                <td> <?= $value['deskripsi'][0][2] ?> </td>
                                <td rowspan="3"> <?= $value['total'] ?> </td>
                            </tr>

                            <?php for ($i = 1 ; $i < count($value['deskripsi']) ; $i++) { ?>

                            <tr class="odd gradeX">
                                <td> <?= $value['deskripsi'][$i][0] ?>  </td>
                                <td> <?= $value['deskripsi'][$i][2] ?>  </td>
                            </tr>

                            <?php } ?>

                            <?php } ?>

                        </tbody>
                    </table>                                        

                    <h2 class="text-center"> Visualisasi Hasil </h2>
                    <p class="subDetails">&nbsp;</p>

                    <div class="text-center">
                        <svg id="graphMsai" style="max-width: 500px"></svg>
                    </div>

                    <p class="subDetails">&nbsp;</p>

                </article>                        
            </div>
            <div class="clear"></div>
        </section>

        <div class="html2pdf__page-break"></div>        

        <section>                    
            <div class="sectionContent" style="width: 100%; float: right;">
                <article>
                    <h2 style="color: #cf8a05; font-family: 'Rokkitt', Helvetica, Arial, sans-serif; font-style: italic; font-size: 1.5em;">
                        Hasil RVS
                    </h2>
                    <p class="subDetails">&nbsp;</p>
                    <!-- <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec ultricies massa et erat luctus hendrerit. Curabitur non consequat enim. Vestibulum bibendum mattis dignissim. Proin id sapien quis libero interdum porttitor.</p> -->

                    <div class="col-md-6 col-xs-12">
                        <b> Nilai RVS Terminal (Dirurtkan dari paling penting) </b>
                        <table id="table-rvs-terminal" class="table table-striped table-bordered table-hover">
                            <thead>
                                <tr>
                                    <th class="all"> No </th>
                                    <th class="all"> Kode </th>
                                    <th class="all"> Nilai </th>
                                </tr>
                             </thead>

                            <tbody>

                                <?php 
                                if($this->Summary['rvs']['terminal'])
                                    foreach ($this->Summary['rvs']['terminal'] as $key => $value) { ?>

                                <tr class="odd gradeX">
                                    <td>  <?= ($key + 1) ?>  </td>
                                    <td> <?= $value['kode'] ?> </td>
                                    <td> <?= $value['nilai'] ?> </td>
                                </tr>

                                <?php } ?>

                            </tbody>
                        </table>                                                                                        
                    </div>

                    <div class="col-md-6 col-xs-12">
                        <b> Nilai RVS Instrumen (Dirurtkan dari paling penting) </b>
                        <table id="table-rvs-terminal" class="table table-striped table-bordered table-hover">
                            <thead>
                                <tr>
                                    <th class="all"> No </th>
                                    <th class="all"> Kode </th>
                                    <th class="all"> Nilai </th>
                                </tr>
                             </thead>

                            <tbody>

                                <?php 
                                if($this->Summary['rvs']['instrument'])
                                    foreach ($this->Summary['rvs']['instrument'] as $key => $value) { ?>

                                <tr class="odd gradeX">
                                    <td> <?= ($key + 1) ?>  </td>
                                    <td> <?= $value['kode'] ?>  </td>
                                    <td> <?= $value['nilai'] ?> </td>
                                </tr>

                                <?php } ?>

                            </tbody>
                        </table>                                                                                        
                    </div>

                    <div style="clear: both;"></div>

                </article>                        
            </div>
            <div class="clear"></div>
        </section>

        <!-- <div class="html2pdf__page-break"></div>         -->

<!-- 
        <section>                    
            <div class="sectionContent" style="width: 100%; float: right;">
                <article>
                    <h2 style="color: #cf8a05; font-family: 'Rokkitt', Helvetica, Arial, sans-serif; font-style: italic; font-size: 1.5em;">
                        Kesimpulan
                    </h2>
                    <p class="subDetails">&nbsp;</p>
                    <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec ultricies massa et erat luctus hendrerit. Curabitur non consequat enim. Vestibulum bibendum mattis dignissim. Proin id sapien quis libero interdum porttitor.</p>
                    <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec ultricies massa et erat luctus hendrerit. Curabitur non consequat enim. Vestibulum bibendum mattis dignissim. Proin id sapien quis libero interdum porttitor.</p>
                </article>                        
            </div>
            <div class="clear"></div>
        </section>                

        <section>
            <div class="sectionTitle">
                <h1>Key Skills</h1>
            </div>
            
            <div class="sectionContent">
                <ul class="keySkills">
                    <li>A Key Skill</li>
                    <li>A Key Skill</li>
                    <li>A Key Skill</li>
                    <li>A Key Skill</li>
                    <li>A Key Skill</li>
                    <li>A Key Skill</li>
                    <li>A Key Skill</li>
                    <li>A Key Skill</li>
                </ul>
            </div>
            <div class="clear"></div>
        </section>                
-->                

    </div>
</div>

<script src="/modules/sabos/views/layouts/static/js/snap.svg/snap.svg.min.js" type="text/javascript"></script>
<script src="/modules/sabos/views/layouts/static/js/custom/helper.js" type="text/javascript"></script>

<script src="/modules/sabos/views/layouts/static/js/js2pdf/jspdf.min.js" type="text/javascript"></script>
<script src="/modules/sabos/views/layouts/static/js/js2pdf/html2canvas.min.js" type="text/javascript"></script>
<script src="/modules/sabos/views/layouts/static/js/js2pdf/html2pdf.js" type="text/javascript"></script>

<script type="text/javascript">

    showLoading(); 

    $(document).ready(function () {    

        /* custom chart */
        // for ocai
        var params = new Object;
        params.items = new Array();
        params.items.push({
            line : { color : 'blue', opacity : 0.3, size: 2 },
            point : { color : 'blue', opacity : 0.5, size: 4 },
            value : <?= json_encode($ocai_di) ?>,
        });
        params.items.push({
            line : { color : 'red', opacity : 0.3, size: 2 },
            point : { color : 'red', opacity : 0.5, size: 4 },
            value : <?= json_encode($ocai_si) ?>,
        });
        quadrantTopologiChart('#graphOcai', 400, params);

        // for msai
        var params = new Object;
        params.items = new Array();
        params.items.push({
            line : { color : 'blue', opacity : 0.3, size: 2 },
            point : { color : 'blue', opacity : 0.5, size: 4 },
            value : <?= json_encode($msai) ?> ,
        });
        quadrantTopologiChart('#graphMsai', 400, params);
        /* custom chart */

        // svg to image canvas for ocai
        var svgOcai = $("#graphOcai");
        var svgData = new XMLSerializer().serializeToString( svgOcai.get(0) );

        var imageOcai = document.createElement( "img" );
        imageOcai.setAttribute( "src", "data:image/svg+xml;base64," + btoa( svgData ) );

        imageOcai.onload = function() {
            var canvas = document.createElement( "canvas" );
            canvas.width = 400 ;
            canvas.height = 400;
            var context = canvas.getContext('2d');
            context.drawImage(imageOcai, 0, 0);            

            svgOcai.parent().html(canvas);
        };
        // svg to image canvas for ocai

        // svg to image canvas for msai
        var svgMsai = $("#graphMsai");
        var svgData = new XMLSerializer().serializeToString( svgMsai.get(0) );

        var imageMsai = document.createElement( "img" );
        imageMsai.setAttribute( "src", "data:image/svg+xml;base64," + btoa( svgData ) );

        imageMsai.onload = function() {
            var canvas = document.createElement( "canvas" );
            canvas.width = 400 ;
            canvas.height = 400;
            var context = canvas.getContext('2d');
            context.drawImage(imageMsai, 0, 0);            

            svgMsai.parent().html(canvas);
        };
        // svg to image canvas for msai

        // for download pdf and auto close
        setTimeout(function(){ 

            var element = document.getElementById('cv');
            html2pdf(element, {
                margin:       0,
                filename:     '<?= $nama ?>.pdf',
                image:        { type: 'jpeg', quality: 0.99 },
                html2canvas:  { dpi: 260, letterRendering: true },
                jsPDF:        { unit: 'in', format: 'a4', orientation: 'portrait' }
            });

            setTimeout(function(){ 
                window.close()
            }, 4000);
            
        }, 1000);
        // for download pdf and auto close

    });

</script>
