<link rel="stylesheet" href="/modules/sabos/views/layouts/static/css/zabuto_calendar.min.css">
<script type="text/javascript" src="/modules/sabos/views/layouts/static/js/zabuto_calendar.min.js"></script>

<div class="row">
	
	<div class="col-md-6 col-xs-12">
		<div id="calendars"></div>
	</div>
	<div class="col-md-6 col-xs-12">
		<h2>Kalender Acara</h2>
		<h3 id="title-event"> </h3>
		<span id="date-event"> </span>
		<p id="desc-event"> </p>
	</div>

</div>

<script type="text/javascript">

	var eventData = [

		<?php if($this->events){ ?>
		<?php foreach($this->events as $event){ ?>

	    {"date":"<?= date('Y-m-d', $event['Date']) ?>","badge":true,"title":"<?= $event['Name'] ?>","body":"<?= $event['Description'] ?>"},

	    <?php } ?>
	    <?php } ?>

	];

    $(document).ready(function () {

        $("#calendars").zabuto_calendar({
            action: function () {
                return myDateFunction(this.id);
            },
            data: eventData,
            language: "id",
            today: true,
            legend: false
        });

        dateEvent();
    });
    
    function myDateFunction(id) {
        var date = $("#" + id).data("date");
        var hasEvent = $("#" + id).data("hasEvent");
        if (hasEvent) {

        	 $.each(eventData, function(i, v){
                if( v.date == date )
                {
                    $( '#title-event' ).html( v.title );
                    $( '#date-event' ).html( convertDate( v.date ) );
                    $( '#desc-event' ).html( v.body );
                    return false;
                }
            });
        }
        return true;
    }

    function convertDate( date ) {
        var date_array = date.split( "-" );
        var months = [ "Januari", "Februari", "Maret", "April", "Mei", "Juni", "Juli", "Agustus", "September", "Oktober", "Nopember", "Desember" ];
        var y = date_array[ 0 ];
        var m = date_array[ 1 ];
        var d = date_array[ 2 ];
        var output = ( d * 1 ) + ' ' + months[ ( m - 1 ) ] + ' ' + y;
        return output;
    }

    function dateEvent() {
	    var today = new Date();
		var dd = today.getDate();
		var mm = today.getMonth()+1; //January is 0!
		var yyyy = today.getFullYear();

		if(dd<10) {
		    dd='0'+dd
		} 

		if(mm<10) {
		    mm='0'+mm
		} 

		today = yyyy+'-'+mm+'-'+dd;
		var a = eventData.length;
		for (var i = 0; i < a; i++) {
			if (Date.parse(eventData[i]['date']) >= Date.parse(today)) {

				if (eventData[i]['date'] == today){
					$( '#title-event' ).html( eventData[i]['title'] );
	                $( '#date-event' ).html( convertDate( eventData[i]['date'] ) );
	                $( '#desc-event' ).html( eventData[i]['body'] );
	                return false;
				}else{
					$( '#title-event' ).html( eventData[i]['title'] );
	                $( '#date-event' ).html( convertDate( eventData[i]['date'] ) );
	                $( '#desc-event' ).html( eventData[i]['body'] );
					return false;
				}
			}
		}
    }
</script>        
