     
<div class="user-login-5">
    <div class="row bs-reset">
        <div class="col-md-6 login-container bs-reset">

        	<div class="text-center">
            	<img class="login-logo login-6" src="/modules/sabos/views/layouts/static/assets/pages/img/login/logo.png" />
        	</div>

            <div class="login-content" style="margin-top: 30%">

                <h1>SABOS</h1>
                <p> 
                    Merupakan sebuah aplikasi WEB yang dapat menilai dan mengkategorikan budaya organisasi dari sebuah organisasi maupun unit organisasi.
                </p>

                <form action="javascript:;" class="login-form" method="post">

                    <div class="alert alert-danger display-hide">
                        <button class="close" data-close="alert"></button>
                        <span>Enter any username and password. </span>
                    </div>

                    <div class="row">
                        <div class="col-md-12">
                            <input class="form-control form-control-solid placeholder-no-fix form-group" type="text" autocomplete="off" placeholder="Username" name="Username" /> 
                        </div>
                        <div class="col-md-12">
                            <input class="form-control form-control-solid placeholder-no-fix form-group" type="password" autocomplete="off" placeholder="Password" name="Password" /> 
                        </div>
                    </div>

                    <div class="row" style="text-align: right;">
                        <div class="forgot-password">
                            <a href="javascript:void(0);" id="forget-password" class="forget-password">Forgot Password?</a>
                        </div>
                        <button class="btn blue" type="submit">Sign In</button>
	                </div>

                </form>

                <!-- BEGIN FORGOT PASSWORD FORM -->
                <form class="forget-form" action="javascript:;" method="post">
                    <h3>Forgot Password ?</h3>
                    <p> Masukan email user </p>
                    <div class="form-group">
                        <input class="form-control placeholder-no-fix" type="text" autocomplete="off" placeholder="Email" name="email" /> </div>
                    <div class="form-actions">
                        <button type="button" id="back-btn" class="btn blue btn-outline">Back</button>
                        <button type="submit" class="btn blue uppercase pull-right">Submit</button>
                    </div>
                </form>
                <!-- END FORGOT PASSWORD FORM -->

            </div>

            <div class="login-footer">
                <div class="row bs-reset">
                    <div class="login-copyright text-center">
                        <p>Copyright &copy; Sinergi Pakarya 2017</p>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-6 bs-reset hidden-xs hidden-sm">
            <div class="login-bg"> </div>
        </div>

    </div>
</div>

<script type="text/javascript">

    jQuery(document).ready(function() {
        Login.init();
    });

	var Login = function() {

	    var handleLogin = function() {

	        $('.login-form').validate({
	            errorElement: 'span', //default input error message container
	            errorClass: 'help-block', // default input error message class
	            focusInvalid: false, // do not focus the last invalid input
	            rules: {
	                Username: {
	                    required: true
	                },
	                Password: {
	                    required: true
	                },
	                remember: {
	                    required: false
	                }
	            },

	            messages: {
	                Username: {
	                    required: "Username harus diisi."
	                },
	                Password: {
	                    required: "Password harus diisi."
	                }
	            },

	            invalidHandler: function(event, validator) { //display error alert on form submit   
	            	if(!$('[name="Username"]').val() && !$('[name="Password"]').val()){
	            		$('.login-form .alert-danger span').html('Username dan pasword harus diisi');
	            	} else if(!$('[name="Username"]').val()){
	            		$('.login-form .alert-danger span').html('Username belum diisi');
	            	} else if(!$('[name="Password"]').val()){
	            		$('.login-form .alert-danger span').html('Password belum diisi');
	            	}

	                $('.alert-danger', $('.login-form')).show();
	            },

	            highlight: function(element) { // hightlight error inputs
	                $(element)
	                    .closest('.form-group').addClass('has-error'); // set error class to the control group
	            },

	            success: function(label) {
	                label.closest('.form-group').removeClass('has-error');
	                label.remove();
	            },

	            errorPlacement: function(error, element) {
	                error.insertAfter(element.closest('.input-icon'));
	            },

	            submitHandler: function(form) {

	            	showLoading();

	                //form.submit(); // form validation success, call ajax form submit
	                var data = $('.login-form').serialize();
	                
	                $.ajax({
	                	type : "POST",
	                	url : "/api/user/login",
	                	data : data,
	                	success:function(response){
	                		response = JSON.parse(response);
	                		if(response.Status){
	                			if(response.Data[0].Role == 'Admin'){
	                				window.location.href="/sabos/dashboard";
	                			}else if(response.Data[0].Role == 'Peserta'){
	                				window.location.href="/sabos/update-profile";
	                			}
	                		}else{
			            		$('.login-form .alert-danger span').html('Username dan password tidak valid');
	                			$('.alert-danger', $('.login-form')).show();

	                			hideLoading();
	                		}
	                	}, 
	                	error:function(response){
                			hideLoading();
	                	}
	                });
	            }
	        });

	        $('.login-form input').keypress(function(e) {
	            if (e.which == 13) {
	                if ($('.login-form').validate().form()) {
	                    $('.login-form').submit(); //form validation success, call ajax form submit

	                }
	                return false;
	            }
	        });

	        $('.forget-form input').keypress(function(e) {
	            if (e.which == 13) {
	                if ($('.forget-form').validate().form()) {
	                    $('.forget-form').submit();
	                }
	                return false;
	            }
	        });

	        $('#forget-password').click(function(){
	            $('.login-form').hide();
	            $('.forget-form').show();
	        });

	        $('#back-btn').click(function(){
	            $('.login-form').show();
	            $('.forget-form').hide();
	        });
	    }


	    return {
	        //main function to initiate the module
	        init: function() {

	            handleLogin();

	            // init background slide images
	            $('.login-bg').backstretch([
	                "/modules/sabos/views/layouts/static/assets/pages/img/login/bg1.jpg",
	                "/modules/sabos/views/layouts/static/assets/pages/img/login/bg2.jpg",
	                "/modules/sabos/views/layouts/static/assets/pages/img/login/bg3.jpg",
	                "/modules/sabos/views/layouts/static/assets/pages/img/login/bg4.jpg"
	                ], {
	                  fade: 1000,
	                  duration: 8000
	                }
	            );

	            $('.forget-form').hide();

	        }

	    };

	}();

</script>
<script src="/modules/sabos/views/layouts/static/js/custom/helper.js" type="text/javascript"></script>
