     
<div class="user-login-5">
    <div class="row bs-reset">
        <div class="col-md-6 login-container bs-reset">

        	<div class="text-center">
            	<img class="login-logo login-6" src="/modules/sabos/views/layouts/static/assets/pages/img/login/logo.png" />
        	</div>

            <div class="login-content" style="margin-top: 30%;">

                <h1>SABOS</h1>
                <p> 
                    Merupakan sebuah aplikasi WEB yang dapat menilai dan mengkategorikan budaya organisasi dari sebuah organisasi maupun unit organisasi.
                    <br />
                    Silahkan registrasikan diri sehingga Anda dapat menilai kategori organisasi secara pribadi
                </p>

                <form action="javascript:;" class="login-form" method="post">

                    <div class="alert alert-danger display-hide">
                        <button class="close" data-close="alert"></button>
                        <span> </span>
                    </div>

                    <div class="row">
                        <div class="col-xs-12">
                            <input class="form-control form-control-solid placeholder-no-fix form-group" type="text" autocomplete="off" placeholder="Masukan email" name="Email" /> 
                        </div>
                        <div class="col-xs-12">
                            <input class="form-control form-control-solid placeholder-no-fix form-group" type="text" autocomplete="off" placeholder="Masukan nama" name="Nama" /> 
                        </div>
                    </div>

                    <div class="row">
                        <div class="text-right">
                            <button class="btn blue" type="submit">Register</button>
                        </div>
                    </div>

                </form>

            </div>

            <div class="login-footer">
                <div class="row bs-reset">
                    <div class="login-copyright text-center">
                        <p>Copyright &copy; Sinergi Pakarya 2017</p>
                    </div>
                </div>
            </div>
        </div>

        <div class="col-md-6 bs-reset hidden-xs hidden-sm">
            <div class="login-bg"> </div>
        </div>

    </div>
</div>

<script type="text/javascript">

    jQuery(document).ready(function() {
        Login.init();
    });

	var Login = function() {

	    var handleLogin = function() {

	        $('.login-form').validate({
	            errorElement: 'span', //default input error message container
	            errorClass: 'help-block', // default input error message class
	            focusInvalid: false, // do not focus the last invalid input
	            rules: {
	                Email: {
	                    required: true
	                },
	                Nama: {
	                    required: true
	                }	                
	            },
	            messages: {
	                Username: {
	                    required: "Email harus diisi."
	                },
	                Nama: {
	                    Nama: "Email harus diisi."
	                }
	            },
	            invalidHandler: function(event, validator) { //display error alert on form submit   
					if(!$('[name="Email"]').val() && !$('[name="Nama"]').val()){
	            		$('.login-form .alert-danger span').html('Email dan nama harus diisi');
	            	} else if(!$('[name="Email"]').val()){
	            		$('.login-form .alert-danger span').html('Email belum diisi');
	            	} else if(!$('[name="Nama"]').val()){
	            		$('.login-form .alert-danger span').html('Nama belum diisi');
	            	}

	                $('.alert-danger', $('.login-form')).show();
	            },

	            highlight: function(element) { // hightlight error inputs
	                $(element)
	                    .closest('.form-group').addClass('has-error'); // set error class to the control group
	            },

	            success: function(label) {
	                label.closest('.form-group').removeClass('has-error');
	                label.remove();
	            },

	            errorPlacement: function(error, element) {
	                error.insertAfter(element.closest('.input-icon'));
	            },

	            submitHandler: function(form) {

					if(!validateEmail($('[name="Email"]').val())){
	            		$('.login-form .alert-danger span').html('Format email tidak valid');
		                $('.alert-danger', $('.login-form')).show();
	
	            		return false;
	            	} 
	            	
	                var data = $('.login-form').serialize();
	                
	            	showLoading();
	                $.ajax({
	                	type : "POST",
	                	url : "/api/user/register",
	                	data : data,
	                	success:function(response){
	                		response = JSON.parse(response);
	                		if(response.Status){
                				window.location.href="/sabos/success-registration";
	                		}else{
			            		$('.login-form .alert-danger span').html(response.Message);
	                			$('.alert-danger', $('.login-form')).show();

	                			hideLoading();
	                		}
	                	}, 
	                	error:function(response){
                			hideLoading();
	                	}
	                });
	            }
	        });

	        $('.login-form input').keypress(function(e) {
	            if (e.which == 13) {
	                if ($('.login-form').validate().form()) {
	                    $('.login-form').submit(); //form validation success, call ajax form submit
	                }
	                return false;
	            }
	        });
	    }


	    return {
	        //main function to initiate the module
	        init: function() {

	            handleLogin();

	            // init background slide images
	            $('.login-bg').backstretch([
	                "/modules/sabos/views/layouts/static/assets/pages/img/login/bg1.jpg",
	                "/modules/sabos/views/layouts/static/assets/pages/img/login/bg2.jpg",
	                "/modules/sabos/views/layouts/static/assets/pages/img/login/bg3.jpg",
	                "/modules/sabos/views/layouts/static/assets/pages/img/login/bg4.jpg"
	                ], {
	                  fade: 1000,
	                  duration: 8000
	                }
	            );

	            $('.forget-form').hide();

	        }

	    };

	}();

	function validateEmail(email) {
	    var re = /^(([^<>()\[\]\\.,;:\s@"]+(\.[^<>()\[\]\\.,;:\s@"]+)*)|(".+"))@((\[[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}])|(([a-zA-Z\-0-9]+\.)+[a-zA-Z]{2,}))$/;
	    return re.test(email);
	}	

</script>
<script src="/modules/sabos/views/layouts/static/js/custom/helper.js" type="text/javascript"></script>
