<?php

    $peserta = $this->Peserta;

    if ($peserta->FotoProfil)
        $fotoProfil = $peserta->FotoProfil->path . $peserta->FotoProfil->filename;
    elseif (!$peserta->FotoProfil && $peserta->JenisKelamin == 'Pria')
        $fotoProfil = '/modules/sabos/views/layouts/static/images/placeholder-male.png';
    elseif (!$peserta->FotoProfil && $peserta->JenisKelamin == 'Wanita')
        $peserta->FotoProfil = '/modules/sabos/views/layouts/static/images/placeholder-female.png';
    elseif (!$peserta->FotoProfil && $peserta->JenisKelamin)
        $fotoProfil = '/modules/sabos/views/layouts/static/images/placeholder-male.png';

    $ocai_di = [];
    $ocai_si = [];
    
    foreach ($this->Summary[ocai] as $key => $item) {
        array_push($ocai_si, $item['si']);
        array_push($ocai_di, $item['di']);
    }

    $msai = [];
    foreach ($this->Summary[msai] as $key => $item) {
        array_push($msai, $item['total']);
    }

?>

<link type="text/css" rel="stylesheet" href="/modules/sabos/views/layouts/static/css/custom/summary.css">
<link href='http://fonts.googleapis.com/css?family=Rokkitt:400,700|Lato:400,300' rel='stylesheet' type='text/css'>

<!--[if lt IE 9]>
<script src="//html5shiv.googlecode.com/svn/trunk/html5.js"></script>
<![endif]-->


<div class="portlet light bg-inverse">
    <div class="portlet-body form">

        <br /><br />
        <div class="text-center">
            <a class="btn btn-primary btn-sm" href="/sabos/update-profile" role="button">
                Ubah profile Anda
            </a>
            <a class="btn btn-primary btn-sm" href="/sabos/default/get-resume?id=<?= $peserta->o_id ?>" target="_blank" role="button">
                Unduh resume
            </a>

        </div>


        <div id="cv" class="instaFade">
            <div class="mainDetails">
                <div id="headshot">
                    <img src="<?= $fotoProfil ?>" alt="Foto Profil" />
                </div>

                <div id="headshot-mobile">
                    <center>                    
                        <img src="<?= $fotoProfil ?>" alt="Foto Profil" />
                    </center>
                </div>
                
                <div id="name">
                    <h1 class="quickFade delayTwo"><?= $peserta->Nama ?></h1>
                    <h2 class="quickFade delayThree"><?= $peserta->Jabatan ?></h2>
                    <h2 class="quickFade delayThree"><?= $peserta->UnitOrganisasi ? $peserta->UnitOrganisasi->Nama : 'Trial User' ?>
                    <?= $peserta->UnitOrganisasi->Organisasi ? 'of ' . $peserta->UnitOrganisasi->Organisasi->Nama : '' ?></h3>                    
                </div>
                
                <div id="contactDetails" class="quickFade delayFour">
                    <ul>
                        <li>e: <a href="mailto:<?= $peserta->Email ?>" target="_blank"><?= $peserta->Email ?></a></li>
                        <li>m: <?= $peserta->Telepon ?></li>
                    </ul>
                </div>
                <div class="clear"></div>
            </div>
            
            <div id="mainArea" class="quickFade delayFive">
<!-- 
                <section>                    
                    <div class="sectionContent" style="width: 100%; float: right;">
                        <article>
                            <h2 style="color: #cf8a05; font-family: 'Rokkitt', Helvetica, Arial, sans-serif; font-style: italic; font-size: 1.5em;">
                                Resume Singkat
                            </h2>
                            <p class="subDetails">&nbsp;</p>
                            <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec ultricies massa et erat luctus hendrerit. Curabitur non consequat enim. Vestibulum bibendum mattis dignissim. Proin id sapien quis libero interdum porttitor.</p>
                        </article>                        
                    </div>
                    <div class="clear"></div>
                </section>
 -->
                <section>                    
                    <div class="sectionContent" style="width: 100%; float: right;">
                        <article>
                            <h2 style="color: #cf8a05; font-family: 'Rokkitt', Helvetica, Arial, sans-serif; font-style: italic; font-size: 1.5em;">
                                Hasil OCAI
                            </h2>
                            <p class="subDetails">&nbsp;</p>
                            <!-- <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec ultricies massa et erat luctus hendrerit. Curabitur non consequat enim. Vestibulum bibendum mattis dignissim. Proin id sapien quis libero interdum porttitor.</p> -->

                            <table id="table-ocai" class="table table-striped table-bordered table-hover">
                                <thead>
                                    <tr>
                                        <th class="all" rowspan="2"> Topologi </th>
                                        <th colspan="2"> Saat Ini (Des Sein) </th>
                                        <th colspan="2"> Diinginkan (Des Solen) </th>
                                        <th rowspan="2"> Selisih </th>
                                    </tr>
                                    <tr>
                                        <th> Nilai </th>
                                        <th> Posisi </th>
                                        <th> Nilai </th>
                                        <th> Posisi </th>
                                    </tr>
                                 </thead>

                                <tbody>

                                    <?php 
                                    if($this->Summary['ocai'])
                                        foreach ($this->Summary['ocai'] as $key => $value) { ?>

                                    <tr class="odd gradeX">
                                        <td> <strong> <?= $value['topologi'] ?> </strong> </td>
                                        <td> <?= $value['si'] ?> </td>
                                        <td> (<?= $value['si_posisi'] ?>) </td>
                                        <td> <?= $value['di'] ?> </td>
                                        <td> (<?= $value['di_posisi'] ?>) </td>
                                        <td> <?= $value['selisih_si_di'] ?> </td>
                                    </tr>

                                    <?php } ?>

                                </tbody>
                            </table>

                            <p class="subDetails">&nbsp;</p>
                            <h2 class="text-center"> Visualisasi Hasil </h2>
                            <p class="subDetails">&nbsp;</p>

                            <div class="text-center">
                                <svg id="graphOcai" style="max-width: 500px"></svg>
                            </div>

                            <p class="subDetails">&nbsp;</p>

                        </article>                        
                    </div>
                    <div class="clear"></div>
                </section>
                
                <section>                    
                    <div class="sectionContent" style="width: 100%; float: right;">
                        <article>
                            <h2 style="color: #cf8a05; font-family: 'Rokkitt', Helvetica, Arial, sans-serif; font-style: italic; font-size: 1.5em;">
                                Hasil MSAI
                            </h2>
                            <p class="subDetails">&nbsp;</p>
                            <!-- <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec ultricies massa et erat luctus hendrerit. Curabitur non consequat enim. Vestibulum bibendum mattis dignissim. Proin id sapien quis libero interdum porttitor.</p> -->

                            <table id="table-msai" class="table table-striped table-bordered table-hover">
                                <thead>
                                    <tr>
                                        <th class="all"> Topologi </th>
                                        <th> Deskripsi </th>
                                        <th> Nilai </th>
                                        <th> Total Nilai Topologi </th>
                                    </tr>
                                 </thead>

                                <tbody>

                                    <?php 
                                    if($this->Summary['msai'])
                                        foreach ($this->Summary['msai'] as $key => $value) { ?>

                                    <tr class="odd gradeX">
                                        <td rowspan="3"> <strong> <?= $value['topologi'] ?> </strong> </td>
                                        <td> <?= $value['deskripsi'][0][0] ?> <i class="icon-info" title="<?= $value['deskripsi'][0][1] ?>"></i> </td>
                                        <td> <?= $value['deskripsi'][0][2] ?> </td>
                                        <td rowspan="3"> <?= $value['total'] ?> </td>
                                    </tr>

                                    <?php for ($i = 1 ; $i < count($value['deskripsi']) ; $i++) { ?>

                                    <tr class="odd gradeX">
                                        <td> <?= $value['deskripsi'][$i][0] ?> <i class="icon-info" title="<?= $value['deskripsi'][$i][1] ?>"></i> </td>
                                        <td> <?= $value['deskripsi'][$i][2] ?>  </td>
                                    </tr>

                                    <?php } ?>

                                    <?php } ?>

                                </tbody>
                            </table>    

                            <p class="subDetails">&nbsp;</p>
                            <h2 class="text-center"> Visualisasi Hasil </h2>
                            <p class="subDetails">&nbsp;</p>

                            <div class="text-center">
                                <svg id="graphMsai" style="max-width: 500px"></svg>
                            </div>

                            <p class="subDetails">&nbsp;</p>

                        </article>                        
                    </div>
                    <div class="clear"></div>
                </section>

                <section>                    
                    <div class="sectionContent" style="width: 100%; float: right;">
                        <article>
                            <h2 style="color: #cf8a05; font-family: 'Rokkitt', Helvetica, Arial, sans-serif; font-style: italic; font-size: 1.5em;">
                                Hasil RVS
                            </h2>
                            <p class="subDetails">&nbsp;</p>
                            <!-- <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec ultricies massa et erat luctus hendrerit. Curabitur non consequat enim. Vestibulum bibendum mattis dignissim. Proin id sapien quis libero interdum porttitor.</p> -->

                            <div class="col-md-6 col-xs-12">
                                <b> Nilai RVS Terminal (Dirurtkan dari paling penting) </b>
                                <table id="table-rvs-terminal" class="table table-striped table-bordered table-hover">
                                    <thead>
                                        <tr>
                                            <th class="all"> No </th>
                                            <th class="all"> Kode </th>
                                            <th class="all"> Nilai </th>
                                        </tr>
                                     </thead>

                                    <tbody>

                                        <?php 
                                        if($this->Summary['rvs']['terminal'])
                                            foreach ($this->Summary['rvs']['terminal'] as $key => $value) { ?>

                                        <tr class="odd gradeX">
                                            <td>  <?= ($key + 1) ?>  </td>
                                            <td> <?= $value['kode'] ?> <i class="icon-question" title="<?= $value['deskripsi'] ?>"></i> </td>
                                            <td> <?= $value['nilai'] ?> </td>
                                        </tr>

                                        <?php } ?>

                                    </tbody>
                                </table>                                                                                        
                            </div>

                            <div class="col-md-6 col-xs-12">
                                <b> Nilai RVS Instrumen (Dirurtkan dari paling penting) </b>
                                <table id="table-rvs-terminal" class="table table-striped table-bordered table-hover">
                                    <thead>
                                        <tr>
                                            <th class="all"> No </th>
                                            <th class="all"> Kode </th>
                                            <th class="all"> Nilai </th>
                                        </tr>
                                     </thead>

                                    <tbody>

                                        <?php 
                                        if($this->Summary['rvs']['instrument'])
                                            foreach ($this->Summary['rvs']['instrument'] as $key => $value) { ?>

                                        <tr class="odd gradeX">
                                            <td> <?= ($key + 1) ?>  </td>
                                            <td> <?= $value['kode'] ?> <i class="icon-question" title="<?= $value['deskripsi'] ?>"></i> </td>
                                            <td> <?= $value['nilai'] ?> </td>
                                        </tr>

                                        <?php } ?>

                                    </tbody>
                                </table>                                                                                        
                            </div>
                            
                        </article>                        
                    </div>
                    <div class="clear"></div>
                </section>

<!-- 
                <section>                    
                    <div class="sectionContent" style="width: 100%; float: right;">
                        <article>
                            <h2 style="color: #cf8a05; font-family: 'Rokkitt', Helvetica, Arial, sans-serif; font-style: italic; font-size: 1.5em;">
                                Kesimpulan
                             </h2>
                            <p class="subDetails">&nbsp;</p>
                            <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Donec ultricies massa et erat luctus hendrerit. Curabitur non consequat enim. Vestibulum bibendum mattis dignissim. Proin id sapien quis libero interdum porttitor.</p>
                        </article>                        
                    </div>
                    <div class="clear"></div>
                </section>                
 -->
<!--                 
                <section>
                    <div class="sectionTitle">
                        <h1>Key Skills</h1>
                    </div>
                    
                    <div class="sectionContent">
                        <ul class="keySkills">
                            <li>A Key Skill</li>
                            <li>A Key Skill</li>
                            <li>A Key Skill</li>
                            <li>A Key Skill</li>
                            <li>A Key Skill</li>
                            <li>A Key Skill</li>
                            <li>A Key Skill</li>
                            <li>A Key Skill</li>
                        </ul>
                    </div>
                    <div class="clear"></div>
                </section>                
 -->                

            </div>
        </div>

    </div>
</div>

<script src="/modules/sabos/views/layouts/static/js/snap.svg/snap.svg.min.js" type="text/javascript"></script>
<script src="/modules/sabos/views/layouts/static/js/custom/helper.js" type="text/javascript"></script>
<script type="text/javascript">

    $(document).ready(function () {    

        // for ocai
        var params = new Object;
        params.items = new Array();
        params.items.push({
            line : { color : 'blue', opacity : 0.3, size: 2 },
            point : { color : 'blue', opacity : 0.5, size: 4 },
            value : <?= json_encode($ocai_di) ?>
        });
        params.items.push({
            line : { color : 'red', opacity : 0.3, size: 2 },
            point : { color : 'red', opacity : 0.5, size: 4 },
            value : <?= json_encode($ocai_si) ?>
        });
        quadrantTopologiChart('#graphOcai', 300, params);

        // for msai
        var params = new Object;
        params.arrTopologiName = ['CLAN', 'ADHOCRACY', 'HIERARCHY', 'MARKET'];        
        params.items = new Array();
        params.items.push({
            line : { color : 'blue', opacity : 0.3, size: 2 },
            point : { color : 'blue', opacity : 0.5, size: 4 },
            value : <?= json_encode($msai) ?>
        });
        quadrantTopologiChart('#graphMsai', 300, params);

    });

</script>
