<?php

    $peserta = $this->Peserta;

    $city = $this->City;
    $province = $this->Province;

    $pendidikan = array("SMA","D3","S1","S2","S3");

?>

<style>
    form .form-group .error-message{
        color: red;
    }
</style>


<div class="portlet light bg-inverse">
    <div class="portlet-body form">

        <!-- BEGIN FORM-->

        <form class="horizontal-form" id="form-profile" action="/sabos/default/save-profile">

            <div class="form-body">
                
                <div class="row">
                    <center>                    
                        <div class="mt-element-card mt-card-round mt-element-overlay" style="width: 300px">
                            <div class="mt-card-item" style="border: none;">
                                <div class="mt-card-avatar mt-overlay-4">
                                    <img id="result" src="<?= $peserta->FotoProfil ? $peserta->FotoProfil->path.$peserta->FotoProfil->filename : '/modules/sabos/views/layouts/static/images/placeholder-male.png' ?>" />
                                    <input type="file" class="hidden" id="upload-photo" />
                                    <div class="mt-overlay">
                                        <h2 onclick="$('[type=file]').click()" >
                                            <i class="icon-pencil"></i> 
                                            Change photo
                                        </h2>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </center>
                </div>

                <h3 class="form-section">Data Diri</h3>

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="control-label">Nama Lengkap</label>
                            <input type="hidden" class="form-control" name="Id" value="<?= $peserta->o_id ?>">
                            <input type="text" name="Nama" class="form-control" value="<?= $peserta->Nama ?>"/>
                            <span class="error-message"> </span>
                        </div>
                    </div>
                    <!--/span-->
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="control-label">Jenis Kelamin</label>
                            <select class="form-control" name="JenisKelamin">
                                <option value=""></option>
                                <option value="Pria" <?= $peserta->JenisKelamin == 'Pria' ? 'selected': '' ?> >Pria</option>
                                <option value="Wanita" <?= $peserta->JenisKelamin == 'Wanita' ? 'selected': '' ?> >Wanita</option>
                            </select>
                            <span class="error-message"> </span>
                        </div>
                    </div>
                    <!--/span-->
                </div>
                <!--/row-->

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="control-label">Email</label>
                            <input type="text" name="Email" class="form-control" value="<?= $peserta->Email  ?>" <?= $peserta->Email ? 'readonly' : '' ?> />
                            <span class="error-message"> </span>
                        </div>
                    </div>
                    <!--/span-->
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="control-label">No Telepon</label>
                            <input type="text" name="Telepon" class="form-control" value="<?= $peserta->Telepon ?>" />
                            <span class="error-message"> </span>
                        </div>
                    </div>
                    <!--/span-->
                </div>
                <!--/row-->

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="control-label">Tingkat Pendidikan</label>
                            <select class="form-control" name="TingkatPendidikan" tabindex="1">
                                <option value=""></option>
                        
                                <?php foreach ($pendidikan as $key => $value) { ?>
                                         <option value="<?= $value ?>" <?= $peserta->TingkatPendidikan == $value ? 'selected': '' ?> ><?= $value ?></option>
                                <?php } ?>
                        
                            </select>
                            <span class="error-message"> </span>
                        </div>
                    </div>
                    <!--/span-->
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="control-label">Tanggal Lahir</label>
                            <div class="input-group date date-picker">
                                <input type="text" name="TanggalLahir" value="<?= $peserta->TanggalLahir ? Website_Helper::indonesiaDate(strtotime($data_peserta->TanggalLahir->date), 'd/m/Y') : '' ?>" readonly class="form-control" />
                                <span class="input-group-btn">
                                    <button class="btn default date-set" type="button">
                                        <i class="fa fa-calendar"></i>
                                    </button>
                                </span>
                            </div>
                            <span class="error-message"> </span>
                        </div>
                    </div>
                    <!--/span-->
                </div>
                <!--/row-->

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="control-label">Provinsi</label>
                            <select class="form-control" name="Provinsi" tabindex="1" id="province" onchange="changeProvince();">
                                <option value=""> Pilih Provinsi </option>
                                <?php foreach ($province as $key => $value) { ?>
                                    <option <?= $peserta->Provinsi == $value['Name'] ? "selected" : "" ?> value="<?= $value['Name'] ?>" data-filter="<?= $value['o_id'] ?>"><?= $value['Name'] ?></option>
                                <?php } ?>
                            </select>
                            <span class="error-message"> </span>
                        </div>
                    </div>
                    <!--/span-->

                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="control-label">Kota</label>
                            <select class="form-control" name="Kota" tabindex="1" id="city">
                               <option value=""> Pilih Kota </option>
                                <?php foreach ($city as $key => $value) { ?>
                                    <option <?= $peserta->Kota == $value['Name'] ? "selected" : "" ?> value="<?= $value['Name'] ?>" class="hide" data-filter="<?= $value['Province__id'] ?>"><?= $value['Name'] ?></option>
                                <?php } ?>
                            </select>
                            <span class="error-message"> </span>
                        </div>
                    </div>
                    <!--/span-->
                </div>
                <!--/row--> 

                <?php if($peserta->UnitOrganisasi) { ?>

                <h3 class="form-section">Data Organisasi</h3>

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="control-label">Nama Organisasi</label>
                            <input type="text" name="Organisasi" value="<?= $peserta->UnitOrganisasi->Organisasi->Nama ?>" class="form-control" readonly />
                            <span class="error-message"> </span>
                        </div>
                    </div>
                    <!--/span-->
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="control-label">Unit Kerja</label>
                            <input type="text" name="UnitOrganisasi" value="<?= $peserta->UnitOrganisasi->Nama ?>" class="form-control" readonly />
                            <span class="error-message"> </span>
                        </div>
                    </div>
                    <!--/span-->
                </div>
                <!--/row-->

                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="control-label">Jabatan</label>
                            <input type="text" name="Jabatan" value="<?= $peserta->Jabatan ?>"class="form-control" />
                            <span class="error-message"> </span>
                        </div>
                    </div>
                    <!--/span-->
                    <div class="col-md-6">
                        <div class="form-group">
                            <label class="control-label">Nomor Induk Pegawai (NIP)</label>
                            <input type="text" name="Nip" value="<?= $peserta->NIP ?>" class="form-control" />
                            <span class="error-message"> </span>
                        </div>
                    </div>
                    <!--/span-->
                </div>
                <!--/row-->

                <?php } ?>                

            </div>
        </form>

        <?php if($this->flagKuesioner){ ?>

        <!-- user sudah mengisi semua kuesioner --> 
        <div class="form-actions text-center">
            <button type="submit" class="btn blue" onclick="$('#form-profile').submit();">
                <i class="fa fa-check"></i> 
                Simpan
            </button>

            <button type="submit" class="btn blue" onclick="window.location.assign('/sabos/summary');">
                <i class="fa fa-check"></i> 
                Lihat Hasil
            </button>            
        </div>
        <!-- user sudah mengisi semua kuesioner --> 

        <?php } else { ?>

        <!-- user belum mengisi semua kuesioner --> 
        <div class="form-actions text-center">
            <button type="submit" class="btn blue" onclick="$('#form-profile').submit();">
                <i class="fa fa-check"></i> 
                Simpan dan lanjut mengisi kuesioner
            </button>
        </div>
        <!-- user belum mengisi semua kuesioner --> 

        <?php } ?>        

        <!-- END FORM-->

    </div>
</div>

<link href="/modules/sabos/views/layouts/static/assets/global/plugins/bootstrap-datepicker/css/bootstrap-datepicker3.min.css" rel="stylesheet" type="text/css" />
<script src="/modules/sabos/views/layouts/static/assets/global/plugins/bootstrap-datepicker/js/bootstrap-datepicker.min.js" type="text/javascript"></script>
<script type="text/javascript" src="/modules/sabos/views/layouts/static/js/custom/validator.js"></script>

<script type="text/javascript">

    changeProvince(true);
    function changeProvince(auto){
        var city = '#city';
        var province = '#province';
        
        var provinceSelected = $(province).find(":selected").attr('data-filter');

        if(!$(province).val()){
            $(city).val('');
            $(city).attr('disabled', 'disabled');

            return false;
        }
        else{
            $(city).removeAttr('disabled');            
        }

        if(!auto)
            $(city).val('');

        $(city).find("option").attr('class', 'hide');
        $(city).find("[data-filter='" + provinceSelected + "']").attr('class', 'show');
    }

    $(document).ready(function(){

        initValidator();

    });

    function initValidator(){
        var frmvalidator  = new Validator("form-profile");
        
        frmvalidator.EnableOnPageErrorDisplay();
        frmvalidator.EnableMsgsTogether();
        
        frmvalidator.addValidation("Nama", "required", "Nama lengkap harus diisi");
        frmvalidator.addValidation("Nama", "alphanumeric_space", "Nama lengkap hanya boleh diisi alphanumeric dan spasi");

        <?php if(!$peserta->Email){ ?>
        frmvalidator.addValidation("Email", "required", "Email harus diisi1");
        frmvalidator.addValidation("Email", "maxlen=50", "Email max 50 karakter");
        frmvalidator.addValidation("Email", "email", "Email tidak valid");
        <?php } ?>

        frmvalidator.addValidation("JenisKelamin", "required", "Jenis kelamin harus dipilih");

        frmvalidator.addValidation("Telepon", "required", "No telepon harus diisi");
        frmvalidator.addValidation("Telepon", "numeric", "No telepon hanya boleh diisi angka");

        frmvalidator.addValidation("TingkatPendidikan", "required", "Tingkat pendidikan harus dipilih");

        frmvalidator.addValidation("TanggalLahir", "required", "Tanggal lahir harus dipilih");

        <?php if($peserta->UnitOrganisasi) { ?>
        frmvalidator.addValidation("Nip", "numeric", "NIP hanya boleh diisi angka");
        <?php } ?>

        // set callback function after pass all of validation
        frmvalidator.setCallbackFunction('submitForm()');
    }

    function getData(){
        var data = new Object;
        $('#form-profile .form-control').each(function (key, val) {
            data[$(val).attr('name')] = $(val).val();
        });

        return data;
    }

    function submitForm(){
    
        showLoading();
        var data = getData();

        $.ajax({            
            type : 'post',
            url  : '/api/peserta/update',
            data : { 
                Data : getData()
            },
            timeout: 45000,
            success:function(response){
                response = JSON.parse(response);
                if(response.Status){
            
                    <?php if($this->flagKuesioner){ ?>

                    hideLoading();
                    swal("Berhasil menyimpan data", "", "success")

                    <?php } else { ?>

                    window.location.href = '/sabos/kuesioner/rvs';

                    <?php } ?>

                }else{
                    hideLoading();
                    swal(response.Message, "", "error")
                }
            },
            error: function(response){
                hideLoading();
                swal('Terjadi kesalahan koneksi, periksa jaringan Anda', "", "error")
            }
        }); 

    }

    $('.date-picker').datepicker({
        format: 'dd/mm/yyyy',
        isRTL: App.isRTL(),
        pickerPosition: (App.isRTL() ? "bottom-right" : "bottom-left"),
        startView: 2,
        autoclose: true
    });
    
</script>


<!-- for upload image -->
<div class="modal fade" id="crop-modal" role="dialog">
    <div class="modal-dialog" role="document">
        <div class="modal-content">

            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-label="Tutup"><span aria-hidden="true">&times;</span></button>
                <h4 id="title-crop">Pilih / potong bagian gambar</h4>
                <h4 id="title-confirm">Konfirmasi pemilihan gambar</h4>
            </div>

            <div class="modal-body" style="margin: 10px">
                <center>
                    <div id="body-crop">
                        <img id="image-crop" src="" alt="Picture">
                    </div>

                    <div id="body-confirm">
                        <img id="image-confirm" src="" alt="Picture">
                    </div>
                </center>
            </div>

            <div class="modal-button modal-button-crop">

                <center>
                    <div id="button-crop">
                      <button type="button" class="btn btn-cool" data-dismiss="modal">Batal</button>
                      <button type="button" class="btn btn-primary" onclick="confirmProcess()">Pilih</button>
                    </div>

                    <div id="button-confirm">
                      <button type="button" class="btn btn-cool" onclick="cropProcess()">Kembali</button>
                      <button class="btn btn-primary" id="confirm-image">Simpan</a>
                    </div>
                </center>

            </div>
        </div>
    </div>
</div>

<link rel="stylesheet" type="text/css" href="/modules/sabos/views/layouts/static/css/cropper.css">
<script type="text/javascript" src="/modules/sabos/views/layouts/static/js/cropper.js"></script>

<script>

    var globalResult;
    var limitPx = 300;
    var maxWidthPx = 533.333; // max width pixel, for popup modal purpose
    var maxUploadPx = 300; // setting maximum pixel for image upload, image will resize if pixel > thisValue   

    if (window.File && window.FileReader && window.FileList && window.Blob) {
        document.getElementById('upload-photo').addEventListener('change', handleFileSelect, false);
    } else {
        alert('The File APIs are not fully supported in this browser.');
    }

    function handleFileSelect(evt) {
        showLoading();
    
        var files = evt.target.files;
        var id = evt.target.id;

        file = files[0];
        if (files && file) {
            var fileType = file.type;
            if(fileType.indexOf('image/') < 0){
                $('#upload-file').val('');
                hideLoading();
                swal("", "File yang diizinkan hanya file gambar .jpg dan .png", "error");            
                return false;               
            } else {
                $('#upload-file-type').val(fileType);
            }

            var dataimage = "data:" + fileType + ";base64,";
            var reader = new FileReader();

            reader.onload = function(readerEvt) {

                var binaryString = readerEvt.target.result;
                var arrayButton = new Array();

                var base64 = dataimage+btoa(binaryString);

                var image = document.createElement('img');
                image.src = base64;
                
                image.addEventListener('load', function() {
                    
                    var width = image.width;
                    var height = image.height;

                    if(width > height){
                      factorPx = limitPx / height;

                      height = limitPx;
                      width = width * factorPx;
                    } else {
                      factorPx = limitPx / width;
                      
                      width = limitPx;
                      height = height * factorPx;
                    }

                    if(width > maxWidthPx){
                        factorPx = maxWidthPx / width;

                        width = maxWidthPx;
                        height = height * factorPx;
                    }
                    
                    // Resize if window width < current width
                    var windowWidth = window.innerWidth - 100;
                    if(width > windowWidth){
                        factorPx = windowWidth / width;
                      
                        width = windowWidth;
                        height = factorPx * height;                     
                    }

                    var $image = $('#image-crop');

                    if($image.attr('src')){
                        $image.cropper('destroy');
                    }

                    $image.attr('src', dataimage+btoa(binaryString));

                    $('#crop-modal').modal('show');
                    cropProcess();

                    var options = {
                        scalable: false,
                        aspectRatio: 1,
                        minContainerHeight: height+1,
                        minContainerWidth: width+1,
                        minCanvasHeight: height,
                        minCanvasWidth: width,
                        toggleDragModeOnDblclick: false,
                        center: false,
                        zoomOnWheel: false
                    };

                    // Cropper
                    $image.on({
                        'built.cropper': function (e) {
                            $image.cropper('setCropBoxData', {"left":1,"top":1,"width":width,"height":height});                                     
                        }
                    }).cropper(options); 
                    
                    $('#upload-photo').val('');
                    hideLoading();
                    
                });

            };

            reader.readAsBinaryString(file);
        }

        $('#upload-file').val('');
    }

    function cropProcess(){

        $('#title-crop').show(); 
        $('#body-crop').show(); 
        $('#button-crop').show(); 

        $('#title-confirm').hide(); 
        $('#body-confirm').hide(); 
        $('#button-confirm').hide();
         
    }

    function confirmProcess(){
        
        showLoading();

        var image = $('#image-crop').cropper('getCroppedCanvas');
        var width, height;
        if(image.width > maxUploadPx || image.height > maxUploadPx){
            if(image.width > image.height){
                factorPx = maxUploadPx / image.width;
                width = maxUploadPx;
                height = image.height * factorPx;
            } else {
                factorPx = maxUploadPx / image.height;
                height = maxUploadPx;
                width = image.width * factorPx;
            }
        }
        
        var result = $('#image-crop').cropper('getCroppedCanvas', {width: width, height: height});

        if (result) {
            globalResult = result.toDataURL();
            $('#image-confirm').attr('src', globalResult);
        }

        $('#confirm-image').on("click",function(){
            $('#result').attr("src", globalResult);
            $('#crop-modal').modal('hide');

            uploadPhoto();
            $('#confirm-image').unbind();
        });                            
        
        $('#title-crop').hide(); 
        $('#body-crop').hide(); 
        $('#button-crop').hide(); 

        $('#title-confirm').show(); 
        $('#body-confirm').show(); 
        $('#button-confirm').show(); 

        hideLoading();
                            
    }

    function uploadPhoto(){
        
        data = new Object;

        data.Id = '<?= $peserta->o_id ?>';
        data.Foto = $("#result").attr("src");

        $.ajax({            
                type : 'post',
                url  : "/api/peserta/update",
                data : { 
                    Data : data,
                },
                timeout: 45000,
                success:function(response){
                    response = JSON.parse(response);
                    if(response.Status){                        
                        swal({
                              title: "Ganti Foto",
                              text: "Anda berhasil mengganti foto profil",
                              type: "success",
                              confirmButtonText: "Ok",
                              closeOnConfirm: false
                            });                                      
                        hideLoading(); 
                    }else{
                        hideLoading();
                        swal(response.Message, "", "error")
                    }
                },
                error: function(response){
                    hideLoading();
                    swal('Terjadi kesalahan koneksi, periksa jaringan Anda', "", "error")
                }
            });         
         
    }

</script>

