<?php 
    $msai = $this->msai;
    $peserta = $this->User;
?>

<h2 class="font-dark bold uppercase text-center">
    MANAGEMENT (LEADERSHIP) SKILLS ASSESSMENT INSTRUMENT (MSAI)
</h2>

<div class="note note-info m-heading-1 border-green m-bordered caption-desc font-dark"> 
    <p>
        Silahkan baca petunjuk pengerjaan dengan menekan tombol merah di kanan bawah layar Anda    
    </p>
</div>

<div class="tabbable-line">
    
    <ul class="nav nav-tabs ">

        <?php $i = 0; ?>
        <?php foreach ($msai as $key => $value) { ?>

        <li class="li-<?= $value['id'] ?> <?= $i++ == 0 ? 'active' : '' ?> font-dark bold">
            <a href="javascript:void(0)"> <?= $value['nama'] ?> </a>
        </li>

        <?php } ?>        

    </ul>

    <div class="tab-content">

        <?php $i = 0; ?>
        <?php foreach ($msai as $key => $value) { ?>

        <div class="tab-pane parameter <?= $i++ == 0 ? 'active' : '' ?>" id="<?= $value['id'] ?>" data-next="<?= $msai[$key+1]['id'] ?>" data-prev="<?= $msai[$key-1]['id'] ?>">

            <div class="hidden-xs clearfix">

                <div class="col-sm-1 col-xs-1 margin-bottom-10" style="width: 1%; white-space: nowrap;">
                    No 
                </div>
                <div class="col-sm-6 col-xs-11 margin-bottom-10">
                    Pernyataan
                </div>

                <?php if($value['type'] == 'radio') { ?>                        
                <?php foreach ($value['option'] as $k => $v) { ?>

                    <div class="col-sm-1 col-xs-2 margin-bottom-10 text-center">
                        <?= $v[1] ?>
                    </div>

                <?php } ?>        
                <?php } ?>        

            </div>


            <?php foreach ($value['pernyataan'] as $key => $val) { ?>

                <div class="clearfix pernyataan">
                    <div class="col-sm-1 col-xs-1 margin-bottom-10" style="width: 1%; white-space: nowrap;">
                        <span><?= $val[0] ?></span> 
                    </div>
                    <div class="<?= ($value['type'] == 'choice') ? 'col-sm-11' : 'col-sm-6' ?> col-xs-11 margin-bottom-10">
                        <span><?= $val[1] ?></span> 
                    </div>

                    <?php if($value['type'] == 'radio') { ?>                        

                        <div class="col-xs-1 visible-xs-block"> </div>

                        <?php foreach ($value['option'] as $k => $v) { ?>

                        <div class="col-sm-1 col-xs-2 text-center margin-bottom-30">
                            <input type="radio" class="form-control" name="pernyataan-<?= $val[0] ?>" data-pernyataan="<?= $val[1] ?>" value="<?= $v[0] ?>" value-string="<?= $v[1] ?>"> 
                            <span class="visible-xs-block">
                                <?= $v[1] ?>
                            </span>
                        </div>
                
                        <?php } ?>        

                    <?php } ?>        

                    <?php if($value['type'] == 'choice') { ?>                        

        
                        <?php foreach ($val[2] as $k => $v) { ?>

                        <div class="clearfix"></div>
                        <div class="col-sm-1 col-xs-2 margin-bottom-10"">
                            <input type="radio" class="form-control" name="pernyataan-<?= $val[0] ?>" value="<?= $v[0] ?>" data-pernyataan="<?= $val[1] ?>" value-string="<?= $v[1] ?>"> 
                        </div>
                        <span class="col-sm-11 col-xs-10">
                            <?= $v[1] ?>                                
                        </span>                                

                        <?php } ?>        

                    <?php } ?>       

                </div>                         

            <?php } ?>        


            <br /><br />

            <div class="row">
                <div class="col-xs-6 text-center">
                    <button class="btn blue btn-prev">
                        <i class="fa fa-arrow-circle-left"></i> 
                        Sebelumnya
                    </button>
                </div>

                <div class="col-xs-6 text-center">
                    <button class="btn blue btn-next">
                        <i class="fa fa-arrow-circle-right"></i> 
                        Selanjutnya
                    </button>
                </div>
            </div>

        </div>

        <?php } ?>        

    </div>

</div>

<!-- button fixed for help -->
<div class="help-fixed">
    <button class="btn button-help" data-toggle="modal" data-target="#help-modal">
        Petunjuk Pengerjaan 
        <i class="fa fa-question "></i>
    </button>
</div>
<!-- button fixed for help -->

<!-- modal for petunjuk pengerjaan -->
<div id="help-modal" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                <h4 class="modal-title"> Petunjuk Pengerjaan MSAI </h4>
            </div>
            
            <div class="modal-body"> 
                    <p>
                        Gambarkan perilaku anda sebagai seorang pemimpin di UNIT ORGANISASI maupun ORGANISASI/LEMBAGA. 
                    </p>
                    <p>
                        Jawablah pernyataan-pernyataan di bawah ini dengan perilaku yang paling sesuai dengan yang anda tampilkan sehari-hari, bukan dengan perilaku yang anda inginkan. Bila anda tidak yakin, buat perkiraan yang terbaik, jangan mengosongkan suatu jawaban.
                    </p>

                    <strong class="text-center"> Bagian 1</strong>
                    <table>
                        <tr>
                            <td width="30px"> SS </td>
                            <td width="30px"> = </td>
                            <td> Sangat Setuju </td>
                        <tr>
                        <tr>
                            <td> S </td>
                            <td> = </td>
                            <td> Setuju </td>
                        <tr>
                        <tr>
                            <td> R </td>
                            <td> = </td>
                            <td> Rata-rata </td>
                        <tr>
                        <tr>
                            <td> TS </td>
                            <td> = </td>
                            <td> TIdak Setuju </td>
                        <tr>
                        <tr>
                            <td> STS </td>
                            <td> = </td>
                            <td> Sangat Tidak Setuju </td>
                        <tr>
                    </table>

                    <br>

                    <strong class="text-center"> Bagian 2</strong>
                    <span>
                        Untuk pertanyaan 61 – 73 nilailah efektivitas Anda dalam menilai keterampilan-keterampilan manajerial ini. Isilah pada lembar jawaban Anda dengan menggunakan skala penilaian berikut ini:                    
                    </span>
                    <table>
                        <tr>
                            <td width="30px"> SB </td>
                            <td width="30px"> = </td>
                            <td> Sangat Baik </td>
                        <tr>
                        <tr>
                            <td> B </td>
                            <td> = </td>
                            <td> Baik </td>
                        <tr>
                        <tr>
                            <td> C </td>
                            <td> = </td>
                            <td> Cukup </td>
                        <tr>
                        <tr>
                            <td> K </td>
                            <td> = </td>
                            <td> Kurang </td>
                        <tr>
                        <tr>
                            <td> SK </td>
                            <td> = </td>
                            <td> Sangat Kurang </td>
                        <tr>
                    </table>

                    <br>

                    <strong class="text-center"> Bagian 3</strong>
                    <span>
                        Untuk pertanyaan 74 – 75 isilah pada lembar jawaban Anda salah satu dari pilihan yang ada (PILIH HANYA SATU ALTERNATIF JAWABAN)
                    </span>

                    <br><br>

                    <strong class="text-center"> Bagian 4</strong>
                    <span>
                        CATATAN : Skala penilaian berubah untuk pertanyaan 76 – 87. Bacalah dengan hati-hati.
                    </span>
                    <span>
                        Untuk berhasil pada posisi jabatan anda saat ini, seberapa pentingkah keterampilan-keterampilan berikut ini? Isilah pada lembar jawaban Anda dengan menggunakan skala penilaian berikut:                    
                    </span>
                    <table>
                        <tr>
                            <td width="30px"> K </td>
                            <td width="30px"> = </td>
                            <td> Kritikal (Critically Important) </td>
                        <tr>
                        <tr>
                            <td> SP </td>
                            <td> = </td>
                            <td> Sangat penting (Very Important) </td>
                        <tr>
                        <tr>
                            <td> P </td>
                            <td> = </td>
                            <td> Penting (Moderately Important) </td>
                        <tr>
                        <tr>
                            <td> CP </td>
                            <td> = </td>
                            <td> Cukup penting (of Some Importance) </td>
                        <tr>
                        <tr>
                            <td> KP </td>
                            <td> = </td>
                            <td> Kurang penting (Little Importance) </td>
                        <tr>
                    </table>

            </div>
            
            <div class="modal-footer"> 
                <button type="button" data-dismiss="modal" class="btn btn-outline dark">Tutup</button>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- modal for petunjuk pengerjaan -->

<script type="text/javascript">
    
    $(document).ready(function(){

        $(".btn-next").click(function(){
            goNext(this);
        });

        $(".btn-prev").click(function(){
            var prev = $(this).closest('.parameter').attr('data-prev');
            if(prev){
                goTab(prev);
            } else {
                window.location.href = '/sabos/kuesioner/ocai';                              
            }
        });     

        $(".rvs-value").change(function(){
            updateScore(this);
        });

    });

    function goNext(ele){
        var valid = validate(ele);
        if(valid){
            var next = $(ele).closest('.parameter').attr('data-next');
            if(next){
                goTab(next);
            } else {
                submit();
            }
        }
    }

    function goTab(tabId){
        $('.nav li').removeClass('active')
        $('.tab-pane.parameter').removeClass('active')

        $('.li-' + tabId).addClass('active');
        $('#' + tabId).addClass('active')

        $('.go2top').click();
    }

    function validate(ele){
        var error = 0, total = 0;
        var allValue = $(ele).closest('.parameter').find('.pernyataan');

        allValue.each(function (k, v) {

            if(!$(v).find('input:checked').length){
                $(v).find('span').css('color', '#d00');   
                error++;
            } else {
                $(v).find('span').css('color', '');                   
            }

        });

        if(error){
            swal("Anda belum mengisi semua pernyataan", ".Tolong pilih jawaban semua pernyataan yang berwana merah", "error");            
            return false;
        }

        return true;
    }

    function getData(){
        var data = new Object;

        $('.tab-pane.parameter').each(function (kPane, vPane) {
            data[vPane.id] = new Array();
            $(vPane).find('input:checked').each(function (kInput, vInput) {
                var temp = new Object;
                temp['nama'] = $(vInput).attr('name').trim();
                temp['pernyataan'] = $(vInput).attr('data-pernyataan').trim();
                temp['value'] = $(vInput).val().trim();
                temp['valueString'] = $(vInput).attr('value-string').trim();
 
                data[vPane.id].push(temp);
            });
        });
        
        return data;
    }

    function submit(){

        showLoading();

        $.ajax({            
            type : 'post',
            url  : '/api/msai/create',
            data : { 
                Data : getData(),
                idPeserta : "<?= $peserta->o_id ?>"
            },
            timeout: 45000,
            success:function(response){
                response = JSON.parse(response);
                if(response.Status){
                    // if success redirect to resume page
                    window.location.href = '/sabos/thank-you?ok=1';
                }else{
                    hideLoading();
                    swal(response.Message, "", "error")
                }
            },
            error: function(response){
                hideLoading();
                swal('Terjadi kesalahan koneksi, periksa jaringan Anda', "", "error")
            }
        }); 

    }

</script>
