<?php 
	$parameters = $this->parameter;
	$peserta = $this->User;
?>

<h2 class="font-dark bold uppercase text-center">
    ORGANIZATIONAL CULTURE ASSESSMENT INSTRUMENT (OCAI)
</h2>

<div class="note note-info m-heading-1 border-green m-bordered caption-desc font-dark"> 
    <p>
        Silahkan baca petunjuk pengerjaan dengan menekan tombol merah di kanan bawah layar Anda    
    </p>
</div>

<div class="tabbable-line">
    
    <ul class="nav nav-tabs ">

    	<?php $i = 0; ?>
        <?php foreach ($this->parameter as $key => $parameter) { ?>

        <li class="li-<?= $parameter['id'] ?> <?= $i++ == 0 ? 'active' : '' ?> font-dark bold">
            <!-- <a href="#<?= $parameter['id'] ?>" data-toggle="tab"> <?= $parameter['nama'] ?> </a> -->
            <a href="javascript:void(0)" class="hidden-xs hidden-sm hidden-md "> <?= $parameter['nama'] ?> </a>
            <a href="javascript:void(0)" class="hidden-lg" title="<?= $parameter['nama'] ?>"> P <?= ($key+1) ?> </a>
        </li>

        <?php } ?>        

    </ul>

    <div class="tab-content ocai">

    	<?php $i = 0; ?>
        <?php foreach ($parameters as $key => $parameter) { ?>

        <div class="tab-pane parameter <?= $i++ == 0 ? 'active' : '' ?>" id="<?= $parameter['id'] ?>" data-next="<?= $parameters[$key+1]['id'] ?>" data-prev="<?= $parameters[$key-1]['id'] ?>">

	        <div class="wrap-table" style="overflow-x: scroll;">

			    <table class="table table-bordered table-hover">

			        <thead class="font-dark bold uppercase">
			            <tr>
			                <th rowspan="2" class="text-center" width="1%"> #<?= $key + 1 ?> </th>
			                <th rowspan="2" class="text-center hidden-xs" width="50%"> Pernyataan <?= $parameter['nama'] ?> </th>
			                <th colspan="2" class="text-center"> Unit Organisasi </th>
			                <th colspan="2" class="text-center"> Organisasi / Lembaga </th>
			            </tr>
			            <tr>
			                <th class="text-center" style="font-size: 11px"> Saat ini </th>
			                <th class="text-center" style="font-size: 11px"> Yang diinginkan </th>
			                <th class="text-center" style="font-size: 11px"> Saat ini </th>
			                <th class="text-center" style="font-size: 11px"> Yang diinginkan </th>
			            </tr>
			        </thead>

			        <tbody>

				        <?php foreach ($parameter['pernyataan'] as $pernyataanKey => $pernyataan) { ?>

			            <tr class="pernyataan" data-id="<?= $pernyataanKey ?>">
			                <td class="bold"> <?= $pernyataanKey ?> </td>
			                <td class="text font-dark bold hidden-xs"> 
			                	<?= $pernyataan ?> 
			                </td>
			                <td class="font-dark bold" style="min-width: 70px"> 
			                	<input type="text" class="form-control uk-si value-ocai" data-label="uk-si" value="0" data-mask="099" readonly attr-level1="Unit Organisasi" attr-level2="Saat Ini"  />  
			                </td>
			                <td class="font-dark bold" style="min-width: 70px"> 
			                	<input type="text" class="form-control uk-di value-ocai" data-label="uk-di" value="0" data-mask="099" readonly attr-level1="Unit Organisasi" attr-level2="Yang Diinginkan" />  
			                </td>
			                <td class="font-dark bold" style="min-width: 70px"> 
			                	<input type="text" class="form-control klh-si value-ocai" data-label="klh-si" value="0" data-mask="099" readonly attr-level1="Organisasi/Lembaga" attr-level2="Saat Ini" />  
			                </td>
			                <td class="font-dark bold" style="min-width: 70px"> 
			                	<input type="text" class="form-control klh-di value-ocai" data-label="klh-di" value="0" data-mask="099" readonly attr-level1="Organisasi/Lembaga" attr-level2="Yang Diinginkan" />  
			                </td>
			            </tr>

				        <?php } ?>        

			            <tr>
			                <td class="hidden-xs"> </td>
			                <td class="text-right bold"> 
			                	Total
			                </td>
			                <td class="text-center bold"> 
			                	<div class="total-uk-si"> 0 </div>
			                </td>
			                <td class="text-center bold"> 
			                	<div class="total-uk-di"> 0 </div>
			                </td>
			                <td class="text-center bold"> 
			                	<div class="total-klh-si"> 0 </div>
			                </td>
			                <td class="text-center bold"> 
			                	<div class="total-klh-di"> 0 </div>
			                </td>
			            </tr>

			        </tbody>
			    </table>        	

		   	</div>

		    <br /><br />

            <div class="row">
                <div class="col-xs-6 text-center">
                    <button class="btn blue btn-prev">
                        <i class="fa fa-arrow-circle-left"></i> 
                        Sebelumnya
                    </button>
                </div>

                <div class="col-xs-6 text-center">
                    <button class="btn blue btn-next">
                        <i class="fa fa-arrow-circle-right"></i> 
                        Selanjutnya
                    </button>
                </div>
            </div>

        </div>

        <?php } ?>        

    </div>

</div>

<!-- button fixed for help -->
<div class="help-fixed">
    <button class="btn button-help" data-toggle="modal" data-target="#help-modal">
        Petunjuk Pengerjaan 
        <i class="fa fa-question "></i>
    </button>
</div>
<!-- button fixed for help -->

<!-- modal for petunjuk pengerjaan -->
<div id="help-modal" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                <h4 class="modal-title"> Petunjuk Pengerjaan OCAI </h4>
            </div>
            
            <div class="modal-body"> 

				<strong> Kuesioner kedua adalah OCAI, yang terdiri dari 6 pernyataan, yang harus dijawab dengan cara: </strong>

				<br><br>

				<p>
					Mengalokasikan sejumlah nilai kepada 4 (empat) pernyataan yang dianggap mewakili kondisi UNIT ORGANISASI dan ORGANISASI/LEMBAGA saat ini, dengan total nilai masing-masing 100, serta kondisi UNIT ORGANISASI dan ORGANISASI/LEMBAGA yang diinginkan, juga dengan total nilai masing-masing 100 (ipsative scale).
				</p>

				<p>
					Isi nilai/poin (0/10/20/30/40/50/60/70/80/90) pada lembar jawaban untuk setiap pernyataan sehingga total poin untuk pernyataan A+B+C+D adalah sama dengan 100. Besarnya nilai/poin didasarkan pada situasi/kondisi yang menurut Anda paling sesuai di UNIT ORGANISASI.
				</p>

				<p>
					Cara pengisian yang seperti ini juga berlaku untuk pernyataan A, B, C dan D, berdasarkan situasi/kondisi yang paling Anda inginkan ada di ORGANISASI/LEMBAGA            
				</p>

				<p>
					Hal ini menyatakan bahwa menurut Anda, saat ini UNIT ORGANISASI lebih merupakan Organisasi yang bersifat sangat personal, seperti dalam keluarga besar, dan sama sekali bukan tempat yang terkendali dan terpola (structured).
				</p>

				<p>
					Setelah anda menyelesaikan kolom “SAAT INI” yang menggambarkan situasi/kondisi UNIT ORGANISASI “SAAT INI”, silahkan mengisi kolom “YANG DIINGINKAN” untuk menggambarkan situasi/kondisi UNIT ORGANISASI “YANG DIINGINKAN”. Jangan mengosongkan kolom jawaban, isilah dengan angka di setiap kolom pada lembar jawaban, meskipun angkanya 0.
				</p>

				<p>
					Hal yang sama berlaku pula, saat anda menilai untuk kondisi ORGANISASI/LEMBAGA. Isilah kolom “SAAT INI” yang menggambarkan situasi/kondisi ORGANISASI/LEMBAGA “SAAT INI”, kemudian isilah kolom “YANG DIINGINKAN” untuk menggambarkan situasi/kondisi ORGANISASI/LEMBAGA “YANG DIINGINKAN”. Jangan mengosongkan kolom jawaban, isilah dengan angka di setiap kolom pada lembar jawaban, meskipun angkanya 0.				
				</p>

            </div>
            
            <div class="modal-footer"> 
                <button type="button" data-dismiss="modal" class="btn btn-outline dark">Tutup</button>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- modal for petunjuk pengerjaan -->

<!-- modal for pilih nilai pernyataan -->
<div id="choose-value-modal" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                <h4 class="modal-title"> Pilih Nilai Pernyataan </h4>
            </div>
            
            <div class="modal-body text-center"> 

				<strong class="code"></strong>
				<br>
				<strong class="level1"></strong>
				<br>
				<strong class="level2"></strong>
				<br>
				<p class="pernyataan"></p>

				<div class="range-slider">
				    <input type="text" class="js-range-slider" value="" />
				    
				    <div class="row" style="margin-top: 10px">
				    	<div class="col-xs-6 text-left">
						    <button class="btn btn-outline red minus js-btn-minus"> 
						    	<i class="fa fa-minus"></i> 
					    	</button>
					    </div>
				    	<div class="col-xs-6 text-right">						
						    <button class="btn btn-outline red plus js-btn-plus">
						    	<i class="fa fa-plus"></i> 
					    	</button>
					    </div>
					</div>
				</div>

				<br>				
				<Strong class="">
					Catatan: 
				</Strong>
				<br>
				<strong>A + B + C + D = Harus 100</strong>

            </div>
            
            <div class="modal-footer"> 
                <button type="button" data-dismiss="modal" class="btn btn-outline dark">Batal</button>
                <button type="button" class="btn red btn-choose-value">Pilih</button>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- modal for pilih nilai pernyataan -->

<script type="text/javascript">

	var sliderInstance;
	
	$(document).ready(function(){

	    $(".btn-next").click(function(){
	    	goNext(this);
	    });

	    $(".btn-prev").click(function(){
			var prev = $(this).closest('.parameter').attr('data-prev');
			if(prev){
		    	goTab(prev);
			} else {
                window.location.href = '/sabos/kuesioner/rvs';				
			}
	    });	    

	    $(".value-ocai").click(function(){
	    	var $thisInput = $(this);

	    	$('#choose-value-modal .level1').html($thisInput.attr('attr-level1'));
	    	$('#choose-value-modal .level2').html($thisInput.attr('attr-level2'));
	    	$('#choose-value-modal .code').html($thisInput.closest('tr').find('td').eq(0).html().trim());
	    	$('#choose-value-modal .pernyataan').html($thisInput.closest('tr').find('td').eq(1).html().trim());

	    	$('#choose-value-modal .btn-choose-value').unbind("click").click(function(){
	    		$thisInput.val(sliderInstance.old_from);
	    		updateScore($thisInput);
	    		$('#choose-value-modal').modal('hide');
	    	});

			var parameter = $thisInput.closest('.parameter');
			var inputs = parameter.find('.' + $thisInput.attr('data-label'));

			var total = 0;
			inputs.each(function (k, v) {
				var value = v.value ? v.value : 0;
				total += parseInt(value);
			});

			var subsVal = total - $thisInput.val();

	    	sliderInstance.update({
			    min: 0,
			    max: (100 - subsVal),
			    step: 1,
			    from: $thisInput.val()
	    	});

	    	$('#choose-value-modal').modal('show');	    	

	    });	    

		$(".js-range-slider").ionRangeSlider({
		    min: 0,
		    max: 100,
		    step: 1,
		    from: 0
		});

		sliderInstance = $(".js-range-slider").data("ionRangeSlider");
	
		$(".js-btn-minus").on("click", function () {
		    updateRange(-5);
		});

		$(".js-btn-plus").on("click", function () {
		    updateRange(5);
		});

		var updateRange = function (direction) {
		    sliderInstance.update({
		        from: sliderInstance.old_from + direction
		    });
		};	    

	});

	function goNext(ele){
		var next = $(ele).closest('.parameter').attr('data-next');
		if(next){

			var valid = validate(ele);
			if(valid){
		    	goTab(next);
			}

		} else {
			submit();
		}
	}

	function goTab(tabId){
		$('.nav li').removeClass('active')
		$('.tab-pane.parameter').removeClass('active')

		$('.li-' + tabId).addClass('active');
		$('#' + tabId).addClass('active')

        $('.go2top').click();
	}

	function updateScore(ele){

		if(!$(ele).val()){
			$(ele).val('0');
		}

		var parameter = $(ele).closest('.parameter');
		var inputs = parameter.find('.' + $(ele).attr('data-label'));

		var total = 0;
		inputs.each(function (k, v) {
			var value = v.value ? v.value : 0;
			total += parseInt(value);
		});

		parameter.find('.total-' + $(ele).attr('data-label')).html(total);

	}

	function validate(ele){
		var parameter = $(ele).closest('.parameter');

		var ukSi = parameter.find('.total-uk-si');
		var ukDi = parameter.find('.total-uk-di');
		var klhSi = parameter.find('.total-klh-si');
		var klhDi = parameter.find('.total-klh-di');

		var valid = true;
		
		validUkSi = checkValid(ukSi, 'Total nilai harus 100', 'bottom');
		validUkDi = checkValid(ukDi, 'Total nilai harus 100', 'bottom');
		validKlhSi = checkValid(klhSi, 'Total nilai harus 100', 'bottom');
		validKlhDi = checkValid(klhDi, 'Total nilai harus 100', 'bottom');

		return (validUkDi && validUkSi && validKlhDi && validKlhSi);
	}

	function checkValid(ele, title, placement){
		var valid;
		if(ele.html() != 100){
			ele.css('color', 'red');
			ele.tooltip({
			        title: title,
			        trigger: 'manual',
			        placement : placement,
			        template: '<div class="tooltip" role="tooltip" style="font-weight: 800"><div class="tooltip-arrow" style="border-bottom-color: #f33"></div><div class="tooltip-inner" style="max-width: 100px; background-color: #f33"></div></div>'
			    }).tooltip('show');

			valid = false;
		} else {
			ele.css('color', '');
			ele.tooltip('destroy');

			valid = true;
		}

		return valid;
	}

	function getData(){
		var data = new Object;
		
		$('.ocai .parameter').each(function (key, parameter) {

			var id = this.id; 
			data[id] = new Object;

			$(parameter).find('.pernyataan').each(function(k, pernyataan){
				var classes = $(this).attr('data-id');

				data[id][classes] = new Object;
				data[id][classes]['pernyataan'] = $(this).find(".text").html().trim();
				data[id][classes]['uk-si'] = $(this).find(".uk-si").val()
				data[id][classes]['uk-di'] = $(this).find(".uk-di").val();
				data[id][classes]['klh-si'] = $(this).find(".klh-si").val();
				data[id][classes]['klh-di'] = $(this).find(".klh-di").val();
			});

		});

		return data;
	}

	function submit(){

		showLoading();

		$.ajax({            
            type : 'post',
            url  : '/api/ocai/create',
            data : { 
            	Data : getData(),
            	idPeserta : "<?= $peserta->o_id ?>"
            },
            timeout: 45000,
            success:function(response){
            	response = JSON.parse(response);
                if(response.Status){
                    window.location.href = '/sabos/kuesioner/msai';
                }else{
                    hideLoading();
	                swal(response.Message, "", "error")
                }
            },
            error: function(response){
                hideLoading();
                swal('Terjadi kesalahan koneksi, periksa jaringan Anda', "", "error")
            }
        }); 

	}

</script>
