<?php 
    $allRvs = $this->rvs;
    $peserta = $this->User;

?>

<h2 class="font-dark bold uppercase text-center">
    ROKEACH VALUE SURVEY (RVS)
</h2>

<div class="note note-info m-heading-1 border-green m-bordered caption-desc font-dark"> 
    <p>
        Silahkan baca petunjuk pengerjaan dengan menekan tombol merah di kanan bawah layar Anda    
    </p>
</div>

<div class="tabbable-line">
    
    <ul class="nav nav-tabs ">

        <?php $i = 0; ?>
        <?php foreach ($allRvs as $key => $rvs) { ?>

        <li class="li-<?= $rvs['id'] ?> <?= $i++ == 0 ? 'active' : '' ?> font-dark bold">
            <a href="javascript:void(0)"> <?= $rvs['nama'] ?> </a>
        </li>

        <?php } ?>        

    </ul>

    <div class="tab-content rvs">

        <?php $i = 0; ?>
        <?php foreach ($allRvs as $key => $rvs) { ?>

        <div class="tab-pane parameter <?= $i++ == 0 ? 'active' : '' ?>" id="<?= $rvs['id'] ?>" data-next="<?= $allRvs[$key+1]['id'] ?>" data-prev="<?= $allRvs[$key-1]['id'] ?>">


            <table class="display table-rsv" style="width:100%">
                <thead>
                    <tr>
                        <th style="width: 30px; text-align: center;">Nilai</th>
                        <th>Pernyataan</th>
                        <th class="hide">Kode</th>
                    </tr>
                </thead>
                <tbody>

                    <?php foreach ($rvs['data'] as $pernyataanKey => $pernyataan) { ?>

                    <tr>
                        <td style="width: 30px; text-align: center;"><?= $pernyataanKey+1 ?></td>
                        <td><?= $pernyataan[1] ?></td>
                        <td class="hide"><?= $pernyataan[0] ?></td>
                     </tr>            

                    <?php } ?>        

                </tbody>
            </table>

            <br /><br />

            <div class="row">
                <div class="col-xs-6 text-center">
                    <button class="btn blue btn-prev">
                        <i class="fa fa-arrow-circle-left"></i> 
                        Sebelumnya
                    </button>
                </div>

                <div class="col-xs-6 text-center">
                    <button class="btn blue btn-next">
                        <i class="fa fa-arrow-circle-right"></i> 
                        Selanjutnya
                    </button>
                </div>
            </div>

        </div>

        <?php } ?>        

    </div>

</div>

<!-- button fixed for help -->
<div class="help-fixed">
    <button class="btn button-help" data-toggle="modal" data-target="#help-modal">
        Petunjuk Pengerjaan 
        <i class="fa fa-question "></i>
    </button>
</div>
<!-- button fixed for help -->

<!-- modal for petunjuk pengerjaan -->
<div id="help-modal" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                <h4 class="modal-title"> Petunjuk Pengerjaan RVS </h4>
            </div>
            
            <div class="modal-body"> 
                <p>
                    Apakah tujuan hidup yang ingin Anda capai dengan bekerja di ORGANISASI/LEMBAGA ini?
                </p>

                <strong class="text-center"> Bagian 1 (Nilai Terminal) </strong>
                <span>
                    Mengurutkan 18 nilai-nilai terminal (akhir) dari yang paling penting (PALING BERNILAI) sampai dengan yang kurang penting (PALING KURANG BERNILAI). Nilai terminal adalah keadaan akhir eksistensi yang sangat diinginkan/tujuan yang ingin dicapai seseorang selama hayatnya.
                </span>

                <br><br>

                <strong class="text-center"> Bagian 2 (Nilai Instrumental) </strong>
                <span>
                    Mengurutkan 18 nilai-nilai instrumental (alat) untuk meraih nilai-nilai (tujuan) akhir tersebut. Nilai-nilai instrumental merujuk ke modus perilaku yang lebih disukai, atau cara untuk mencapai nilai-nilai terminal
                </span>                           
            </div>
            
            <div class="modal-footer"> 
                <button type="button" data-dismiss="modal" class="btn btn-outline dark">Tutup</button>
            </div>
        </div>
        <!-- /.modal-content -->
    </div>
    <!-- /.modal-dialog -->
</div>
<!-- modal for petunjuk pengerjaan -->

<script type="text/javascript">
    
    $(document).ready(function(){

        var table = $('.table-rsv').DataTable( {
            "searching": false,
            "paging": false,
            "ordering": true,
            "info": false,
            "rowReorder": true,
            "columnDefs": [
                {
                    "targets": [ 1 ],
                    "orderable": false,
                }
            ]            
        } );

        $(".btn-next").click(function(){
            goNext(this);
        });

        $(".btn-prev").click(function(){
            var prev = $(this).closest('.parameter').attr('data-prev');
            if(prev){
                goTab(prev);
            } else {
                window.location.assign('/sabos/update-profile');
            }
        });     

    });

    function goNext(ele){
        var next = $(ele).closest('.parameter').attr('data-next');
        if(next){
            goTab(next);
        } else {
            submit();
        }
    }

    function goTab(tabId){
        $('.nav li').removeClass('active')
        $('.tab-pane.parameter').removeClass('active')

        $('.li-' + tabId).addClass('active');
        $('#' + tabId).addClass('active')

        $('.go2top').click();
    }

    function getData(){
        var data = new Object;

        $('.tab-pane.parameter').each(function (kPane, vPane) {
            data[vPane.id] = new Array();
            $(vPane).find('.table-rsv tbody tr').each(function (kInput, vInput) {
                var temp = new Object;
                temp['nama'] = $(vInput).find('td').last().html();
                temp['pernyataan'] = $(vInput).find('td').first().next().html();
                temp['value'] = $(vInput).find('td').first().html();
 
                data[vPane.id].push(temp);
            });
        });
        
        return data;
    }

    function submit(){

        showLoading();
        $.ajax({            
            type : 'post',
            url  : '/api/rvs/create',
            data : { 
                Data : getData(),
                idPeserta : "<?= $peserta->o_id ?>"
            },
            timeout: 45000,
            success:function(response){
                response = JSON.parse(response);
                if(response.Status){
                    window.location.href = '/sabos/kuesioner/ocai';
                }else{
                    hideLoading();
                    swal(response.Message, "", "error")
                }
            },
            error: function(response){
                hideLoading();
                swal('Terjadi kesalahan koneksi, periksa jaringan Anda', "", "error")
            }
        }); 

    }

</script>
