<?php

    $data_organisasi = $this->DataOrganisasi;

?>    
    <div class="mt-element-card mt-card-round mt-element-overlay" style="margin: 20px">

        <div class="row">
            <div class="col-sm-9">
                <div class="form-group form-md-line-input form-md-floating-label">
                    <div class="input-icon">
                        <input type="text" class="form-control" onkeyup="search(this.value);">
                        <label for="form_control_1">Cari organisasi </label>
                        <i class="fa fa-search"></i>
                    </div>
                </div>
            </div>
            <div class="col-sm-3">
                <div class="form-group form-md-line-input form-md-floating-label pull-right">
                    <button class="btn blue btn-next" onclick="confirmManageData()">
                        <i class="fa fa-database"></i> 
                        Manajemen Data
                    </button>
                </div>
            </div>            
        </div>      

        <div class="row" id="list_organisasi">
            <?php foreach ($data_organisasi as $key => $organisasi) { ?>
                
                    <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12" style="padding: 10px;">
                        <a href="/sabos/organisasi/unit-kerja?id=<?= $organisasi['o_id'] ?>" style="text-decoration: none; color: inherit;">
                            <div style="padding: 10px; margin-bottom: 10px; background: #eee;">
                                <img src="<?= $organisasi['Logo'] ? $organisasi['Logo'] : '/modules/sabos/views/layouts/static/images/placeholder-logo.png'  ?>" alt="" class="pull-right" style="width: 80px;">
                                <h3><?= $organisasi['Nama']?></h3>
                                <p> 
                                    Total Peserta : <?= $organisasi['Peserta'] ?>
                                    <br>
                                    Jumlah Unit Organisasi : <?= $organisasi['UnitKerja'] ?>
                                </p>
                            </div>
                        </a>
                    </div>

            <?php } ?>
        </div>

    </div>

    <script type="text/javascript">
        
        function confirmManageData(){
            bootbox.dialog({
                message: "Apakah Anda yakin ingin melakukan manajemen data organisasi? <br /><br />Manajement data meliputi <b> menambah, mengubah dan menghapus </b> data Organisasi. <br /><b>Berhati-hatilah</b> dalam melakukan manajemen data.",
                title: "Informasi Penting",
                buttons: {
                    success: {
                        label: "Ya",
                        className: "green",
                        callback: function() {
                            window.location.href = '/sabos/organisasi/manajemen-data';
                        }
                    },
                    danger: {
                        label: "Tidak",
                        className: "red",
                    }
                }
            });
        }

        function search(value){

            $.ajax({            
                type : 'post',
                url  : '/api/organisasi/search',
                data : { 
                    Search : value 
                },
                timeout: 45000,
                success:function(response){
                    response = JSON.parse(response);
                    var html="";
                    if(response.Status){
                        $.each( response.Data, function( key, value ) {
                            response.Data.Logo = value.Logo ? value.Logo : '/modules/sabos/views/layouts/static/images/placeholder-logo.png';
                            html += '<div class="col-lg-3 col-md-4 col-sm-6 col-xs-12" style="padding: 10px;">'+
                                        '<a href="/sabos/organisasi/detail?id='+value.o_id+'" style="text-decoration: none; color: inherit;">'+
                                            '<div style="padding: 10px; margin-bottom: 10px; background: #eee;">'+
                                                '<img src="'+value.Logo+'" alt="" class="pull-right" style="width: 80px;">'+
                                                '<h3>'+value.Nama+'</h3>'+
                                                '<p>'+ 
                                                    'Total Peserta : '+value.Peserta+
                                                    '<br>'+
                                                    'Jumlah Unit Organisasi : '+value.UnitKerja+
                                                '</p>'+
                                            '</div>'+
                                        '</a>'+
                                      '</div>';
                        });
                        $("#list_organisasi").html(html);

                    }else{
                        hideLoading();
                        swal(response.Message, "", "error")
                    }
                },
                error: function(response){
                    hideLoading();
                    swal('Terjadi kesalahan koneksi, periksa jaringan Anda', "", "error")
                }
            }); 
        }
        
    </script>
