<?php

    $data_organisasi = $this->DataOrganisasi;
    $summary = $this->Summary;

    $ocai_di = [];
    $ocai_si = [];
    
    foreach ($this->Summary[ocai] as $key => $item) {
        array_push($ocai_si, $item['si']);
        array_push($ocai_di, $item['di']);
    }

    $msai = [];
    foreach ($this->Summary[msai] as $key => $item) {
        array_push($msai, $item['total']);
    }    

?>               
        
<div class="page-content-col">
    <!-- BEGIN PAGE BASE CONTENT -->
    <div class="row">
        <div class="col-md-12">

            <?php include("sidebar.php") ?>
            
            <!-- BEGIN PROFILE CONTENT -->
            <div class="profile-content">
                <div class="row">
                    <div class="col-md-12">
                        <div class="portlet light bordered">
                            <div class="portlet-title tabbable-line">
                                <div class="caption caption-md">
                                    <i class="icon-globe theme-font hide"></i>
                                    <span class="caption-subject font-blue-madison bold uppercase">OCAI</span>
                                </div>
                                <ul class="nav nav-tabs" data-tabs="tabs">
                                    <li class="active">
                                        <a href="#tab_1_1" data-toggle="tab">OCAI</a>
                                    </li>
                                    <li class="">
                                        <a href="#tab_1_2" data-toggle="tab">MSAI</a>
                                    </li>
                                    <li class="">
                                        <a href="#tab_1_3" data-toggle="tab">RVS</a>
                                    </li>
                                </ul>
                            </div>
                            <div class="portlet-body">
                                <div class="tab-content">
                                    <div class="tab-pane active" id="tab_1_1">

                                        <h3> <strong> Tabel Hasil </strong> </h3>

                                        <table id="table-ocai" class="table table-striped table-bordered table-hover">
                                            <thead>
                                                <tr>
                                                    <th class="all" rowspan="2"> Topologi </th>
                                                    <th colspan="2"> Saat Ini (Des Sein) </th>
                                                    <th colspan="2"> Diinginkan (Des Solen) </th>
                                                    <th rowspan="2"> Selisih </th>
                                                </tr>
                                                <tr>
                                                    <th> Nilai </th>
                                                    <th> Posisi </th>
                                                    <th> Nilai </th>
                                                    <th> Posisi </th>
                                                </tr>
                                             </thead>

                                            <tbody>

                                                <?php 
                                                if($summary['ocai']) {
                                                    foreach ($summary['ocai'] as $key => $value) { ?>

                                                <tr class="odd gradeX">
                                                    <td> <strong onclick="getListPesonByTopologi('ocai', '<?= $value['topologi'] ?>')"> <?= $value['topologi'] ?> </strong> </td>
                                                    <td> <?= $value['si'] ?> </td>
                                                    <td> (<?= $value['si_posisi'] ?>) </td>
                                                    <td> <?= $value['di'] ?> </td>
                                                    <td> (<?= $value['di_posisi'] ?>) </td>
                                                    <td> <?= $value['selisih_si_di'] ?> </td>
                                                </tr>

                                                <?php }} ?>

                                            </tbody>
                                        </table>

                                        <h3> <strong> Visualisasi Hasil </strong> </h3>

                                        <div class="text-center">
                                            <svg id="graphOcai" style="max-width: 500px"></svg>
                                        </div>

                                        <br /><br />                                            

                                    </div>

                                    <div class="tab-pane" id="tab_1_2">

                                        <h3> <strong> Tabel Hasil </strong> </h3>

                                        <table id="table-msai" class="table table-striped table-bordered table-hover">
                                            <thead>
                                                <tr>
                                                    <th class="all"> Topologi </th>
                                                    <th> Deskripsi </th>
                                                    <th> Nilai </th>
                                                    <th> Total Nilai Topologi </th>
                                                </tr>
                                             </thead>

                                            <tbody>

                                                <?php 
                                                if($summary['msai']) {
                                                    foreach ($summary['msai'] as $key => $value) { ?>

                                                <tr class="odd gradeX">
                                                    <td rowspan="3"> <strong onclick="getListPesonByTopologi('msai', '<?= $value['topologi'] ?>')"> <?= $value['topologi'] ?> </strong> </td>
                                                    <td> <?= $value['deskripsi'][0][0] ?> <i class="icon-info" title="<?= $value['deskripsi'][0][1] ?>"></i> </td>
                                                    <td> <?= $value['deskripsi'][0][2] ?> </td>
                                                    <td rowspan="3"> <?= $value['total'] ?> </td>
                                                </tr>

                                                <?php for ($i = 1 ; $i < count($value['deskripsi']) ; $i++) { ?>

                                                <tr class="odd gradeX">
                                                    <td> <?= $value['deskripsi'][$i][0] ?> <i class="icon-info" title="<?= $value['deskripsi'][$i][1] ?>"></i> </td>
                                                    <td> <?= $value['deskripsi'][$i][2] ?>  </td>
                                                </tr>

                                                <?php } ?>

                                                <?php }} ?>

                                            </tbody>
                                        </table>                                        

                                       <h3> <strong> Visualisasi Hasil </strong> </h3>

                                        <div class="text-center">
                                            <svg id="graphMsai" style="max-width: 500px"></svg>
                                        </div>

                                        <br /><br />                                            

                                    </div>

                                    <div class="tab-pane" id="tab_1_3">

                                        <div class="col-md-6 col-xs-12">
                                            <b> Nilai RVS Terminal (Dirurtkan dari paling penting) </b>
                                            <table id="table-rvs-terminal" class="table table-striped table-bordered table-hover">
                                                <thead>
                                                    <tr>
                                                        <th class="all"> No </th>
                                                        <th class="all"> Kode </th>
                                                        <th class="all"> Nilai </th>
                                                    </tr>
                                                 </thead>

                                                <tbody>

                                                    <?php 
                                                    if($summary['rvs']['terminal']) {
                                                        foreach ($summary['rvs']['terminal'] as $key => $value) { ?>

                                                    <tr class="odd gradeX">
                                                        <td>  <?= ($key + 1) ?>  </td>
                                                        <td> <?= $value['kode'] ?> <i class="icon-question" title="<?= $value['deskripsi'] ?>"></i> </td>
                                                        <td> <?= $value['nilai'] ?> </td>
                                                    </tr>

                                                    <?php }} ?>

                                                </tbody>
                                            </table>                                                                                        
                                        </div>

                                        <div class="col-md-6 col-xs-12">
                                            <b> Nilai RVS Instrumen (Dirurtkan dari paling penting) </b>
                                            <table id="table-rvs-terminal" class="table table-striped table-bordered table-hover">
                                                <thead>
                                                    <tr>
                                                        <th class="all"> No </th>
                                                        <th class="all"> Kode </th>
                                                        <th class="all"> Nilai </th>
                                                    </tr>
                                                 </thead>

                                                <tbody>

                                                    <?php 
                                                    if($summary['rvs']['instrument']){
                                                        foreach ($this->Summary['rvs']['instrument'] as $key => $value) { ?>

                                                    <tr class="odd gradeX">
                                                        <td> <?= ($key + 1) ?>  </td>
                                                        <td> <?= $value['kode'] ?> <i class="icon-question" title="<?= $value['deskripsi'] ?>"></i> </td>
                                                        <td> <?= $value['nilai'] ?> </td>
                                                    </tr>

                                                    <?php }} ?>

                                                </tbody>
                                            </table>                                                                                        
                                        </div>

                                        <div style="clear: both;"></div>

                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <!-- END PROFILE CONTENT -->
        </div>
    </div>
    <!-- END PAGE BASE CONTENT -->
</div>

<script src="/modules/sabos/views/layouts/static/js/snap.svg/snap.svg.min.js" type="text/javascript"></script>
<script src="/modules/sabos/views/layouts/static/js/custom/helper.js" type="text/javascript"></script>
<script type="text/javascript">

    $(document).ready(function(){

        /* custom chart */
        // for ocai
        var params = new Object;
        params.items = new Array();
        params.items.push({
            line : { color : 'blue', opacity : 0.3, size: 2 },
            point : { color : 'blue', opacity : 0.5, size: 4 },
            value : <?= json_encode($ocai_di) ?>,
            clickFunction : [
                "getListPesonByTopologi('ocai', 'CLAN')",
                "getListPesonByTopologi('ocai', 'ADHOCRACY')",
                "getListPesonByTopologi('ocai', 'MARKET')",
                "getListPesonByTopologi('ocai', 'HIERARCHY')"
            ]
        });
        params.items.push({
            line : { color : 'red', opacity : 0.3, size: 2 },
            point : { color : 'red', opacity : 0.5, size: 4 },
            value : <?= json_encode($ocai_si) ?>,
            clickFunction : [
                "getListPesonByTopologi('ocai', 'CLAN')",
                "getListPesonByTopologi('ocai', 'ADHOCRACY')",
                "getListPesonByTopologi('ocai', 'MARKET')",
                "getListPesonByTopologi('ocai', 'HIERARCHY')"
            ]            
        });
        quadrantTopologiChart('#graphOcai', 400, params);

        // for msai
        var params = new Object;
        params.items = new Array();
        params.items.push({
            line : { color : 'blue', opacity : 0.3, size: 2 },
            point : { color : 'blue', opacity : 0.5, size: 4 },
            value : <?= json_encode($msai) ?> ,
            clickFunction : [
                "getListPesonByTopologi('ocai', 'CLAN')",
                "getListPesonByTopologi('ocai', 'ADHOCRACY')",
                "getListPesonByTopologi('ocai', 'MARKET')",
                "getListPesonByTopologi('ocai', 'HIERARCHY')"
            ]            
        });
        quadrantTopologiChart('#graphMsai', 400, params);
        /* custom chart */

    });

    $('.nav.nav-tabs a').click(function () {
        $('.caption-subject').html($(this).html());
    });

    function getListPesonByTopologi(type, topologiName){
        showLoading();
        $.ajax({            
            type : 'post',
            url  : '/api/organisasi/list-peserta-by-topologi',
            data : { 
                Type : type,
                Topologi : topologiName,
                Id : '<?= $data_organisasi[0]['o_id'] ?>'
            },
            timeout: 45000,
            success:function(response){
                response = JSON.parse(response);
                if(response.Status){

                    var html = '';
                    
                    html += '<div class="mt-element-list">';
                    html += '    <b>Telah diurutkan berdasarkan nilai terbesar</b> <hr>';                    
                    html += '    <div class="mt-list-container list-simple" style="padding: 2px">';                    
                    html += '       <ul>';                    

                    $.each(response.Data, function(key, data){
                        
                        html += '<li class="mt-list-item">';
                        html += '    <div class="list-icon-container done">';
                        html += '       ' + (key+1) + '. ' ;
                        html += '    </div>';
                        html += '    <div class="list-item-content">';
                        html += '        <h3 class="uppercase">';
                        html += '            <a href="/sabos/peserta/detail/' + data[0] + '" target="_blank">' + data[1] + '</a>';
                        html += '        </h3>';
                        html += '    </div>';
                        html += '</li>';
                        
                    });

                    html += '       </ul>';
                    html += '   </div>';
                    html += '</div>';

                    showCustomModal('Daftar Peserta ' + topologiName, html);

                }else{
                    swal(response.Message, "", "error")
                }
                hideLoading();
            },
            error: function(response){
                hideLoading();
                swal('Terjadi kesalahan koneksi, periksa jaringan Anda', "", "error")
            }
        });        
    }

</script>
