<?php 

    $data = $this->data;

?>
    
    <style>
        form .form-group .error-message{
            color: red;
        }
    </style>

    <script type="text/javascript" src="/modules/sabos/views/layouts/static/js/custom/validator.js"></script>

    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>
                <span class="caption-subject bold uppercase"> Manajemen Data Organisasi</span>
            </div>
            <div class="tools"> </div>
        </div>
        <div class="portlet-body">
            <div class="table-toolbar">
                <div class="row  text-center">
                    <div class="btn-group">
                        <button class="btn sbold green btn-add"> Tambah Baru
                            <i class="fa fa-plus"></i>
                        </button>
                    </div>
                </div>
            </div>
            <table class="table table-striped table-bordered table-hover">
                <thead>
                    <tr>
                        <th class="all"> Nama </th>
                        <th> email </th>
                        <th> Jumlah Unit Kerja </th>
                        <th> Jumlah Peserta </th>
                        <th class="none"> Alamat </th>
                        <th class="none"> Logo </th>
                        <th class="all">  </th>
                    </tr>
                </thead>
                <tbody>

                <?php foreach($data as $key => $temp) { ?>

                    <tr class="odd gradeX">
                        <td> <?= $temp->Nama ?> </td>
                        <td> <?= $temp->Email ?> </td>
                        <td>
                            <a href="/sabos/unit-organisasi/manajemen-data?organisasi=<?= $temp->o_id ?>" style="text-decoration: none; color: inherit;">
                                <div> <?= $temp->UnitKerja ?> </div>
                            </a>
                        </td>
                        <td> 
                            <a href="/sabos/peserta/manajemen-data?organisasi=<?= $temp->o_id ?>" style="text-decoration: none; color: inherit;">
                                <div> <?= $temp->Peserta ?> </div>
                            </a>
                        </td>
                        <td> <?= $temp->Alamat ?> </td>
                        <td> <img src="<?= $temp->Logo ? $temp->Logo : '/modules/sabos/views/layouts/static/images/placeholder-logo.png'  ?>" alt="" class="text-center" style="width: 80px;"> </td>
                        <td>
                            <div class="btn-group">
                                <button class="btn btn-xs green dropdown-toggle" type="button" data-toggle="dropdown" aria-expanded="false"> <i class="icon-settings"></i>
                                    <i class="fa fa-angle-down"></i>
                                </button>
                                <ul class="dropdown-menu pull-left" role="menu">
                                    <li>
                                        <a href="/sabos/organisasi/unit-kerja?id=<?= $temp->o_id ?>" target="_blank">
                                            <i class="icon-eye"></i> Lihat Detail 
                                        </a>
                                    </li>
                                    <li>
                                        <a href="javascript:void(0)" onclick="editData(<?= $key ?>,<?= $temp->o_id ?>)">
                                            <i class="icon-pencil"></i> Ubah 
                                        </a>
                                    </li>
                                    <li>
                                        <a href="javascript:void(0)" onclick="deleteData(<?= $key ?>,<?= $temp->o_id ?>)">
                                            <i class="icon-fire"></i> Hapus 
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </td>
                    </tr>

                <?php } ?>

                </tbody>
            </table>
        </div>
    </div>

    <div id="modal-form" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-full">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                    <h4 class="modal-title">Modal Title</h4>
                </div>
                <div class="modal-body">
                    <form id="form-data" role="form" class="form-horizontal" onsubmit="return false">
                        <div class="form-body">

                            <div class="form-group ">
                                <label class="col-md-2 control-label">Nama Organisasi</label>
                                <div class="col-md-10">
                                    <input type="hidden" class="form-control" name="Id">
                                    <input type="text" class="form-control" name="Nama" placeholder="Masukan nama organisasi">
                                    <span class="error-message"></span>
                                </div>
                            </div>

                            <div class="form-group ">
                                <label class="col-md-2 control-label"">Email</label>
                                <div class="col-md-10">
                                    <input type="text" class="form-control" name="Email" placeholder="Masukan email">
                                    <span class="error-message"></span>
                                </div>
                            </div>

                            <div class="form-group ">
                                <label class="col-md-2 control-label"">Alamat</label>
                                <div class="col-md-10">
                                    <textarea class="form-control" rows="3" name="Alamat" placeholder="Masukan alamat"></textarea>
                                    <span class="error-message"></span>
                                </div>
                            </div>

                            <div class="form-group form-md-line-input">
                                <label class="col-md-2 control-label">Logo Organisasi</label>
                                <div class="col-md-10">
                                    <img src="/modules/sabos/views/layouts/static/images/placeholder-logo.png" alt="" style="width: 100px;" onclick="$('[type=file]').click()">
                                    <input type="file" class="hidden" id="Logo" name="Logo" accept="image/*" />
                                    <span class="error-message"></span>
                                </div>
                            </div>

                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" data-dismiss="modal" class="btn btn-outline dark">Batal</button>
                    <button type="button" class="btn green" onclick="$('#form-data').submit()">Simpan</button>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>

    <script type="text/javascript">

        var corpus = JSON.parse('<?= json_encode($data) ?>');

        $(document).ready( function() {

            initValidation();

        });

        $('.btn-add').on("click",function(){
            $('#modal-form .modal-title').html('Tambah Data Organisasi');
            $('#form-data .error-message').html('').siblings('.form-control').css('border', ''); // remove style error

            $('#form-data .form-control').val('');
            $('#form-data img').attr('src', '/modules/sabos/views/layouts/static/images/placeholder-logo.png');

            $('#modal-form').modal('show');
        });                            

        function editData(key , Id){
            $('#modal-form .modal-title').html('Ubah Data Organisasi');
            $('#form-data .error-message').html('').siblings('.form-control').css('border', ''); // remove style error

            var data = corpus[key];
            $('#form-data .form-control').each( function(key, element){
                $(this).val(data[$(this).attr('name')]);
            });

            $("input[name='Id']").val(Id);

            if (!data['Logo'])
                data['Logo'] = '/modules/sabos/views/layouts/static/images/placeholder-logo.png';

            $('#form-data img').attr('src', data['Logo']);

            $('#modal-form').modal('show');

        }

        function deleteData(key, Id){
            
            var data = corpus[key];

            bootbox.dialog({
                message: "Apakah Anda yakin menghapus <b>'" + data['Nama'] + "'</b>. <br /><br /><b>Berhati-hatilah</b> dalam menghapus data.",
                title: "Informasi Penting",
                buttons: {
                    success: {
                        label: "Ya",
                        className: "green",
                        callback: function() {
                            showLoading();
                            
                            $.ajax({            
                                type : 'post',
                                url  : "/api/organisasi/delete",
                                data : { 
                                    Id : Id,
                                },
                                timeout: 45000,
                                success:function(response){
                                    response = JSON.parse(response);
                                    if(response.Status){
                                        location.reload();
                                    }else{
                                        hideLoading();
                                        swal(response.Message, "", "error")
                                    }
                                },
                                error: function(response){
                                    hideLoading();
                                    swal('Terjadi kesalahan koneksi, periksa jaringan Anda', "", "error")
                                }
                            });                    

                        }
                    },
                    danger: {
                        label: "Tidak",
                        className: "red",
                    }
                }
            });
        }
        
        function initValidation(){            
            var frmvalidator  = new Validator("form-data");
            
            frmvalidator.EnableOnPageErrorDisplay();
            frmvalidator.EnableMsgsTogether();
            
            frmvalidator.addValidation("Nama", "required", "Nama lengkap harus diisi");
            frmvalidator.addValidation("Nama", "alphanumeric_space", "Nama lengkap hanya boleh diisi alphanumerik dan spasi");

            frmvalidator.addValidation("Email", "maxlen=50", "Email max 50 karakter");
            frmvalidator.addValidation("Email", "email", "Email tidak valid");

            frmvalidator.addValidation("Alamat", "maxlen=250", "Alamat max 250 karakter");
    
            // set callback function after pass all of validation
            frmvalidator.setCallbackFunction('submitForm()');
        }

        function getData(){
            
            var data = new Object;
            $('#form-data .form-control').each( function(key, element){
                data[$(this).attr('name')] = $(this).val();
            });

            data['Logo'] = ($('#form-data img').attr('src').indexOf("base64") > -1) ? $('#form-data img').attr('src') : "" ;

            return data;

        }

        function submitForm(){

            showLoading();

            var id =  $("input[name='Id']").val();
            var url = id ? "/api/organisasi/update" : "/api/organisasi/create";

             $.ajax({            
                type : 'post',
                url  : url,
                data : { 
                    Data : getData(),
                },
                timeout: 45000,
                success:function(response){
                    response = JSON.parse(response);
                    if(response.Status){
                        location.reload();
                    }else{
                        hideLoading();
                        swal(response.Message, "", "error")
                    }
                },
                error: function(response){
                    hideLoading();
                    swal('Terjadi kesalahan koneksi, periksa jaringan Anda', "", "error")
                }
            });         
                     
        }

        var table = $('table');
        table.dataTable({

            "language": {
                "aria": {
                    "sortAscending": ": activate to sort column ascending",
                    "sortDescending": ": activate to sort column descending"
                },
                "emptyTable": "Belum ada data",
                "info": "Menampilkan _START_ - _END_ dari _TOTAL_ data",
                "infoEmpty": "Tidak ada data yang ditemukan",
                "infoFiltered": "(filtered1 from _MAX_ total records)",
                "lengthMenu": "Menampilkan _MENU_",
                "search": "Cari:",
                "zeroRecords": "Tidak ada data yang ditemukan",
                "paginate": {
                    "previous":"Prev",
                    "next": "Next",
                    "last": "Last",
                    "first": "First"
                }
            },

            "lengthMenu": [
                [5, 10, 15, 20, -1],
                [5, 10, 15, 20, "All"] // change per page values here
            ],
            // set the initial value
            "pageLength": 5,            
            "pagingType": "bootstrap_full_number",
            "responsive": {
                details: {
                   
                }
            },
            "columnDefs": [
                {  // set default column settings
                    'orderable': false,
                    'targets': [6]
                }, 
                {
                    "searchable": false,
                    "targets": [6]
                }
            ],
            "order": [
                [0, "asc"]
            ]
        });

    </script>


    <!-- for upload image -->
    <div id="crop-modal" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                    <h4 id="title-crop">Pilih / potong bagian gambar</h4>
                    <h4 id="title-confirm">Konfirmasi pemilihan gambar</h4>
                </div>
                <div class="modal-body" style="margin: 10px">
                    <center>
                        <div id="body-crop">
                            <img id="image-crop" src="" alt="Picture">
                        </div>

                        <div id="body-confirm">
                            <img id="image-confirm" src="" alt="Picture">
                        </div>
                    </center>
                </div>

                <div class="modal-footer modal-button modal-button-crop">
                    <center>
                        <div id="button-crop">
                          <button type="button" class="btn btn-cool" data-dismiss="modal">Batal</button>
                          <button type="button" class="btn btn-primary" onclick="confirmProcess()">Pilih</button>
                        </div>

                        <div id="button-confirm">
                          <button type="button" class="btn btn-cool" onclick="cropProcess()">Kembali</button>
                          <button class="btn btn-primary" id="confirm-image">Simpan</a>
                        </div>
                    </center>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>

    <link rel="stylesheet" type="text/css" href="/modules/sabos/views/layouts/static/css/cropper.css">
    <script type="text/javascript" src="/modules/sabos/views/layouts/static/js/cropper.js"></script>

    <script>

        var globalResult;
        var limitPx = 300;
        var maxWidthPx = 533.333; // max width pixel, for popup modal purpose
        var maxUploadPx = 300; // setting maximum pixel for image upload, image will resize if pixel > thisValue   

        if (window.File && window.FileReader && window.FileList && window.Blob) {
            document.getElementById('Logo').addEventListener('change', handleFileSelect, false);
        } else {
            alert('The File APIs are not fully supported in this browser.');
        }

        function handleFileSelect(evt) {
            showLoading();
        
            var files = evt.target.files;
            var id = evt.target.id;

            file = files[0];
            if (files && file) {
                var fileType = file.type;
                if(fileType.indexOf('image/') < 0){
                    $('#Logo').val('');
                    hideLoading();
                    swal("", "File yang diizinkan hanya file gambar .jpg dan .png", "error");            
                    return false;               
                } else {
                    $('#upload-file-type').val(fileType);
                }

                var dataimage = "data:" + fileType + ";base64,";
                var reader = new FileReader();

                reader.onload = function(readerEvt) {

                    var binaryString = readerEvt.target.result;
                    var arrayButton = new Array();

                    var base64 = dataimage+btoa(binaryString);

                    var image = document.createElement('img');
                    image.src = base64;
                    
                    image.addEventListener('load', function() {
                        
                        var width = image.width;
                        var height = image.height;

                        if(width > height){
                          factorPx = limitPx / height;

                          height = limitPx;
                          width = width * factorPx;
                        } else {
                          factorPx = limitPx / width;
                          
                          width = limitPx;
                          height = height * factorPx;
                        }

                        if(width > maxWidthPx){
                            factorPx = maxWidthPx / width;

                            width = maxWidthPx;
                            height = height * factorPx;
                        }
                        
                        // Resize if window width < current width
                        var windowWidth = window.innerWidth - 100;
                        if(width > windowWidth){
                            factorPx = windowWidth / width;
                          
                            width = windowWidth;
                            height = factorPx * height;                     
                        }

                        var $image = $('#image-crop');

                        if($image.attr('src')){
                            $image.cropper('destroy');
                        }

                        $image.attr('src', dataimage+btoa(binaryString));

                        $('#crop-modal').modal('show');
                        cropProcess();

                        var options = {
                            scalable: false,
                            aspectRatio: 1,
                            minContainerHeight: height+1,
                            minContainerWidth: width+1,
                            minCanvasHeight: height,
                            minCanvasWidth: width,
                            toggleDragModeOnDblclick: false,
                            center: false,
                            zoomOnWheel: false
                        };

                        // Cropper
                        $image.on({
                            'built.cropper': function (e) {
                                $image.cropper('setCropBoxData', {"left":1,"top":1,"width":width,"height":height});                                     
                            }
                        }).cropper(options); 
                        
                        $('#Logo').val('');
                        hideLoading();
                        
                    });

                };

                reader.readAsBinaryString(file);
            }

            $('#Logo').val('');
        }

        function cropProcess(){

            $('#title-crop').show(); 
            $('#body-crop').show(); 
            $('#button-crop').show(); 

            $('#title-confirm').hide(); 
            $('#body-confirm').hide(); 
            $('#button-confirm').hide();
             
        }

        function confirmProcess(){
            
            showLoading();

            var image = $('#image-crop').cropper('getCroppedCanvas');
            var width, height;
            if(image.width > maxUploadPx || image.height > maxUploadPx){
                if(image.width > image.height){
                    factorPx = maxUploadPx / image.width;
                    width = maxUploadPx;
                    height = image.height * factorPx;
                } else {
                    factorPx = maxUploadPx / image.height;
                    height = maxUploadPx;
                    width = image.width * factorPx;
                }
            }
            
            var result = $('#image-crop').cropper('getCroppedCanvas', {width: width, height: height});

            if (result) {
                globalResult = result.toDataURL();
                $('#image-confirm').attr('src', globalResult);
            }

            $('#confirm-image').on("click",function(){
            $('#form-data img').attr('src', globalResult);
                $('#crop-modal').modal('hide');

                $('#confirm-image').unbind();
            });                            
            
            $('#title-crop').hide(); 
            $('#body-crop').hide(); 
            $('#button-crop').hide(); 

            $('#title-confirm').show(); 
            $('#body-confirm').show(); 
            $('#button-confirm').show(); 

            hideLoading();
                                
        }

    </script>
