<?php

    $data_peserta = $this->DataPeserta;

?>    
    
    <div class="page-content-col">
        <!-- BEGIN PAGE BASE CONTENT -->
        <div class="row">
            <div class="col-md-12">

                <?php include("sidebar.php") ?>

                <!-- BEGIN PROFILE CONTENT -->
                <div class="profile-content">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="portlet light bordered">
                                
                                <div class="portlet-title tabbable-line">
                                    <div class="caption caption-md">
                                        <i class="icon-globe theme-font hide"></i>
                                        <span class="caption-subject font-blue-madison bold uppercase">Peserta</span>
                                    </div>
                                </div>
                                <div class="portlet-body">

                                    <div class="mt-element-card mt-card-round mt-element-overlay" style="margin: 20px">

                                        <div class="row">
                                            <form class="col-md-9">
                                                <div class="form-group form-md-line-input form-md-floating-label">
                                                    <div class="input-icon">
                                                        <input type="text" class="form-control" onkeyup="search(this.value);" >
                                                        <label for="form_control_1">Cari peserta </label>
                                                        <i class="fa fa-search"></i>
                                                    </div>
                                                </div>
                                            </form>
                                        </div>      

                                        <div class="row" id="list_peserta">

                                            <?php 
                                                foreach ($data_peserta as $key => $peserta) {
                                                    if (!$peserta['FotoProfil'] && $peserta['JenisKelamin'] == 'Pria')
                                                        $peserta['FotoProfil'] = '/modules/sabos/views/layouts/static/images/placeholder-male.png';
                                                    elseif (!$peserta['FotoProfil'] && $peserta['JenisKelamin'] == 'Wanita')
                                                        $peserta['FotoProfil'] = '/modules/sabos/views/layouts/static/images/placeholder-female.png';
                                                    elseif (!$peserta['FotoProfil'] && !$peserta['JenisKelamin'])
                                                            $peserta['FotoProfil'] = '/modules/sabos/views/layouts/static/images/placeholder-male.png';
                                        
                                            ?>
                                                    <div class="col-lg-4 col-md-6 col-sm-6 col-xs-12">
                                                        <a href="/sabos/peserta/personal-info?id=<?= $peserta['o_id'] ?>" style="text-decoration: none; color: inherit;">
                                                            <div class="mt-card-item">
                                                                <div class="mt-card-avatar mt-overlay-1">
                                                                    <img src="<?= $peserta['FotoProfil'] ?>" />
                                                                </div>
                                                                <div class="mt-card-content">
                                                                    <h3 class="mt-card-name"><?= $peserta['Nama'] ?></h3>
                                                                    <p class="mt-card-desc font-grey-mint">
                                                                        <?= $peserta['Jabatan'] ?> 
                                                                        <br> 
                                                                        <?= $peserta['UnitOrganisasi'] ?>
                                                                        <br> 
                                                                        <?= $peserta['Organisasi'] ?>
                                                                    </p>
                                                                </div>
                                                            </div>
                                                        </a>
                                                    </div>
                                            <?php
                                                }
                                            ?>

                                        </div>

                                    </div>


                                </div>

                            </div>
                        </div>
                    </div>
                </div>
                <!-- END PROFILE CONTENT -->
            </div>
        </div>
        <!-- END PAGE BASE CONTENT -->
    </div>

    <script type="text/javascript">
    
        $(document).ready(function(){

        });

        $('.nav.nav-tabs a').click(function () {
            $('.caption-subject').html($(this).html());
        });

        function search(value){

            $.ajax({            
                type : 'post',
                url  : '/api/organisasi/search-peserta',
                data : { 
                    Search : value ,
                    IdOrganisasi : <?= $_GET['id'] ?>
                },
                timeout: 45000,
                success:function(response){
                    response = JSON.parse(response);
                    var html="";
                    if(response.Status){

                        $.each(response.Data, function( key, value ) {

                            if (!value.FotoProfil && value.JenisKelamin == 'Pria')
                                value.FotoProfil = '/modules/sabos/views/layouts/static/images/placeholder-male.png';
                            else if (!value.FotoProfil && value.JenisKelamin == 'Wanita')
                                value.FotoProfil = '/modules/sabos/views/layouts/static/images/placeholder-female.png';
                    
                            html += '<div class="col-lg-4 col-md-6 col-sm-6 col-xs-12">'+
                                        '<a href="/sabos/peserta/detail?id='+value.o_id+'" style="text-decoration: none; color: inherit;">'+
                                            '<div class="mt-card-item">'+
                                                '<div class="mt-card-avatar mt-overlay-1">'+
                                                    '<img src="'+value.FotoProfil+'"/>'+
                                                '</div>'+
                                                '<div class="mt-card-content">'+
                                                    '<h3 class="mt-card-name">'+value.Nama+'</h3>'+
                                                    '<p class="mt-card-desc font-grey-mint">'+
                                                        value.Jabatan+ 
                                                        '<br>'+ 
                                                        value.UnitOrganisasi+
                                                        '<br>'+ 
                                                        value.Organisasi+
                                                    '</p>'+
                                                '</div>'+
                                            '</div>'+
                                        '</a>'+
                                    '</div>';
                        });
                        $("#list_peserta").html(html);

                    }else{
                        hideLoading();
                        swal(response.Message, "", "error")
                    }
                },
                error: function(response){
                    hideLoading();
                    swal('Terjadi kesalahan koneksi, periksa jaringan Anda', "", "error")
                }
            }); 
        }

    </script>
