<?php 

    $data_unit_organisasi = $this->DataUnitOrganisasi;

?>   

    <div class="page-content-col">
        <!-- BEGIN PAGE BASE CONTENT -->
        <div class="row">
            <div class="col-md-12">

                <?php include("sidebar.php") ?>

                <!-- BEGIN PROFILE CONTENT -->
                <div class="profile-content">
                    <div class="row">
                        <div class="col-md-12">
                            <div class="portlet light bordered">
                                <div class="portlet-title tabbable-line">
                                    <div class="caption caption-md">
                                        <i class="icon-globe theme-font hide"></i>
                                        <span class="caption-subject font-blue-madison bold uppercase">Unit Kerja</span>
                                    </div>
                                </div>
                                <div class="portlet-body">

                                    <div class="mt-element-card mt-card-round mt-element-overlay" style="margin: 20px">
                                        <div class="row">
                                            <form class="col-md-9">
                                                <div class="form-group form-md-line-input form-md-floating-label">
                                                    <div class="input-icon">
                                                        <input type="text" class="form-control" onkeyup="search(this.value);">
                                                        <label for="form_control_1">Cari unit kerja </label>
                                                        <i class="fa fa-search"></i>
                                                    </div>
                                                </div>
                                            </form>
                                            <div class="col-sm-3">
                                                <div class="form-group form-md-line-input form-md-floating-label pull-right">
                                                    <button class="btn blue btn-next" onclick="confirmManageData()">
                                                        <i class="fa fa-database"></i> 
                                                        Manajemen Data
                                                    </button>
                                                </div>
                                            </div>     
                                        </div>      

                                        <div class="row" id="list_unit_organisasi">

                                            <?php foreach ($data_unit_organisasi as $key => $unit_organisasi) { ?>
                                                
                                                    <div class="col-lg-6 col-md-6 col-sm-6 col-xs-12" style="padding: 10px;">
                                                        <a href="/sabos/unit-organisasi/peserta?id=<?= $unit_organisasi['o_id'] ?>" style="text-decoration: none; color: inherit;">
                                                            <div style="padding: 10px; margin-bottom: 10px; background: #eee;">
                                                                <h3><?= $unit_organisasi['Nama'] ?></h3>
                                                                <p> 
                                                                    Total Peserta : <?= $unit_organisasi['Peserta'] ?>
                                                                </p>
                                                            </div>
                                                        </a>
                                                    </div>   

                                            <?php } ?>
                                            
                                        </div>

                                    </div>

                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <!-- END PROFILE CONTENT -->
            </div>
        </div>
        <!-- END PAGE BASE CONTENT -->
    </div>

    <script type="text/javascript">
    
        $(document).ready(function(){

        });

        $('.nav.nav-tabs a').click(function () {
            $('.caption-subject').html($(this).html());
        });

        function confirmManageData(){
            bootbox.dialog({
                message: "Apakah Anda yakin ingin melakukan manajemen data unit kerja? <br /><br />Manajement data meliputi <b> menambah, mengubah dan menghapus </b> data unit kerja. <br /><b>Berhati-hatilah</b> dalam melakukan manajemen data.",
                title: "Informasi Penting",
                buttons: {
                    success: {
                        label: "Ya",
                        className: "green",
                        callback: function() {
                            window.location.href = '/sabos/unit-organisasi/manajemen-data?id=<?= $_GET["id"] ?>';
                        }
                    },
                    danger: {
                        label: "Tidak",
                        className: "red",
                    }
                }
            });
        }

        function search(value){

            $.ajax({            
                type : 'post',
                url  : '/api/organisasi/search-unit-organisasi',
                data : { 
                    Search : value,
                    IdOrganisasi : '<?= $_GET['id']?>'
                },
                timeout: 45000,
                success:function(response){
                    response = JSON.parse(response);
                    var html="";
                    if(response.Status){

                        $.each(response.Data, function( key, value ) {
                            value.Logo = value.Logo ? value.Logo : '/modules/sabos/views/layouts/static/images/placeholder-logo.png'; 
                            html += '<div class="col-lg-6 col-md-6 col-sm-6 col-xs-12" style="padding: 10px;">'+
                                        '<a href="/sabos/unit-organisasi/detail?id='+value.o_id+'" style="text-decoration: none; color: inherit;">'+
                                            '<div style="padding: 10px; margin-bottom: 10px; background: #eee;">'+
                                                '<img src="'+value.Logo+'" alt="" class="pull-right" style="width: 80px;">'+
                                                '<h3>'+value.Nama+'</h3>'+
                                                '<p>'+ 
                                                    'Total Peserta : '+value.Peserta+
                                                '</p>'+
                                            '</div>'+
                                        '</a>'+
                                    '</div>';
                        });
                        $("#list_unit_organisasi").html(html);

                    }else{
                        hideLoading();
                        swal(response.Message, "", "error")
                    }
                },
                error: function(response){
                    hideLoading();
                    swal('Terjadi kesalahan koneksi, periksa jaringan Anda', "", "error")
                }
            }); 
        }

    </script>
