<?php

    $data_peserta = $this->DataPeserta;  

?>
    <div class="mt-element-card mt-card-round mt-element-overlay" style="margin: 20px">

	    <div class="row">
            <div class="col-sm-6">
				<div class="form-group form-md-line-input form-md-floating-label">
				    <div class="input-icon">
				        <input type="text" class="form-control" onkeyup="search(this.value);" >
                        <span class="help-block"> Berdasarkan nama peserta, email, provinsi ataupun kota </span>
                        <label for="form_control_1">Cari peserta </label>
                        <i class="fa fa-search"></i>
				    </div>
		        </div>
            </div>

            <!-- <div class="col-sm-6">
                <div class="form-group form-md-line-input form-md-floating-label pull-right">
                    <button class="btn blue btn-next" onclick="confirmManageData()">
                        <i class="fa fa-database"></i> 
                        Manajemen Data
                    </button>
                </div>
            </div>       -->      
		</div>    	

        <div class="row" id="list_peserta">

            <?php 
                foreach ($data_peserta as $peserta) { 

                    if (!$peserta['FotoProfil'] && $peserta['JenisKelamin'] == 'Pria')
                        $peserta['FotoProfil'] = '/modules/sabos/views/layouts/static/images/placeholder-male.png';
                    elseif (!$peserta['FotoProfil'] && $peserta['JenisKelamin'] == 'Wanita')
                        $peserta['FotoProfil'] = '/modules/sabos/views/layouts/static/images/placeholder-female.png';
                    elseif (!$peserta['FotoProfil'] && !$peserta['JenisKelamin'])
                        $peserta['FotoProfil'] = '/modules/sabos/views/layouts/static/images/placeholder-male.png';
            ?>
                    <div class="col-lg-3 col-md-4 col-sm-6 col-xs-12">
                    	<a href="/sabos/peserta/personal-info?id=<?= $peserta['o_id'] ?>" style="text-decoration: none; color: inherit;">
        	                <div class="mt-card-item">
        	                    <div class="mt-card-avatar mt-overlay-1">
        	                        <img src='<?= $peserta['FotoProfil'] ?>'" />
        	                    </div>
        	                    <div class="mt-card-content">
        	                        <h3 class="mt-card-name"><?= $peserta['Nama']?></h3>
        	                        <p class="mt-card-desc font-grey-mint">
        	                        	<?= $peserta['Email'] ?> 
                                        <br> 
                                        <?= $peserta['Provinsi'] ? $peserta['Provinsi'] : '[Belum pilih provinsi]' ?>
                                        <br> 
                                        <?= $peserta['Kota'] ? $peserta['Kota'] : '[Belum pilih kota]' ?>
        	                        </p>
        	                    </div>
        	                </div>
        	            </a>
                    </div>
            <?php } ?>

        </div>

    </div>

    <script type="text/javascript">

        function search(value){

            $.ajax({            
                type : 'post',
                url  : '/api/peserta/search-independent',
                data : { 
                    Search : value 
                },
                timeout: 45000,
                success:function(response){
                    response = JSON.parse(response);
                    var html="";
                    if(response.Status){

                        $.each(response.Data, function( key, value ) {

                            if (!value.FotoProfil && value.JenisKelamin == 'Pria')
                                value.FotoProfil = '/modules/sabos/views/layouts/static/images/placeholder-male.png';
                            else if (!value.FotoProfil && value.JenisKelamin == 'Wanita')
                                value.FotoProfil = '/modules/sabos/views/layouts/static/images/placeholder-female.png';
                            else if (!value.FotoProfil && !value.JenisKelamin)
                                value.FotoProfil = '/modules/sabos/views/layouts/static/images/placeholder-male.png';
                    
                            html += '<div class="col-lg-3 col-md-4 col-sm-6 col-xs-12">'+
                                        '<a href="/sabos/peserta/detail?id='+value.o_id+'" style="text-decoration: none; color: inherit;">'+
                                            '<div class="mt-card-item">'+
                                                '<div class="mt-card-avatar mt-overlay-1">'+
                                                    '<img src="'+value.FotoProfil+'"/>'+
                                                '</div>'+
                                                '<div class="mt-card-content">'+
                                                    '<h3 class="mt-card-name">'+value.Nama+'</h3>'+
                                                    '<p class="mt-card-desc font-grey-mint">'+
                                                        value.Email+ 
                                                        '<br>'+ 
                                                        (value.Provinsi ? value.Provinsi : '[Belum pilih kota]') +
                                                        '<br>'+ 
                                                        (value.Kota ? value.Kota : '[Belum pilih kota]') +
                                                    '</p>'+
                                                '</div>'+
                                            '</div>'+
                                        '</a>'+
                                    '</div>';
                        });
                        $("#list_peserta").html(html);

                    }else{
                        hideLoading();
                        swal(response.Message, "", "error")
                    }
                },
                error: function(response){
                    hideLoading();
                    swal('Terjadi kesalahan koneksi, periksa jaringan Anda', "", "error")
                }
            }); 
        }
    </script>
