<?php 

    $data = $this->data;
    $city = $this->City;
    $province = $this->Province;

?>
    
    <style>
        form .form-group .error-message{
            color: red;
        }
    </style>

    <link href="/modules/sabos/views/layouts/static/assets/global/plugins/bootstrap-datepicker/css/bootstrap-datepicker3.min.css" rel="stylesheet" type="text/css" />

    <script src="/modules/sabos/views/layouts/static/assets/global/plugins/bootstrap-datepicker/js/bootstrap-datepicker.min.js" type="text/javascript"></script>
    <script type="text/javascript" src="/modules/sabos/views/layouts/static/js/custom/validator.js"></script>

    <div class="portlet light bordered">
        <div class="portlet-title">
            <div class="caption font-dark">
                <i class="icon-settings font-dark"></i>
                <span class="caption-subject bold uppercase"> Manajemen Data Peserta</span>
            </div>
            <div class="tools"> </div>
        </div>
        <div class="portlet-body">
            <div class="table-toolbar">
                <div class="row  text-center">
                    <div class="btn-group">
                        <button class="btn sbold green btn-add"> Tambah Baru
                            <i class="fa fa-plus"></i>
                        </button>
                    </div>
                </div>
            </div>
            <table class="table table-striped table-bordered table-hover">
                <thead>
                    <tr>
                        <th class="all"> Nama </th>
                        <th> Username </th>
                        <th class="none"> Email </th>
                        <th class="none"> Telepon </th>
                        <th class="none"> Jenis Kelamin </th>
                        <th class="none"> Tingkat Pendididkan </th>
                        <th class="none"> Tanggal Lahir </th>
                        <th class="none"> Provinsi </th>
                        <th class="none"> Kota </th>
                        <th class="none"> Jabatan </th>
                        <th class="none"> Nip </th>
                        <th class="none"> Foto </th>
                        <th class="all">  </th>
                    </tr>
                </thead>
                <tbody>

                <?php foreach($data as $key => $temp) { ?>

                    <tr class="odd gradeX">
                        <td> <?= $temp->Nama ?> </td>
                        <td> <?= $temp->Username ?> </td>
                        <td> <?= $temp->Email ?> </td>
                        <td> <?= $temp->Telepon ?> </td>
                        <td> <?= $temp->JenisKelamin ?> </td>
                        <td> <?= $temp->TingkatPendidikan ?> </td>
                        <td> <?= $temp->TanggalLahir ?> </td>
                        <td> <?= $temp->Provinsi ?> </td>
                        <td> <?= $temp->Kota ?> </td>
                        <td> <?= $temp->Jabatan ?> </td>
                        <td> <?= $temp->Nip ?> </td>                        
                        <td> 
                        <?php
                            if (!$temp->Foto && $temp->JenisKelamin == 'Pria')
                                $temp->Foto = '/modules/sabos/views/layouts/static/images/placeholder-male.png';
                            elseif (!$temp->Foto && $peserta['JenisKelamin'] == 'Wanita')
                                $temp->Foto = '/modules/sabos/views/layouts/static/images/placeholder-female.png';
                            elseif  (!$temp->Foto && !$peserta['JenisKelamin']) 
                                $temp->Foto = '/modules/sabos/views/layouts/static/images/placeholder-male.png';
                        ?>
                            <img src="<?= $temp->Foto ?>" alt="" class="text-center" style="width: 80px;"> 
                        </td>
                        <td>
                            <div class="btn-group">
                                <button class="btn btn-xs green dropdown-toggle" type="button" data-toggle="dropdown" aria-expanded="false"> <i class="icon-settings"></i>
                                    <i class="fa fa-angle-down"></i>
                                </button>
                                <ul class="dropdown-menu pull-left" role="menu">
                                    <li>
                                        <a href="/sabos/peserta/detail?id=<?= $temp->o_id ?>" target="_blank">
                                            <i class="icon-eye"></i> Lihat Detail 
                                        </a>
                                    </li>
                                    <li>
                                        <a href="javascript:void(0)" onclick="editData(<?= $key ?>,<?= $temp->o_id ?>)">
                                            <i class="icon-pencil"></i> Ubah 
                                        </a>
                                    </li>
                                    <li>
                                        <a href="javascript:void(0)" onclick="deleteData(<?= $key ?>, <?= $temp->o_id ?>)">
                                            <i class="icon-fire"></i> Hapus 
                                        </a>
                                    </li>
                                    <li>
                                        <a href="javascript:void(0)" onclick="resetPassword(<?= $key ?>, <?= $temp->o_id ?>)">
                                            <i class="icon-reload"></i> Reset 
                                        </a>
                                    </li>
                                </ul>
                            </div>
                        </td>
                    </tr>

                <?php } ?>

                </tbody>
            </table>
        </div>
    </div>

    <div id="modal-form" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-full">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                    <h4 class="modal-title">Modal Title</h4>
                </div>
                <div class="modal-body">
                    <form id="form-data" role="form" class="form-horizontal" onsubmit="return false">
                        <div class="form-body">

                            <div class="form-group">
                                <label class="col-md-2 control-label">Nama Peserta</label>
                                <div class="col-md-10">
                                    <input type="hidden" class="form-control" name="Id">
                                    <input type="text" class="form-control" name="Nama" placeholder="Masukan nama peserta">
                                    <span class="error-message"></span>
                                </div>
                            </div>

                            <div class="form-group">
                                <label class="col-md-2 control-label">Username</label>
                                <div class="col-md-10">
                                    <input type="text" class="form-control" name="Username" placeholder="Masukan username">
                                    <span class="error-message"></span>
                                </div>
                            </div>

                            <div class="form-group">
                                <label class="col-md-2 control-label"">Email</label>
                                <div class="col-md-10">
                                    <input type="text" class="form-control" name="Email" placeholder="Masukan email">
                                    <span class="error-message"></span>
                                </div>
                            </div>

                            <div class="form-group">
                                <label class="col-md-2 control-label"">Telepon</label>
                                <div class="col-md-10">
                                    <input type="text" class="form-control" name="Telepon" placeholder="Masukan telepon">
                                    <span class="error-message"></span>
                                </div>
                            </div>

                            <div class="form-group">
                                <label class="col-md-2 control-label""> Jenis Kelamin </label>
                                <div class="col-md-10">
                                    <select class="form-control" name="JenisKelamin">
                                        <option value=""></option>
                                        <option value="Pria">Pria</option>
                                        <option value="Wanita">Wanita</option>
                                    </select>
                                    <span class="error-message"></span>
                                </div>
                            </div>

                            <div class="form-group">
                                <label class="col-md-2 control-label""> Tingkat Pendidikan </label>
                                <div class="col-md-10">
                                    <select class="form-control" name="TingkatPendidikan" tabindex="1">
                                        <option value=""></option>
                                        <option value="SMA">SMA</option>
                                        <option value="D3">D3</option>
                                        <option value="S1">S1</option>
                                        <option value="S2">S2</option>
                                        <option value="S3">S3</option>
                                    </select>
                                    <span class="error-message"></span>
                                </div>
                            </div>

                            <div class="form-group">
                                <label class="col-md-2 control-label""> Tanggal Lahir </label>
                                <div class="col-md-10">
                                    <div class="input-group date date-picker">
                                        <input type="text" name="TanggalLahir" readonly class="form-control" />
                                        <span class="input-group-btn">
                                            <button class="btn default date-set" type="button">
                                                <i class="fa fa-calendar"></i>
                                            </button>
                                        </span>
                                    </div>
                                    <span class="error-message"></span>
                                </div>
                            </div>

                            <div class="form-group">
                                <label class="col-md-2 control-label""> Provinsi </label>
                                <div class="col-md-10">
                                    <select class="form-control" name="Provinsi" tabindex="1" onchange="changeProvince();" id="province">
                                        <option value=""> Pilih Provinsi </option>
                                        <?php foreach ($province as $key => $value) { ?>
                                            <option  value="<?= $value['Name'] ?>" data-filter="<?= $value['o_id'] ?>"><?= $value['Name'] ?></option>
                                        <?php } ?>
                                    </select>
                                    <span class="error-message"></span>
                                </div>
                            </div>

                            <div class="form-group">
                                <label class="col-md-2 control-label""> Kota </label>
                                <div class="col-md-10">
                                    <select class="form-control" name="Kota" tabindex="1" id="city">
                                        <option value=""> Pilih Kota </option>
                                        <?php foreach ($city as $key => $value) { ?>
                                            <option value="<?= $value['Name'] ?>" class="hide" data-filter="<?= $value['Province__id'] ?>"><?= $value['Name'] ?></option>
                                        <?php } ?>
                                    </select>
                                    <span class="error-message"></span>
                                </div>
                            </div>

                            <div class="form-group">
                                <label class="col-md-2 control-label""> Jabatan </label>
                                <div class="col-md-10">
                                    <input type="text" class="form-control" name="Jabatan" placeholder="Masukan ">
                                    <span class="error-message"></span>
                                </div>
                            </div>

                            <div class="form-group">
                                <label class="col-md-2 control-label""> Nomor Induk Pegawai (NIP) </label>
                                <div class="col-md-10">
                                    <input type="text" class="form-control" name="Nip" placeholder="Masukan ">
                                    <span class="error-message"></span>
                                </div>
                            </div>

                            <div class="form-group form-md-line-input">
                                <label class="col-md-2 control-label">Foto Peserta</label>
                                <div class="col-md-10">
                                    <img src="/modules/sabos/views/layouts/static/images/placeholder-male.png" alt="" style="width: 100px;" onclick="$('[type=file]').click()">
                                    <input type="file" class="hidden" id="Foto" name="Foto" accept="image/*" />
                                    <span class="error-message"></span>
                                </div>
                            </div>

                        </div>
                    </form>
                </div>
                <div class="modal-footer">
                    <button type="button" data-dismiss="modal" class="btn btn-outline dark">Batal</button>
                    <button type="button" class="btn green" onclick="$('#form-data').submit();">Simpan</button>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>

    <script type="text/javascript">

        changeProvince(true);
        function changeProvince(auto){
            var city = '#city';
            var province = '#province';
            
            var provinceSelected = $(province).find(":selected").attr('data-filter');

            if(!$(province).val()){
                $(city).val('');
                $(city).attr('disabled', 'disabled');

                return false;
            }
            else{
                $(city).removeAttr('disabled');            
            }

            if(!auto)
                $(city).val('');

            $(city).find("option").attr('class', 'hide');
            $(city).find("[data-filter='" + provinceSelected + "']").attr('class', 'show');
        }

        var corpus = JSON.parse('<?= json_encode($data) ?>');

        $(document).ready( function() {

            $('.date-picker').datepicker({
                format: 'dd/mm/yyyy',
                isRTL: App.isRTL(),
                pickerPosition: (App.isRTL() ? "bottom-right" : "bottom-left"),
                startView: 2,
                autoclose: true
            });

            initValidation();

        });

        $('.btn-add').on("click",function(){
            $('#modal-form .modal-title').html('Tambah Data Peserta');
            $('#form-data .error-message').html('').siblings('.form-control').css('border', ''); // remove style error

            $('#form-data .form-control').val('');
            $('#form-data img').attr('src', '/modules/sabos/views/layouts/static/images/placeholder-male.png');

            // generate username with timestamp
            $('#form-data [name=Username]').val(generateUsername);

            $('#modal-form').modal('show');
        });                            

        function editData(key, Id){
            $('#modal-form .modal-title').html('Ubah Data Peserta');
            $('#form-data .error-message').html('').siblings('.form-control').css('border', ''); // remove style error

            var data = corpus[key];

            $('#form-data .form-control').each( function(key, element){
                $(this).val(data[$(this).attr('name')]);
            });

            if (!data['Foto'] && data['JenisKelamin'] == 'Pria')
                data['Foto'] = '/modules/sabos/views/layouts/static/images/placeholder-male.png';
            else if (!data['Foto'] && data['JenisKelamin'] == 'Wanita')
                data['Foto'] = '/modules/sabos/views/layouts/static/images/placeholder-female.png';
            else if (!data['Foto'] && !data['JenisKelamin'])
                data['Foto'] = '/modules/sabos/views/layouts/static/images/placeholder-male.png';

            $('#form-data img').attr('src', data['Foto']);

            $("input[name='Id']").val(Id);

            $('#modal-form').modal('show');

        }

        function deleteData(key, Id){

            var data = corpus[key];

            bootbox.dialog({
                message: "Apakah Anda yakin menghapus <b>'" + data['Nama'] + "'</b>. <br /><br /><b>Berhati-hatilah</b> dalam menghapus data.",                title: "Informasi Penting",
                buttons: {
                    success: {
                        label: "Ya",
                        className: "green",
                        callback: function() {

                            $.ajax({            
                                type : 'post',
                                url  : "/api/peserta/delete",
                                data : { 
                                    Id : Id,
                                },
                                timeout: 45000,
                                success:function(response){
                                    response = JSON.parse(response);
                                    if(response.Status){
                                        location.reload();
                                    }else{
                                        hideLoading();
                                        swal(response.Message, "", "error")
                                    }
                                },
                                error: function(response){
                                    hideLoading();
                                    swal('Terjadi kesalahan koneksi, periksa jaringan Anda', "", "error")
                                }
                            });                    
                        }
                    },
                    danger: {
                        label: "Tidak",
                        className: "red",
                    }
                }
            });
        }
        
        function resetPassword(key,Id){

            data = new Object;
            data.Id = Id;
            data.Reset = true;
                
            $.ajax({            
                type : 'post',
                url  : "/api/peserta/update",
                data : { 
                    Data :data
                },
                timeout: 45000,
                success:function(response){
                    response = JSON.parse(response);
                    if(response.Status){                        
                        swal({
                            title: "Informasi Akun",
                            text: "Username : " +response.Data.Username + "\nPassword : " + response.Data.Password,
                            type: "success",
                            confirmButtonText: "Ok",
                            closeOnConfirm: false
                        }); 
                    }else{
                        swal(response.Message, "", "error")
                    }
                    hideLoading();                    
                },
                error: function(response){
                    hideLoading();
                    swal('Terjadi kesalahan koneksi, periksa jaringan Anda', "", "error")
                }
            });            

        }

        function initValidation(){            
            var frmvalidator  = new Validator("form-data");
            
            frmvalidator.EnableOnPageErrorDisplay();
            frmvalidator.EnableMsgsTogether();
            
            frmvalidator.addValidation("Nama", "required", "Nama lengkap harus diisi");
            frmvalidator.addValidation("Nama", "alphanumeric_space", "Nama lengkap hanya boleh diisi alphanumerik dan spasi");

            frmvalidator.addValidation("Username", "required", "Username harus diisi");

            frmvalidator.addValidation("Email", "maxlen=50", "Email max 50 karakter");
            frmvalidator.addValidation("Email", "email", "Email tidak valid");

            frmvalidator.addValidation("Telepon", "numeric", "Nama lengkap hanya boleh diisi number");
            frmvalidator.addValidation("Nip", "numeric", "Nama lengkap hanya boleh diisi number");

            // set callback function after pass all of validation
            frmvalidator.setCallbackFunction('submitForm()');
        }

        function getData(){
            
            var data = new Object;
            $('#form-data .form-control').each( function(key, element){
                data[$(this).attr('name')] = $(this).val();
            });

            data['Foto'] = ($('#form-data img').attr('src').indexOf("base64") > -1) ? $('#form-data img').attr('src') : "" ;
            data.IdUnitOrganisasi = "<?= $_GET['id'] ?>";

            return data;

        }

        function submitForm(){
            
            showLoading();

            var id =  $("input[name='Id']").val();
            var url = id ? "/api/peserta/update" : "/api/peserta/create";

            $.ajax({            
                type : 'post',
                url  : url,
                data : { 
                    Data : getData(),
                },
                timeout: 45000,
                success:function(response){
                    response = JSON.parse(response);
                    if(response.Status){
                        if(!id) {
                            swal({
                                  title: "Informasi Akun",
                                  text: "Username : " + response.Data.Username + "\nPassword : " + response.Data.Password,
                                  type: "success",
                                  confirmButtonText: "Ok",
                                  closeOnConfirm: false
                                },
                                function(){
                                  location.reload();
                                });
                            hideLoading();
                        }else {
                            location.reload();
                        }                                        
                        
                    }else{
                        hideLoading();
                        swal(response.Message, "", "error")
                    }
                },
                error: function(response){
                    hideLoading();
                    swal('Terjadi kesalahan koneksi, periksa jaringan Anda', "", "error")
                }
            });         
        }

        function generateUsername(){
            return Math.round(new Date().getTime()/1000);            
        }

        var table = $('table');
        table.dataTable({

            "language": {
                "aria": {
                    "sortAscending": ": activate to sort column ascending",
                    "sortDescending": ": activate to sort column descending"
                },
                "emptyTable": "Belum ada data",
                "info": "Menampilkan _START_ - _END_ dari _TOTAL_ data",
                "infoEmpty": "Tidak ada data yang ditemukan",
                "infoFiltered": "(filtered1 from _MAX_ total records)",
                "lengthMenu": "Menampilkan _MENU_",
                "search": "Cari:",
                "zeroRecords": "Tidak ada data yang ditemukan",
                "paginate": {
                    "previous":"Prev",
                    "next": "Next",
                    "last": "Last",
                    "first": "First"
                }
            },

            "lengthMenu": [
                [5, 10, 15, 20, -1],
                [5, 10, 15, 20, "All"] // change per page values here
            ],
            // set the initial value
            "pageLength": 5,            
            "pagingType": "bootstrap_full_number",
            "responsive": {
                details: {
                   
                }
            },
            "columnDefs": [
                {  // set default column settings
                    'orderable': false,
                    'targets': [6]
                }, 
                {
                    "searchable": false,
                    "targets": [6]
                }
            ],
            "order": [
                [0, "asc"]
            ]
        });

    </script>


    <!-- for upload image -->
    <div id="crop-modal" class="modal fade" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <button type="button" class="close" data-dismiss="modal" aria-hidden="true"></button>
                    <h4 id="title-crop">Pilih / potong bagian gambar</h4>
                    <h4 id="title-confirm">Konfirmasi pemilihan gambar</h4>
                </div>
                <div class="modal-body" style="margin: 10px">
                    <center>
                        <div id="body-crop">
                            <img id="image-crop" src="" alt="Picture">
                        </div>

                        <div id="body-confirm">
                            <img id="image-confirm" src="" alt="Picture">
                        </div>
                    </center>
                </div>

                <div class="modal-footer modal-button modal-button-crop">
                    <center>
                        <div id="button-crop">
                          <button type="button" class="btn btn-cool" data-dismiss="modal">Batal</button>
                          <button type="button" class="btn btn-primary" onclick="confirmProcess()">Pilih</button>
                        </div>

                        <div id="button-confirm">
                          <button type="button" class="btn btn-cool" onclick="cropProcess()">Kembali</button>
                          <button class="btn btn-primary" id="confirm-image">Simpan</a>
                        </div>
                    </center>
                </div>
            </div>
            <!-- /.modal-content -->
        </div>
        <!-- /.modal-dialog -->
    </div>

    <link rel="stylesheet" type="text/css" href="/modules/sabos/views/layouts/static/css/cropper.css">
    <script type="text/javascript" src="/modules/sabos/views/layouts/static/js/cropper.js"></script>

    <script>

        var globalResult;
        var limitPx = 300;
        var maxWidthPx = 533.333; // max width pixel, for popup modal purpose
        var maxUploadPx = 300; // setting maximum pixel for image upload, image will resize if pixel > thisValue   

        if (window.File && window.FileReader && window.FileList && window.Blob) {
            document.getElementById('Foto').addEventListener('change', handleFileSelect, false);
        } else {
            alert('The File APIs are not fully supported in this browser.');
        }

        function handleFileSelect(evt) {
            showLoading();
        
            var files = evt.target.files;
            var id = evt.target.id;

            file = files[0];
            if (files && file) {
                var fileType = file.type;
                if(fileType.indexOf('image/') < 0){
                    $('#Foto').val('');
                    hideLoading();
                    swal("", "File yang diizinkan hanya file gambar .jpg dan .png", "error");            
                    return false;               
                } else {
                    $('#upload-file-type').val(fileType);
                }

                var dataimage = "data:" + fileType + ";base64,";
                var reader = new FileReader();

                reader.onload = function(readerEvt) {

                    var binaryString = readerEvt.target.result;
                    var arrayButton = new Array();

                    var base64 = dataimage+btoa(binaryString);

                    var image = document.createElement('img');
                    image.src = base64;
                    
                    image.addEventListener('load', function() {
                        
                        var width = image.width;
                        var height = image.height;

                        if(width > height){
                          factorPx = limitPx / height;

                          height = limitPx;
                          width = width * factorPx;
                        } else {
                          factorPx = limitPx / width;
                          
                          width = limitPx;
                          height = height * factorPx;
                        }

                        if(width > maxWidthPx){
                            factorPx = maxWidthPx / width;

                            width = maxWidthPx;
                            height = height * factorPx;
                        }
                        
                        // Resize if window width < current width
                        var windowWidth = window.innerWidth - 100;
                        if(width > windowWidth){
                            factorPx = windowWidth / width;
                          
                            width = windowWidth;
                            height = factorPx * height;                     
                        }

                        var $image = $('#image-crop');

                        if($image.attr('src')){
                            $image.cropper('destroy');
                        }

                        $image.attr('src', dataimage+btoa(binaryString));

                        $('#crop-modal').modal('show');
                        cropProcess();

                        var options = {
                            scalable: false,
                            aspectRatio: 1,
                            minContainerHeight: height+1,
                            minContainerWidth: width+1,
                            minCanvasHeight: height,
                            minCanvasWidth: width,
                            toggleDragModeOnDblclick: false,
                            center: false,
                            zoomOnWheel: false
                        };

                        // Cropper
                        $image.on({
                            'built.cropper': function (e) {
                                $image.cropper('setCropBoxData', {"left":1,"top":1,"width":width,"height":height});                                     
                            }
                        }).cropper(options); 
                        
                        $('#Foto').val('');
                        hideLoading();
                        
                    });

                };

                reader.readAsBinaryString(file);
            }

            $('#Foto').val('');
        }

        function cropProcess(){

            $('#title-crop').show(); 
            $('#body-crop').show(); 
            $('#button-crop').show(); 

            $('#title-confirm').hide(); 
            $('#body-confirm').hide(); 
            $('#button-confirm').hide();
             
        }

        function confirmProcess(){
            
            showLoading();

            var image = $('#image-crop').cropper('getCroppedCanvas');
            var width, height;
            if(image.width > maxUploadPx || image.height > maxUploadPx){
                if(image.width > image.height){
                    factorPx = maxUploadPx / image.width;
                    width = maxUploadPx;
                    height = image.height * factorPx;
                } else {
                    factorPx = maxUploadPx / image.height;
                    height = maxUploadPx;
                    width = image.width * factorPx;
                }
            }
            
            var result = $('#image-crop').cropper('getCroppedCanvas', {width: width, height: height});

            if (result) {
                globalResult = result.toDataURL();
                $('#image-confirm').attr('src', globalResult);
            }

            $('#confirm-image').on("click",function(){
            $('#form-data img').attr('src', globalResult);
                $('#crop-modal').modal('hide');

                $('#confirm-image').unbind();
            });                            
            
            $('#title-crop').hide(); 
            $('#body-crop').hide(); 
            $('#button-crop').hide(); 

            $('#title-confirm').show(); 
            $('#body-confirm').show(); 
            $('#button-confirm').show(); 

            hideLoading();
                                
        }

    </script>
